
%clear
%function [] = CreateTable(X_select_draws_all,xmode,priors)   
%priors = DefinePriors_fun;

% CurrentDraws ='13-Sep-2015_1440Metro_CPI_USPini0_2';
% 
% %% Posteriors
% 
% load(CurrentDraws, 'X_draws', 'Logpost_draws');

%nxd = 3; discard = round(size(X_draws,2)/nxd);

%load FirstTest

namesPriors=fieldnames(priors);


paramNames = namesPriors;
         
         paramNames{1} = '$a_{x,1}$';
         paramNames{2} = '$a_{x,2}$';
         paramNames{3} ='$\alpha$';
         paramNames{4} ='$\gamma$';
         paramNames{5} ='$\rho_{u^{*}}$';
         paramNames{6} ='$\rho_{\mu}$';
         paramNames{7} ='$\sigma_{x}$';
         paramNames{8} ='$\sigma_{\mu}$';
         paramNames{9} ='$\sigma{\pi^{*}}$';
         paramNames{10} ='$\sigma_{u^{*}}$';
         paramNames{11} = '$\sigma_{o,\pi^{510Y}}$';
         paramNames{12} ='$\sigma_{o,\pi^{12Q}}$';
         
 
nPriors=size(namesPriors,1);

Pmean = NaN(nPriors,1);
Pstd = NaN(nPriors,1);

% Tranform X_draws when needed

%X_drawsT = X_draws;
X_drawsT = X_draws_full;
X_drawsT(3,:) = (1-X_drawsT(3,:)).*(1-X_drawsT(3,:).*0.99)./X_drawsT(3,:);
 
meanPriors = NaN(nPriors,1);

stdPriors = NaN(nPriors,1);

distNames = cell(nPriors,1);

for j = 1:nPriors
    
    meanPriors(j) = priors.(namesPriors{j}).mean;
    stdPriors(j) = priors.(namesPriors{j}).std;
    
    
    switch priors.(namesPriors{j}).shape;
        
        case 'normpdf'
       
    distNames{j} = 'Normal';
    
        case 'betapdf'
            
    distNames{j} = 'Beta';                
        
        case 'gampdf'
    
    distNames{j} = 'Gamma';
    
        case 'invgampdf'

    distNames{j} = 'InvGamma';
        
            
    end
    
end  
    
    
%     param = char(priors.estimated(j,:));
%     
%     
%     X_drawsT(j,:) = eval(['priors.',param,'.trans'])*exp(X_drawsT(j,:))...
%                     +(1 - eval(['priors.',param,'.trans']))*X_drawsT(j,:);
%                 
%                 
%     meanPriors(j) = eval(['priors.',param,'.mean']);
%     
%     stdPriors(j) = eval(['priors.',param,'.std']);
    
%end    

% Select mode

% [~, b] = max(Logpost_draws);
%         
% fvalmode = Logpost_draws(b);
%     
% xmode = X_drawsT(:,b);


%PosteriorTab = xmode;


% Mean and Standard Deviation

%PosteriorTab = [xmode mean(X_drawsT,2) std(X_drawsT,0,2)];
%PosteriorTab = [xmode mean(X_drawsT,2)];
PosteriorTab = mean(X_drawsT,2);

% Percentiles

PosteriorTab = [PosteriorTab prctile(X_drawsT,[5,95],2)];


%% Priors

allData = [meanPriors stdPriors PosteriorTab];

data       = num2cell(allData);
tableBody  = [paramNames distNames data];

%save DataBok3 tableBody





%% Format Table

%load DataBok % this loads tableBody

% headerLine1 = {'', 'Prior', NaN, NaN,'Posterior',NaN,NaN,NaN}; % Nan is like a merge
% headerLine2 = {'', 'Dist.', 'Mean', 'Std','Mode','Mean','5\%','95\%'};

headerLine1 = {'', 'Prior', NaN, NaN,'Posterior',NaN,NaN}; % Nan is like a merge
headerLine2 = {'', 'Dist.', 'Mean', 'Std','Mean','5\%','95\%'};


header = [headerLine1; headerLine2];
style1 = 'll';

style2 = repmat('c',1,size(header,2)-2);

style = [style1 style2];
style = [style(1:4),'|',style(5:end)];



% paramNames = priors.names;
% distNames  = priors.distnames;

NameTable = ['TablePriorsPosteriors',[timestamp, EstimationName],'.txt'];


WriteTeXTable1(NaN, header, style, tableBody)

f = fopen(NameTable, 'w');
WriteTeXTable1(f, header, style, tableBody)
fclose(f)












