function [H,M,R] = getMeasurementEquationLaubach3(vrbs, vrbs_obs, params,params_index, ModelDim,learning,S,F)
                                         
nobs = ModelDim.nobs;
nvar = ModelDim.nvar;

% Inflation and unemployment expectations

ftil_select = [S.vrbsL.pi,S.vrbsL.x,S.vrbsL.x_L,S.vrbsL.mu];
infl_pos = find(ftil_select == S.vrbsL.pi);
F_til = F(ftil_select,ftil_select);
F_til2 = (1/2)*(F_til + F_til^2);
F_til4 = (1/4)*(F_til + F_til^2+F_til^3 + F_til^4);

F_til510 = zeros(size(F_til));
% F_til110 = zeros(size(F_til));
% for js = 1:20
% F_til110 = F_til110 + F_til^js;    
% end    
for jj = 21:40    
F_til510 = F_til510 + F_til^jj;
% F_til110 = F_til110 + F_til^jj;
end
F_til510 = (1/20)*F_til510;

%eyep = eye(size(F_til));
%F_til510 = (1/20)*((eyep-F_til)\(eyep - F_til^(40-20)))*F_til^20; % only for
%stationary
%keyboard

%% Initialize measurement equation matrices
H = zeros(nobs,nvar);
M.Mu = zeros(nobs,1); % this is not an intercept but it multiplies ubart
M.M0 = zeros(nobs,1);

%% Populate measurement equation matrices

% 1. unemployment
H(vrbs_obs.u, S.vrbsL.x) = 1;
H(vrbs_obs.u, S.vrbsL.ustar) = 1;
% H(vrbs_obs.u, S.vrbsL.oe_utr) = 1;
M.Mu(vrbs_obs.u) = 1;

% 2. inflation  core 
H(vrbs_obs.pi,S.vrbsL.pi) = 1;
H(vrbs_obs.pi,S.vrbsL.pistar) = 1;

% 3. wage inflation
H(vrbs_obs.piw,S.vrbsL.pi) = 1;
H(vrbs_obs.piw,S.vrbsL.mu) = -params(params_index.beta)^-1*(1-params(params_index.beta)*params(params_index.rho_ze))/(1-params(params_index.rho_ze));
H(vrbs_obs.piw,S.vrbsL.pistar) = 1;
H(vrbs_obs.piw, S.vrbsL.oe_utr) = 1; %observation error on wage series
M.M0(vrbs_obs.piw) = params(params_index.gamma_w);

% 4. wage inflation2
H(vrbs_obs.piw2,S.vrbsL.pi) = params(params_index.theta2);
H(vrbs_obs.piw2,S.vrbsL.mu) = -params(params_index.theta2)*params(params_index.beta)^-1*(1-params(params_index.beta)*params(params_index.rho_ze))/(1-params(params_index.rho_ze));
H(vrbs_obs.piw2,S.vrbsL.pistar) = params(params_index.theta2);
H(vrbs_obs.piw2, S.vrbsL.oe_utr2) = 1; %observation error on wage series
M.M0(vrbs_obs.piw2) = params(params_index.theta2)*params(params_index.gamma_w);

% 5. wage inflation3
H(vrbs_obs.piw3,S.vrbsL.pi) = params(params_index.theta3);
H(vrbs_obs.piw3,S.vrbsL.mu) = -params(params_index.theta3)*params(params_index.beta)^-1*(1-params(params_index.beta)*params(params_index.rho_ze))/(1-params(params_index.rho_ze));
H(vrbs_obs.piw3,S.vrbsL.pistar) = params(params_index.theta3);
H(vrbs_obs.piw3, S.vrbsL.oe_utr3) = 1; %observation error on wage series
M.M0(vrbs_obs.piw3) = params(params_index.theta3)*params(params_index.gamma_w);

% 6. wage inflation4
H(vrbs_obs.piw4,S.vrbsL.pi) = params(params_index.theta4);
H(vrbs_obs.piw4,S.vrbsL.mu) = -params(params_index.theta4)*params(params_index.beta)^-1*(1-params(params_index.beta)*params(params_index.rho_ze))/(1-params(params_index.rho_ze));
H(vrbs_obs.piw4,S.vrbsL.pistar) = params(params_index.theta4);
H(vrbs_obs.piw4, S.vrbsL.oe_utr4) = 1; %observation error on wage series
M.M0(vrbs_obs.piw4) = params(params_index.theta4)*params(params_index.gamma_w);

% 7. wage inflation5
H(vrbs_obs.piw5,S.vrbsL.pi) = params(params_index.theta5);
H(vrbs_obs.piw5,S.vrbsL.mu) = -params(params_index.theta5)*params(params_index.beta)^-1*(1-params(params_index.beta)*params(params_index.rho_ze))/(1-params(params_index.rho_ze));
H(vrbs_obs.piw5,S.vrbsL.pistar) = params(params_index.theta5);
H(vrbs_obs.piw5, S.vrbsL.oe_utr5) = 1; %observation error on wage series
M.M0(vrbs_obs.piw5) = params(params_index.theta5)*params(params_index.gamma_w);


%% Forecasts
% 8. one-step-ahead inflation expectations 
H(vrbs_obs.exp1q_pi,ftil_select) = F_til(infl_pos,:); %NOT USED
H(vrbs_obs.exp1q_pi,S.vrbsL.pistar) = 1; %NOT USED

% 9. two-quarters-ahead inflation expectations 
H(vrbs_obs.exp12q_pi,ftil_select) = F_til2(infl_pos,:);
H(vrbs_obs.exp12q_pi,S.vrbsL.oe_pi12q_pi) = 1; 
H(vrbs_obs.exp12q_pi,S.vrbsL.pistar) = 1;

% 10. four-  quarters-ahead inflation expectations %NOT USED--incorrect
H(vrbs_obs.exp14q_pi,ftil_select) = F_til4(infl_pos,:);
%H(vrbs_obs.exp14q_pi,S.vrbsL.oe_pi12q_pi) = 1; % comment when using
%professional forecasters
H(vrbs_obs.exp14q_pi,S.vrbsL.pistar) = 1;

% 11. 5-10 years ahead inflation expectations
H(vrbs_obs.exp510y_pi,ftil_select) = F_til510(infl_pos,:);
H(vrbs_obs.exp510y_pi,S.vrbsL.oe_pi510Y_pi) = 1;
H(vrbs_obs.exp510y_pi,S.vrbsL.pistar) = 1;

% 12. 1-10 years ahead inflation expectations  %NOT USED--incorrect
H(vrbs_obs.exp110y_pi,ftil_select) = F_til(infl_pos,:);
% H(vrbs_obs.exp110y_pi,S.vrbsL.oe_pi14q_u) = 1; %borrowing for the following eq...

H = H'; % Hamilton Notation

R = zeros(nobs,nobs);


