function [T_Z,T_epsilon,D,F,G,H,flag_solve] = solveModelv1(Mspec,params,params_index,vrbs,shocks,ModelDim,type,learning,Sml)
   

flag_solve = 0;

   
% define rational expectations model

[A, B, C] = eval(['defineREModel',Mspec,'(vrbs,shocks,ModelDim,params,params_index)']);

% solve rational expectations model
[Br,Cr,Lr,NF,flag_reds] = redsf(A,B,C,ModelDim.nvar,ModelDim.nshock,ModelDim.nstate);

if flag_reds
T_Z = NaN; T_epsilon = NaN; D = NaN;F = NaN;G = NaN;H = NaN; flag_solve = 1; return   
else
[D,F,G,H,flag_solds] = soldsf(Br,Cr,Lr,ModelDim.nvar,ModelDim.nshock,ModelDim.nstate,NF);
end


if flag_solds
   T_Z = NaN; T_epsilon = NaN; D = NaN;F = NaN;G = NaN;H = NaN; flag_solve = 1; return     
else
D = real(D); F = real(F); G = real(G); H = real(H);
end



% Convert to VAR form
[Omega_Z, Omega_epsilon] = getVAR(D,F,G,H,vrbs,type);





if learning
    
    
    %[systemMats_full, lambda] = defineFullModelv1(vrbs,shocks,ModelDim,params,params_index);
    [systemMats_full, lambda,K_mat,flagd] = eval(['defineFullModel',Mspec,'(vrbs,shocks,ModelDim,params,params_index,Omega_Z, Omega_epsilon)']); %#ok<ASGLU>
    
    if flagd
    T_Z = NaN; T_epsilon = NaN; D = NaN;F = NaN;G = NaN;H = NaN; flag_solve = 1; return    
    end
    
   % [T_Z, T_epsilon, T_0,max_eig] = T_map(systemMats_full,Omega_Z,lambda,Sml,K_mat,ModelDim.nestimated);
    
   [T_Z, T_epsilon, T_0,max_eig] = eval(['T_map',Mspec,'(systemMats_full,Omega_Z,lambda,Sml,K_mat,ModelDim.nestimated)']);
    
      
     if max_eig > 0.99 % formerly >= 1, > 995
     % Use if computing hessian
     %    if max_eig > 0.999 % formerly >= 1, > 995
   T_Z = NaN; T_epsilon = NaN; D = NaN;F = NaN;G = NaN;H = NaN; flag_solve = 1; return     
   else
  
    [T_Z, T_epsilon] = extendStateSpace(T_0, T_Z, T_epsilon,Sml,K_mat, ModelDim.nestimated);
                                    
  
     end 

else
    
    T_Z=Omega_Z; T_epsilon=Omega_epsilon;

end





