
% THIS computes the Kalman filter on the extended state space which
% includes the structural innovations

function [Lik,xi_tt_mat,Ptt_mat,xi_tl_mat,Ptl_mat,F_til,Sc_til,Q_til,Hm_til,F,Sc,Hm,M,R] = Ext_KalmanFilter(Mspec,params,params_index,vrbs,vrbs_obs,shocks,shocks_oe,ModelDim,type,learning,Sml,Y_main,trainingSampleLength);


%[T_Z,T_epsilon,~,~,~,~,flag_solve] = solveModelv1(Mspec,params,params_index,vrbs,shocks,ModelDim,type,learning,Sml);

[F,Sc,Q] = eval(['add_to_StateSpace',Mspec,'(vrbs,params,params_index,ModelDim.nvar,ModelDim.nshock,ModelDim.noe,shocks,learning,Sml)']);
                                                               
%[Hm,M,R] = eval(['getMeasurementEquation',Mspec,'(vrbs, vrbs_obs, params,params_index, ModelDim,learning,Sml)']);
[Hm,M,R] = eval(['getMeasurementEquation',Mspec,'(vrbs, vrbs_obs, params,params_index, ModelDim,learning,Sml,F)']); %for Laubach2


% Extend state space to include structural shocks
F_til = [F                                 zeros(size(F,1),ModelDim.nshock)
         zeros(ModelDim.nshock,size(F,2))  zeros(ModelDim.nshock,ModelDim.nshock)];
    
Sc_til = [Sc
          eye(ModelDim.nshock) ]; % laubach2
          %eye(ModelDim.nshock) zeros(ModelDim.nshock,ModelDim.noe)];  
      
Q_til = Sc_til*Sc_til';      

Hm_til = [Hm' zeros(ModelDim.nobs,ModelDim.nshock)]';

% Initialization of Kalman filter

 sel_stat = [vrbs.pi vrbs.x vrbs.x_L vrbs.mu vrbs.ustar ...
     vrbs.oe_pi510Y_pi vrbs.oe_pi12q_pi vrbs.oe_utr,ModelDim.nvar+1:ModelDim.nvar+ModelDim.nshock];
  ns = length(sel_stat);
 sel_nonstat = vrbs.pistar;
  nn = length(sel_nonstat);

xi_0 = zeros(size(F_til,2),1);
xi_0(vrbs.pi) = 2;
xi_0(vrbs.ustar) = 0;
xi_0(vrbs.pistar) = 2;

P_0 = zeros(size(F_til));
P_0(sel_nonstat,sel_nonstat) = 0.1*eye(nn);

Q_sr_stat = Q_til(sel_stat,sel_stat);
 
vecP0_sr_stat = (eye(ns^2)-kron(F_til(sel_stat,sel_stat),...
                  F_til(sel_stat,sel_stat)))\Q_sr_stat(:);

 P0sr_stat = reshape(vecP0_sr_stat,ns,ns);
 P0sr_stat_mew = (P0sr_stat + P0sr_stat')/2;
 P_0(sel_stat,sel_stat) = P0sr_stat_mew;
 % P_0 = (1/10) * eye(size(F_til)); % 

 % Prediction for likelihood
xi_00 = F_til*xi_0;
P_00 = F_til*P_0*F_til'+Q_til;

% Kalman filter

[Lik,xi_tt_mat,Ptt_mat,xi_tl_mat,Ptl_mat] = Likelihood_preds(xi_00,P_00,Hm_til,R,M,F_til,Q_til,Y_main',trainingSampleLength);

