


% Load draws

load([spath,...
    'Mode',pathslash,...
    [timestamp, EstimationName]],'X_draws');


% Definitions

    % parameters
discard = 2000;

X_draws = X_draws(:,discard+1:end);

ndraws = size(X_draws,2);

drawsel = randperm(ndraws);

n_draws_swl = 1000;

x_draws_pred = NaN(size(X_draws,1),n_draws_swl); % stores selected parameter draws


    % variables
    if ~strcmp('usa', country)
piTT_mat = NaN(sampleSizeF,n_draws_swl); 
kTT_mat = NaN(sampleSizeF,n_draws_swl); 
xiTT_mat = NaN(3,sampleSizeF,n_draws_swl); 

ypred_mat = NaN(vrbs_obsF.n_obsvables,sampleSizeF,min(n_draws_swl,ndraws));

ypred_fcsterrors =  NaN(sampleSizeF-1,min(n_draws_swl,ndraws));

   % Shocks and initial conditions (Shocks have ini_drop less observations)

   inidrop = 1;
   
eps_mat = NaN(sampleSizeF-inidrop,min(n_draws_swl,ndraws));
u_mat = NaN(sampleSizeF-inidrop,min(n_draws_swl,ndraws));

else
piTT_mat = NaN(sampleSize,n_draws_swl); 
kTT_mat = NaN(sampleSize,n_draws_swl); 
xiTT_mat = NaN(3,sampleSize,n_draws_swl); 

ypred_mat = NaN(vrbs_obs.n_obsvables,sampleSize,min(n_draws_swl,ndraws));

ypred_fcsterrors =  NaN(sampleSize-1,min(n_draws_swl,ndraws));

   % Shocks and initial conditions (Shocks have ini_drop less observations)

   inidrop = 1;
   
eps_mat = NaN(sampleSize-inidrop,min(n_draws_swl,ndraws));
u_mat = NaN(sampleSize-inidrop,min(n_draws_swl,ndraws));
end
iniconds = NaN(5,min(n_draws_swl,ndraws));


for d = 1:min(n_draws_swl,ndraws)

    disp(['draw n.',num2str(d)]);
    
    draw = drawsel(d);
    
% Parameters  
    
    x_draw = X_draws(:,draw);
    
    x_draws_pred(:,d) = x_draw; % saves the parameters draw 

    params(params_estimated_index) = x_draw;

    
       % Particle filter
    if ~strcmp('usa', country)

    [Lik,flag,xitt_vec,ktt_vec,pitt_vec,mean_pitt,mean_ktt,mean_xitt,xipt_vec,kpt_vec,pipt_vec,qqr_vec,Ptt,Hpi,H,mu,R,Qmp] = FPred_Marg_ParticleFilter_Ess(N,gam_eff,Shock,Resample_random,Random_ini,...
                            gain_rand_ini,VCVini,params,params_index,vrbs_obsF,Y_dataF,traning_sampleF,sampleSizeF);
       % Partricle smoother
   
   [piTT_vec,kTT_vec,xiTT_vec] = FParticleSmoother(N,Y_dataF,1,qqr_vec,pitt_vec,ktt_vec,xitt_vec,Ptt,params, kpt_vec,params_index,Qmp,sampleSizeF);

    else
   [Lik,flag,xitt_vec,ktt_vec,pitt_vec,mean_pitt,mean_ktt,mean_xitt,xipt_vec,kpt_vec,pipt_vec,qqr_vec,Ptt,Hpi,H,mu,R,Qmp] = Pred_Marg_ParticleFilter_Ess(N,gam_eff,Shock,Resample_random,Random_ini,...
                            gain_rand_ini,VCVini,params,params_index,vrbs_obs,Y_data,traning_sample,sampleSize);
   
    [piTT_vec,kTT_vec,xiTT_vec] = ParticleSmoother(N,Y_data,1,qqr_vec,pitt_vec,ktt_vec,xitt_vec,Ptt,params, kpt_vec,params_index,Qmp,sampleSize);
                    
    end                  
   
   
   
   % States
   piTT_mat(:,d) = piTT_vec';
   kTT_mat(:,d) = kTT_vec';
   xiTT_mat(:,:,d) = xiTT_vec;
   
   
   % Predicted observables
   
   mu_mat =  repmat(mu,1,size(piTT_vec,1));
   
   ypred_mat(:,:,d) = mu_mat + Hpi*piTT_vec' + H'*xiTT_vec;
   
     % forecast errors
     if strcmp('usa', country)
     ypred_fcsterrors(:,d) = ypred_mat(vrbs_obs.infl,2:end,d) -...
                             ypred_mat(vrbs_obs.infl1Q_spf,1:end-1,d);
     end
                         
   % Shocks and initial conditions for counterfactual simulations.
   % NOTE: they are inidrop observations shorter!
   % Note we compute the filtered shocks as follows:
   % 1. eps(t) = s(t) - rho_phi*s(t-1);
   % 2. u(t) = z(t) - eps(t);
   
   eps_mat(:,d) = xiTT_vec(2,inidrop+1:end) - params(params_index.rho_phi)*xiTT_vec(2,1:end-inidrop);
   u_mat(:,d) = xiTT_vec(1,inidrop+1:end) - eps_mat(:,d)';
   
   % initial conditions: kt,pibart,zt,st,pit
   iniconds(:,d) = [kTT_vec(inidrop);piTT_vec(inidrop);xiTT_vec(:,inidrop)];
   
   
end

save([spath,...
    'Mode',pathslash,...
    [timestamp, EstimationName]],'x_draws_pred','xiTT_mat','piTT_mat','kTT_mat',...
    'eps_mat','u_mat','ypred_fcsterrors','ypred_mat','iniconds','inidrop','-append');
