
%clear


% Import data



% Prices
   
  % sample starts in 1954.75, ends 2017.75
    
[Data_untr Data_str Data_cell] = xlsread('ustarJune2017.xlsx','Prices');

CPIinflation = Data_untr(:,5)'; 


% Unemployment and flows

[Data_untr Data_str Data_cell] = xlsread('ustarJune2017.xlsx','Unemployment');

Unemployment = Data_untr(:,1)';
s_rate = Data_untr(:,3)';
f_rate = Data_untr(:,2)';

utrend = NaN(1,length(f_rate)); % to be filled below

% Slack

[Data_untr Data_str Data_cell] = xlsread('ustarJune2017.xlsx','Slack');

caput  = Data_untr(:,1)'; 
ISMmfg = Data_untr(:,3)' - mean(Data_untr(:,3)');

% Detrend caput with 'linear' trend

[caput_trend,~] = hpfilter(caput,500000000);

caput_detrend = caput- caput_trend';

% Surveys

[Data_untr Data_str Data_cell] = xlsread('ustarJune2017.xlsx','Surveys');

CPI1Q  =  [NaN NaN Data_untr(1:end-1,1)'];
CPI12Q =  [NaN NaN Data_untr(1:end-1,6)'];
CPI14Q =  [NaN NaN Data_untr(1:end-1,5)'];
CPI510Y = [NaN NaN Data_untr(1:end-1,7)'];
u14Q    = NaN(1,length(CPI1Q)); % not filled yet


% Now prepare estimates of utrend based on the flows
%
% These have to be restricted to a sample starting in 1967

utrend_sample_ind = find(1954.75:1/4:2017.75 >= 1967);

[sh,~] = hpfilter(s_rate(utrend_sample_ind),50000);
 fm = nanmean(f_rate);
%[fm,~] = hpfilter(f_rate(utrend_sample_ind),200000);
utrend(utrend_sample_ind) = 100*(sh'./(sh'+fm'));
disp('done')
% Save Dataset for observation equation

save DataMat_LaubachFeb2018 Unemployment CPIinflation caput_detrend...
     ISMmfg CPI1Q CPI12Q CPI14Q CPI510Y u14Q utrend

return 
 % Plots

 % separation rate

 figure('Units','centimeters','Position',[26.5642 14.2081 11.8167 10.1125])
 plot(1967:1/4:2017,s_rate(utrend_sample_ind))
 hold on;plot(1967:1/4:2017,sh,'r')
 xlim([1967,2017])
 
 ng = 'US_s_h'; 

 namesinglefig_eps = [char(strcat(ng,'.eps'))];

 namesinglefig_pdf = [char(strcat(ng,'.pdf'))];


    print(gcf, '-dpsc', '-r300', [pwd,'\',namesinglefig_eps]);
    
    print(gcf, '-dpdf', '-r300', [pwd,'\',namesinglefig_pdf]);
    
    
figure('Units','centimeters','Position',[26.5642 14.2081 11.8167 10.1125])
 plot(1967:1/4:2017,f_rate(utrend_sample_ind))
 hold on;plot(1967:1/4:2017,fm*ones(length(f_rate(utrend_sample_ind)),1),'r')
%  hold on;plot(1967:1/4:2017,fm,'r')

 xlim([1967,2017])
 
 ng = 'US_f_h'; 

 namesinglefig_eps = [char(strcat(ng,'.eps'))];

 namesinglefig_pdf = [char(strcat(ng,'.pdf'))];


    print(gcf, '-dpsc', '-r300', [pwd,'\',namesinglefig_eps]);
    
    print(gcf, '-dpdf', '-r300', [pwd,'\',namesinglefig_pdf]);    

    
figure('Units','centimeters','Position',[26.5642 14.2081 11.8167 10.1125])
 plot(1967:1/4:2017,utrend(utrend_sample_ind))
 hold on;plot(1967:1/4:2017,fm*ones(length(f_rate(utrend_sample_ind)),1),'r')
 xlim([1967,2017])
 
 ng = 'US_f_h'; 

 namesinglefig_eps = [char(strcat(ng,'.eps'))];

 namesinglefig_pdf = [char(strcat(ng,'.pdf'))];


    print(gcf, '-dpsc', '-r300', [pwd,'\',namesinglefig_eps]);
    
    print(gcf, '-dpdf', '-r300', [pwd,'\',namesinglefig_pdf]);      
    
return 


% For Aysegul







[sh,~] = hpfilter(Data_untr(:,5),50000);
hold on;plot(sh,'r')

% Fancy
dates_num = datenum(Data_str(3:end,1),'yyyy-QQ');
dates = cellstr(datestr(dates_num,'yyyy:QQ'));

% plot(dates_num,rand(201,1))
% datetick
% datetick('x','yyyy-QQ')
%find(dates_num==datenum('1980:Q1','yyyy:QQ'))

% Not Fancy

% sample: 1967.25:1/4:2017;


% Preparing estimate of utrnd based on flows

% 1. detrended s, mean f

figure;plot(Data_untr(:,5))
[sh,~] = hpfilter(Data_untr(:,5),50000);
hold on;plot(sh,'r')

figure;plot(Data_untr(:,4))
[sfll,~] = hpfilter(Data_untr(:,4),500000000);
hold on;plot(sfll,'r')

%figure;plot(Data_untall(:,4))
sfm = mean(Data_untr(:,4));
plot(sfm*ones(length(Data_untr(:,4)),1),'b--')
hold off;

utrendl = 100*(sh./(sh+sfll));
figure;plot(Data_untr(:,1))
hold on;plot(utrendl,'r')

utrendm = 100*(sh./(sh+sfm));
%plot(Data_untr(:,1))
hold on;plot(utrendm,'b--')
hold off

% Adding the guys

figure;plot(Data_untr(:,5) + Data_untr(:,4))
% Save


%save DataMat_LaubachMay2017 Data_untr sh sfll sfm utrendl utrendm





