function [var_unc_shares_obs, var_unc_shares_s,var_shares_obs,var_shares_s] = varShare(Vt_tot_uncond_obs,Vt_tot_uncond,Vt_ind_uncond_obs,Vt_ind_uncond,...
                                                   V_ind_covar_obs,V_covar_obs,V_ind_covar,V_covar)


% MY COMMENTS:
% to compute the shares, use: V_ind_covar(state,state,fct_hor,shock)/V_covar(state,state,fct_hor)
% for states and: V_ind_covar_obs(y,y,fct_hor,shock)/V_covar_obs(y,y,fct_hor)
% for observables.
% Need to have var_shares_states; var_shares_obs



nshocks =  size(V_ind_covar_obs,4) ;
ny = size(V_ind_covar_obs,1) ;
ns = size(V_ind_covar,1) ;
nsim = size(V_ind_covar_obs,3);

var_mat_obs = NaN( ny, ny, nsim, nshocks);
var_shares_obs = NaN( ny , nsim , nshocks );
var_mat_s = NaN( ns, ns, nsim, nshocks);
var_shares_s = NaN( ns , nsim , nshocks );


% Unc. variance

var_unc_mat_obs = NaN( ny, ny, nshocks);
var_unc_shares_obs = NaN( ny ,nshocks );
var_unc_mat_s = NaN( ns, ns, nshocks);
var_unc_shares_s = NaN( ns , nshocks );



for n = 1:nshocks;
   var_mat_obs(:,:,:,n) =  squeeze(V_ind_covar_obs(:,:,:,n))./V_covar_obs;
   var_mat_s(:,:,:,n) =    squeeze(V_ind_covar(:,:,:,n))./V_covar;
   
   % unc variance
   var_unc_mat_obs(:,:,n) =  squeeze(Vt_ind_uncond_obs(:,:,n))./Vt_tot_uncond_obs;
   var_unc_mat_s(:,:,n) =    squeeze(Vt_ind_uncond(:,:,n))./Vt_tot_uncond;
   
end

for y = 1:ny;
    var_shares_obs(y,:,:) = squeeze( var_mat_obs(y , y , : ,:));
    
     % unc variance
    var_unc_shares_obs(y,:) = squeeze( var_unc_mat_obs(y , y , :));
     
     
end

for s = 1:ns;
    var_shares_s(s,:,:) = squeeze( var_mat_s(s , s , : ,:));
    
     % unc variance
    var_unc_shares_s(s,:) = squeeze( var_unc_mat_s(s , s , :));

end

end

%%

% This function computes the shares of total variance for each shock.
% var_shares gives the variance share for observable y (1st dim) at time t
% (2nd dimension) for shock j (3rd dimension).

% First we initialize the empty matrix. We want a share for each observable, for
% each period in time, for each shock. This implies a matrix size n_shock x n_y x
% nxi. Recall the dimensions of the input:
    %  V_covar_ind_obs = NaN( size(H,2) , size(H,2) , h , size(SIG_eps,1) ) ;
