function [statesDec_mat, obsDec_mat] = ShockDec_fun1(Filtered_shocks,Initial_state,nshock,F,Sc,Hm,group_cell)

     
   
% Define matrices for shock decomposition (first "shock" is the initial
 % condition)
 
 sampleT = size(Filtered_shocks,2);  
 
 statesDec_mat = NaN(size(F,1),sampleT,size(group_cell,1)+1);
 
 obsDec_mat = NaN(size(Hm',1),sampleT,size(group_cell,1)+1);
 
 
 % initial state
 
 statesDec_mat(:,1,1) = Initial_state;
 
 statesDec_mat(:,1,2:end) = zeros(length(Initial_state),size(group_cell,1));
 
 for hh = 1:size(group_cell,1)+1
 
 obsDec_mat(:,1,hh) = Hm' * statesDec_mat(:,1,hh);  
 
 Filtered_shocks_hh = zeros(size(Filtered_shocks));
 
 if hh ~= 1
 
 Filtered_shocks_hh(group_cell{hh-1},:) = Filtered_shocks(group_cell{hh-1},:);
     
 end    
 
 for jj = 2:sampleT
    
 statesDec_mat(:,jj,hh) = F * statesDec_mat(:,jj-1,hh) +  Sc(:,1:nshock) * Filtered_shocks_hh(:,jj);
 
 obsDec_mat(:,jj,hh) = Hm' * statesDec_mat(:,jj,hh);
 
 end
 
 end
 
     


