

%% COMPUTES E-STABILITY BOUNDARIES

% At the mode
if (exist('xmode','var'))
    
    params(params_estimated_index) = xmode;
    
    
    % Parameter restrictions
    
    params(params_index.by_ratio) = 4*2.5;
  %params(params_index.sigma) = 3;
 % params(params_index.b) = 0;
  % params(params_index.xi_wT) = 0.75;
  % params(params_index.gamma_1)  = 0.75;
%   params(params_index.iota_w) = 0;
%   params(params_index.iota_p) = 0;
% params(params_index.phi_pi) = 1.73;
% params(params_index.rho_i) = 0;
 params(params_index.phi_x) = 0.00;
 % params(params_index.phi_x) = 0.22;
% params(params_index.rho) = 0.97;
% params(params_index.gammaT) = 0; 
    
    c_gain.cgain = params(params_index.k_g) ;
    
    c_gain.cgainEstab = 0;
    
    % Paramsters to compute Estability boundaries and contraint to optimization
    
    epsl = c_gain.cgainEstab+0.000001; %% tolerance for zero eigenvalue
    
    
    % FIXED PARAMETER
    
    Pfix = 'rho'; % parameter to be fixed in a grid
    
    % Set up the grid for the "fixed" parameter
    
    % setting rho vector
    
    debt_durationQ = 1:3:15*4;
    
    beta = (params(params_index.betaT)/100+1)^-1;
    gamma = (params(params_index.gammaT)/100+1);
    
    rho_vec = (debt_durationQ-1)./(debt_durationQ*beta*gamma^-params(params_index.sigma));
    
    fixed_param_vec = rho_vec;
    
   % epsl = c_gain.cgainEstab+0.000001; %% tolerance for zero eigenvalue
    
    % OPTIMIZATION PARAMETER
    
    
    Popt = 'phi_pi'; % parameter over which to minimize the objective function
    
    
    % Bounds on the parameter
    
    bound1 = 1.00001;
    
    bound2 = 1000.98;
    
    
    
    opt_x = 1.001; %% initial value for the optimization
    
    
    
    % Sets number of boundaries
    
    by_vec = 4*[.8,1.2,2,2.2,2.5];
    by_vec = 4*[1.5,2,2.2,2.5];
    
    for nb = 1:length(by_vec)
    
 
     params(params_index.by_ratio) = by_vec(nb);
     
%% [3] Computing E-stability boundaries
 

% Setup for minimization (fminsearch)
 
 stop_crit_x = 1e-10; stop_crit_f = 1e-10; maxits = 3000; 

 max_funevals = 10*maxits;

 options = optimset('Display','iter','TolX',stop_crit_x,'TolFun',stop_crit_f,'MaxFunEvals',max_funevals,'MaxIter',maxits);
 
 OBJ_check = ones(length(fixed_param_vec),1); %% this to check that the optimized value is zero

 optimized_param_vec = zeros(length(fixed_param_vec),1);


 for jj = 1:length(fixed_param_vec)
     
     if jj >= length(fixed_param_vec)-2
         
         x0=1.0001;
     else
   x0 = opt_x;     
     end
 fixed_param_value = fixed_param_vec(jj) %% choice of other paramter to compute the boundary function

    
 [opt_x,fval,exitflag,output] = fminsearch('Obj_Stabfun',x0,options,fixed_param_value,...
                                           epsl,bound1,bound2,Pfix,Popt,c_gain,...
                                           Mspec,params,params_index,vrbs,shocks,ModelDim,type,learning,Sml);
 
 optimized_param_vec(jj) = opt_x;
 
 if fval > 1e-8
     
 OBJ_check(jj) = NaN;
 
 
 else OBJ_check(jj) = fval;
 
 end
 
% coeff0bj_vec(jj) =  coeffeig_obj;
 
 end
 
 Counter_vec=isnan(OBJ_check);
 
 Counter = sum(Counter_vec);
 
 [v1 v2] = find(~isnan(OBJ_check));

 optimized_param_mat(:,nb) = optimized_param_vec;
 
% coeffObj_mat(:,nb) = coeff0bj_vec;
 
 
 
    end % ends nb loop

fixed_param_vecFig1 = fixed_param_vec;

optimized_param_matFig1 = optimized_param_mat;

Plot_fig1

    
end % exist 'xmode' loop
    

%clear all

%global fixed_param_value  epsl bound1 bound2 param vrbs Mopt modelname MShok first_time OMEGA_c_RE Pfix Popt c_gain coeffeig_obj


%% [1] Model setup and options

% first_time = 1;


 
 % Saving the results

% name = 'Figure1';
% 
% CalibrationName = ['CalibrationResults',name];


  

%  DefineModel_Interactions_Estability
%  
%  calibrated_parameters
%  
%  
%   % Define here the vector of parameter estimates...
%  
%  Load_estimates
%  
%  estimated_paramters
 
%  c_gain.cgain = SIM_reg.g_gain;
 
 
 
%% [2] Paramsters to compute Estability boundaries and contraint to optimization



  % FIXED PARAMETER

% Pfix = 'rho'; % parameter to be fixed in a grid
% 
%  % Set up the grid for the "fixed" parameter
%  
%   % setting rho vector
%   
%    debt_durationQ = 1:3:35*4;
%     
%    rho_vec = (debt_durationQ-1)./(debt_durationQ*param.beta);
%      fixed_param_vec = rho_vec;

   
%   fixed_param_vec1 = 0.09:0.01:0.995;
%   
%   fixed_param_vec2 = 0.996:0.001:1.005;
%   fixed_param_vec = [fixed_param_vec1,fixed_param_vec2];
%    
  
   
   
   % OPTIMIZATION PARAMETER 
   

% Popt = 'phipi'; % parameter over which to minimize the objective function
% 
% 
%    % Bounds on the parameter
% 
% bound1 = 1.00001;
% 
% bound2 = 1000.98;
% 
% 
% 
% opt_x = 1.0001; %% initial value for the optimization 
%  
%  
%  
%  % Sets number of boundaries 
%  
%   by_vec = 4*[.8,1.2,2,2.2,2.5];
 % by_vec = 4*[2.8];

% for nb = 1:length(by_vec)
%     
%  
%      param.by = by_vec(nb);
% 
% %% [3] Computing E-stability boundaries
%  
% 
% % Setup for minimization (fminsearch)
%  
%  stop_crit_x = 1e-10; stop_crit_f = 1e-10; maxits = 3000; 
% 
%  max_funevals = 10*maxits;
% 
%  options = optimset('Display','iter','TolX',stop_crit_x,'TolFun',stop_crit_f,'MaxFunEvals',max_funevals,'MaxIter',maxits);
%  
%  OBJ_check = ones(length(fixed_param_vec),1); %% this to check that the optimized value is zero
% 
%  optimized_param_vec = zeros(length(fixed_param_vec),1);
% 
% 
%  for jj = 1:length(fixed_param_vec)
%      
%      if jj >= length(fixed_param_vec)-2
%          
%          x0=1.0001;
%      else
%    x0 = opt_x;     
%      end
%  fixed_param_value = fixed_param_vec(jj); %% choice of other paramter to compute the boundary function
% 
%     
%  [opt_x,fval,exitflag,output] = fminsearch('Obj_fun',x0,options);
%  
%  optimized_param_vec(jj) = opt_x;
%  
%  if fval > 1e-8
%      
%  OBJ_check(jj) = NaN;
%  
%  
%  else OBJ_check(jj) = fval;
%  
%  end
%  
%  coeff0bj_vec(jj) =  coeffeig_obj;
%  
%  end
%  
%  Counter_vec=isnan(OBJ_check);
%  
%  Counter = sum(Counter_vec);
%  
%  [v1 v2] = find(~isnan(OBJ_check));
% 
%  optimized_param_mat(:,nb) = optimized_param_vec;
%  
%  coeffObj_mat(:,nb) = coeff0bj_vec;
%  
%  
%  
% end
% 
% fixed_param_vecFig1 = fixed_param_vec;
% 
% optimized_param_matFig1 = optimized_param_mat;
% 
% Plot_fig1

 
 %save(CalibrationName,'fixed_param_vecFig1','optimized_param_matFig1','by_vec');