
%% Fihgures for the Latest draft of the Brookings paper (April 7, 2019)

select_draws = 0;

if select_draws
 
   % loads full result from estimation 
load US_noubar2 

    %% Save for slides figures

    
n_draws_swl = 5000;
samplot = 1960.0:1/4:2018.5;
drawsel = randperm(size(Results.X_draws_all,2)); 
drawsels = drawsel(1:n_draws_swl);
X_draws_fulls = Results.X_draws_all(:,drawsels);
ubar_fulls = squeeze(Results.xi_TT_all(vrbs.utrend,drawsels,:));
ustar_fulls = squeeze(Results.xi_TT_all(vrbs.ustar,drawsels,:));
unempl = Y_main(:,1);
save UstarNoUbar ubar_fulls ustar_fulls unempl samplot

end

%save UstarPriceOnly ubar_fulls ustar_fulls gap unempl samplot

% Loads 5000 draws (out of 100000) saved for the plots

load UstarNoUbar ubar_fulls ustar_fulls unempl samplot

% 1. ustar figure
figure('Units','centimeters','Position',[26.5642 14.2081 22.8167 12.1125])
%vcPlotDistBands3(ustar_fulls,samplot); 
vcPlotDistBands3(ustar_fulls+ubar_fulls,samplot);
hold on
h2 = plot(samplot,Y_main(:,1),'k-');
xlim([1960 2018.5])
ylim([3 11])

% uncomment to save
% ng = 'u_bar';
% namesinglefig_eps = [char(strcat(ng,'.eps'))];
% namesinglefig_pdf = [char(strcat(ng,'.pdf'))];
% print(gcf, '-dpsc', '-r300', [namesinglefig_eps]);
% print(gcf, '-dpdf', '-r300', [namesinglefig_pdf]);


