
%% THIS FUNCTION COMPUTES THE ALM OF A MODEL DEFINED BY:
%% matrices A, B
%% PLM OMEGA_0, OMEGA_c
%% k_y (finite) number of forecast ahead
%% disc: vector of discount rates (to be used in the infinite horizon
%% forecasts

%% The first three matrices describe the ALM, the last two can be used in
%% the Estab function to compute Estability of the REE

 function [T_0 T_L T_s T_c T_Ls] = ALM_funv2(A,C,invA0,OMEGA_c,k_y,disc)

 % NOTE: this v2 function does not require OMEGA_0 as input because it
 % defines only T0 of T0*OMEGA_0 (unlike the previous version).
 % However this version make sens if A{1} is set to zeros vector (true intercept is zero as every model studied so far).
 
 
  %% First verify that marix dimensions match 
 
%  if size(A{1},1) ~= size(OMEGA_c,1)
%      
%      disp('model not correctly specified')
%      return
%      
%  end
 
 if size(A{1},1) ~= size(OMEGA_c,1)
     
     disp('model not correctly specified')
     return
     
 end
 
 
 %% Define parameters
 
 n_var = size(A{1},1);
 
 j_y = length(disc);
 
 F0 = cell(j_y,1);
 
 F1 = cell(j_y,1);
 
 
 %% Infinite horizon expectations
 
  invOM = (eye(n_var)-OMEGA_c)\eye(size((eye(n_var)-OMEGA_c)));
 
 for cnt = 1:j_y
     
    invOMcnt = (eye(n_var)-disc(cnt)*OMEGA_c)\eye(size((eye(n_var)-disc(cnt)*OMEGA_c)));
    
   
     
     %F0{cnt} = invOM*(eye(n_var)*(1-disc(cnt))^(-1)-OMEGA_c*invOMcnt)*OMEGA_0;
     F0{cnt} = invOM*(eye(n_var)*(1-disc(cnt))^(-1)-OMEGA_c*invOMcnt);
     
     F1{cnt} = OMEGA_c*invOMcnt;
 
 end
 
 %disp('forecast has been created')
 
 
%% ALM


%T_0 = invA0*A{1}+invA0*A{2}*OMEGA_0;
T_0 = invA0*A{1}+invA0*A{2};

T_c = zeros(n_var,n_var);


for ctn = 1:k_y
   
    
%T_0 = T_0+invA0*A{2+ctn}*invOM*(eye(n_var)-OMEGA_c^(ctn))*OMEGA_0;
T_0 = T_0+invA0*A{2+ctn}*invOM*(eye(n_var)-OMEGA_c^(ctn));


T_c = T_c+invA0*A{2+ctn}*OMEGA_c^(ctn);

 end

for ctn = 1:j_y
    
    T_0 = T_0+invA0*A{2+k_y+ctn}*F0{ctn};
    
    T_c = T_c+invA0*A{2+k_y+ctn}*F1{ctn};
end

T_Ls = invA0*A{2}*OMEGA_c+invA0*A{2+k_y+j_y+1};

%clear A invA0 F0 F1 

%disp('calculating last inverse')


T_inv = (eye(n_var,n_var)-T_c)\eye(size(eye(n_var,n_var)-T_c));


%disp('done calculating last inverse')

T_0 = T_inv*T_0;

%disp('done calculating constant')
T_L = T_inv*T_Ls;

%disp('done calculating coefficients')

T_s = T_inv*C;

%disp('ALM created')
    