function [H,M,R] = getMeasurementEquationNocapital(~, vrbs_obs, params,params_index, ModelDim,learning,S,T_Z)
                                         
nobs = ModelDim.nobs;
nvar = ModelDim.nvar;
nlag = ModelDim.nlag;


%% Initialize measurement equation matrices
H = zeros(nobs,nvar);
M = zeros(nobs,1);


% OMz = T_Z(1:ModelDim.nvar-ModelDim.nlag,1:ModelDim.nvar-ModelDim.nlag); %#ok<NASGU>
 Omz = T_Z(1:nvar-nlag,1:nvar-nlag); 
% Note: This is needed to build agents' forecasts in the observation
%       equation. Under learning, the upper corner of the matrix defines
%       Omega_Z.

% Position of variables driving expectations


omegaZpos = 1:nvar-nlag;


% Produce matrices to obtain 5-10 and Q4 forecasts
invOmz = (eye(nvar-nlag) - Omz)\(eye((nvar-nlag)));
Omz20 = Omz^20;
Omz4 = Omz^4;
pipe = invOmz*(eye(nvar-nlag) - Omz20)*Omz20;
%pipeTest = zeros(size(pipe)); % forcing observables to be the drifting coefficients 




if learning

ndrift = size(S.Som,2);
omega0pos = nvar-nlag + 1:(nvar-nlag)+ndrift;    
    
Eom0510 = (1/20)*invOmz*(20*eye(nvar-nlag) - pipe)*S.Som;
%Eom0510 = invOmz*S.Som;

Eom0510_infl = Eom0510(S.vrbsL.pi,:);
Eom0510_R = Eom0510(S.vrbsL.R,:);

Eom0Q1 = invOmz*(eye(nvar-nlag)-Omz)*S.Som;
Eom0Q4 = invOmz*(eye(nvar-nlag)-Omz4)*S.Som;

Eom0Q1_infl = Eom0Q1(S.vrbsL.pi,:);
Eom0Q1_R = Eom0Q1(S.vrbsL.R,:);

Eom0Q4_infl = Eom0Q4(S.vrbsL.pi,:);
Eom0Q4_R = Eom0Q4(S.vrbsL.R,:);

 %% Populating observation matrix

% 5-10 yrs inflation expectations (Blues chip)

H(vrbs_obs.exp_infl510,omega0pos) = Eom0510_infl;

% 5-10 yrs Tbill expectations (Blues chip)

H(vrbs_obs.exp_Tbill510,omega0pos) = Eom0510_R;

% 1Q ahead inflation expectations

H(vrbs_obs.exp_infl1Q,omega0pos) = Eom0Q1_infl;

% 1Q ahead Tbill expectations

H(vrbs_obs.exp_Tbill1Q,omega0pos) = Eom0Q1_R;

% 4Q ahead inflation expectations

H(vrbs_obs.exp_infl4Q,omega0pos) = Eom0Q4_infl;

% 4Q ahead Tbill expectations

H(vrbs_obs.exp_Tbill4Q,omega0pos) = Eom0Q4_R;


end

% Coefficients on other states (also used under RE)
EomZ510 = (1/20)*pipe;

%EomZ510 = pipeTest;

EomZ510_infl = EomZ510(S.vrbsL.pi,:);

EomZ510_R = EomZ510(S.vrbsL.R,:);

EomZQ1 = Omz;

EomZQ1_infl = EomZQ1(S.vrbsL.pi,:);

EomZQ1_R = EomZQ1(S.vrbsL.R,:);

EomZQ4 = Omz4;

EomZQ4_infl = EomZQ4(S.vrbsL.pi,:);

EomZQ4_R = EomZQ4(S.vrbsL.R,:);






%% Populate measurement equation matrices

% 1. Output growth
H(vrbs_obs.GDP, S.vrbsL.y) = 1;
H(vrbs_obs.GDP, S.vrbsL.y_lag) = -1;
H(vrbs_obs.GDP,S.vrbsL.gamma) = 1;

M(vrbs_obs.GDP) = params(params_index.gammaT);

% 3. Real Wage Growth (defined as labor share)   
H(vrbs_obs.Wage,S.vrbsL.w_r) = 1;
H(vrbs_obs.Wage,S.vrbsL.w_r_lag) = -1;
H(vrbs_obs.Wage,S.vrbsL.gamma) = 1;
M(vrbs_obs.Wage) = params(params_index.gammaT);

H(vrbs_obs.Wage,S.vrbsL.oe_wage) = 1; % observation error on wage growth 

% 4. Inflation
H(vrbs_obs.Inflation, S.vrbsL.pi) = 1;
M(vrbs_obs.Inflation) = params(params_index.pi);

% 5. Nominal interest rate 
H(vrbs_obs.FedFunds,S.vrbsL.R) = 1;

PIstar = params(params_index.pi)/100 +1;
beta = (params(params_index.betaT)/100+1)^-1;
gamma = (params(params_index.gammaT)/100+1);

%M(vrbs_obs.FedFunds) = 100*(beta^(-1)*gamma^(params(params_index.sigma))*PIstar - 1);
 %M(vrbs_obs.FedFunds) = 100*log(beta^(-1)*gamma^(params(params_index.sigma))) + params(params_index.pi);

 M(vrbs_obs.FedFunds) = params(params_index.pi) + params(params_index.ffrr); % no restrictions on beta %% ffr has a different mean relative to agents short-term rate

% 5. Tax revenues (devide by 4??)
H(vrbs_obs.Tax,S.vrbsL.tau) = 1;

sy_ratio = (beta^-1*gamma^(params(params_index.sigma)-1)-1)*params(params_index.by_ratio);

tau_y_ratio = sy_ratio + params(params_index.gy_ratio);

M(vrbs_obs.Tax) = tau_y_ratio;

% 6. Gov Debt
Pm = 1/(beta^(-1)*gamma^(params(params_index.sigma))-params(params_index.rho)); 

H(vrbs_obs.GDebt,S.vrbsL.b_m) = (1/4)*Pm;

H(vrbs_obs.GDebt,S.vrbsL.P_m) = params(params_index.by_ratio)/4;

H(vrbs_obs.GDebt,S.vrbsL.y) = -params(params_index.by_ratio)/4;

H(vrbs_obs.GDebt,S.vrbsL.oe_bm) = 1; 

M(vrbs_obs.GDebt) = params(params_index.by_ratio)/4;

% 7. 5-10 yrs inflation expectations (Blues chip)
%H(vrbs_obs.exp_infl510,omega0pos) = Eom0510_infl;

H(vrbs_obs.exp_infl510,omegaZpos) = EomZ510_infl;

H(vrbs_obs.exp_infl510,S.vrbsL.oe_pLe) = 1; % observation error

M(vrbs_obs.exp_infl510) = params(params_index.pi);

% 8. 5-10 yrs Tbill expectations (Blues chip)
%H(vrbs_obs.exp_Tbill510,omega0pos) = Eom0510_R;

H(vrbs_obs.exp_Tbill510,omegaZpos) = EomZ510_R;

H(vrbs_obs.exp_Tbill510,S.vrbsL.oe_RLe) = 1; % observation error

M(vrbs_obs.exp_Tbill510) = M(vrbs_obs.FedFunds); %params(params_index.pi) + params(params_index.ffrr);


% 9. 1Q ahead inflation expectations
%H(vrbs_obs.exp_infl1Q,omega0pos) = Eom0Q1_infl;

H(vrbs_obs.exp_infl1Q,omegaZpos) = EomZQ1_infl;

H(vrbs_obs.exp_infl1Q,S.vrbsL.oe_wage) = 1; % observation error

M(vrbs_obs.exp_infl1Q) = params(params_index.pi);


% 10. 1Q ahead Tbill expectations
%H(vrbs_obs.exp_Tbill1Q,omega0pos) = Eom0Q1_R;

H(vrbs_obs.exp_Tbill1Q,omegaZpos) = EomZQ1_R;

H(vrbs_obs.exp_Tbill1Q,S.vrbsL.oe_Re) = 1; % observation error

M(vrbs_obs.exp_Tbill1Q) = M(vrbs_obs.FedFunds);%params(params_index.pi)+ params(params_index.ffrr);

% 11. 4Q ahead inflation expectations
%H(vrbs_obs.exp_infl4Q,omega0pos) = Eom0Q4_infl;

H(vrbs_obs.exp_infl4Q,omegaZpos) = EomZQ4_infl;

%H(vrbs_obs.exp_infl4Q,S.vrbsL.oe_bm) = 1; % observation error

M(vrbs_obs.exp_infl4Q) = params(params_index.pi);


% 12. 4Q ahead Tbill expectations
%H(vrbs_obs.exp_Tbill4Q,omega0pos) = Eom0Q4_R;

H(vrbs_obs.exp_Tbill4Q,omegaZpos) = EomZQ4_R;

%H(vrbs_obs.exp_Tbill4Q,S.vrbsL.oe_bm) = 1; % observation error

M(vrbs_obs.exp_Tbill4Q) = M(vrbs_obs.FedFunds);%params(params_index.pi)+ params(params_index.ffrr);


% 13. output gap
H(vrbs_obs.outputgap,S.vrbsL.y) = 1;


H = H'; % Hamilton Notation

R = zeros(nobs,nobs);



