function [vrbs, type, shocks,shocks_oe,ModelDim,estimate] = defineVariablesNocapital()
% This function outputs the following:
% vrbs: a structure containing the position of all variables (with jump
% variables ordered before state variables)
% nvar: the total number of variables (size of vrbs)
% nstate: the number of state variables

% jump variables
vrbs.N     = 1            ;  type.N     = 'jump';               estimate.N     = 1;  
vrbs.P_m   = 2            ;  type.P_m   = 'jump';               estimate.P_m   = 0; 
vrbs.Gamma = 3            ;  type.Gamma = 'jump';               estimate.Gamma = 1; 


% Natural rates
%vrbs.r_star     = 8      ;  type.r_star     = 'jump';               estimate.r_star     = 0; 

% jump and state variables
vrbs.y     = 4           ;   type.y     = 'jump and state';     estimate.y     = 0; 
vrbs.c     = 5            ;  type.c     = 'jump and state';     estimate.c     = 1; 
vrbs.w_r   = 6            ;  type.w_r   = 'jump and state';     estimate.w_r   = 1; 
vrbs.pi    = 7            ;  type.pi    = 'jump and state';     estimate.pi    = 1; 




njump = 7;

% state variables
vrbs.R             = njump + 1 ;  type.R         = 'state';         estimate.R        = 1; 
vrbs.tau           = njump + 2 ;  type.tau       = 'state';         estimate.tau      = 1; 
vrbs.b_m           = njump + 3 ;  type.b_m       = 'state';         estimate.b_m      = 1; 
vrbs.c_star        = njump + 4 ;  type.c_star     = 'state';       estimate.c_star     = 0; 
vrbs.gamma         = njump + 5 ;  type.gamma     = 'state';         estimate.gamma    = 0; 
vrbs.theta_w       = njump + 6;  type.theta_w    = 'state';         estimate.theta_w  = 0; 
vrbs.g             = njump + 7;  type.g          = 'state';         estimate.g        = 0; 
vrbs.xi            = njump + 8;  type.xi         = 'state';         estimate.xi       = 0; 
vrbs.pistar        = njump + 9;  type.pistar    = 'state';         estimate.pistar   = 0; 
vrbs.theta_p       = njump + 10;  type.theta_p   = 'state';         estimate.theta_p  = 0; 
vrbs.m             = njump + 11;  type.m         = 'state';         estimate.m        = 0; 
vrbs.tau_shock     = njump + 12;  type.tau_shock = 'state';         estimate.tau_shock= 0; 
vrbs.b_shock       = njump + 13;  type.b_shock   = 'state';         estimate.b_shock  = 0; 
vrbs.a_shock       = njump + 14;  type.a_shock   = 'state';         estimate.a_shock  = 0; 

% For MA components
% vrbs.theta_w_eps   = njump + 17;  type.theta_w_eps = 'state';           estimate.theta_w_eps  = 0; 
% vrbs.theta_p_eps   = njump + 18;  type.theta_p_eps = 'state';           estimate.theta_p_eps  = 0; 


% Note: x_lag variables corresponding to 'jump and state' type should be in
% the same order as the x variables
% Note2: alla lags variables should correspond to 'jump and state' variables in the RE model (need to think more about this) 
nstates = njump + 14;

vrbs.y_lag     = nstates + 1;  type.y_lag        = 'lag state';     %estimate.y_lag   = 0;
vrbs.c_lag     = nstates + 2;  type.c_lag     = 'lag state';     %estimate.c_lag   = 0;
vrbs.w_r_lag   = nstates + 3;  type.w_r_lag   = 'lag state';     %estimate.w_r_lag   = 0;
vrbs.pi_lag    = nstates + 4;  type.pi_lag    = 'lag state';     %estimate.pi_lag   = 0;


ModelDim.nstate = 14 + 4;

nlags = nstates + 4;
ModelDim.nlag   = 4;

% Observation shocks
vrbs.oe_wage   = nlags + 1;  type.oe_wage   = 'oe state';         
vrbs.oe_bm   = nlags + 2;  type.oe_bm   = 'oe state';         
vrbs.oe_Re   = nlags + 3;  type.oe_Re   = 'oe state';         
vrbs.oe_RLe   = nlags + 4;  type.oe_RLe   = 'oe state';         
vrbs.oe_pLe   = nlags + 5;  type.oe_pLe   = 'oe state';         


nestimated = 0;
estnames = fieldnames(estimate);
for j = 1:size(estnames,1)
nestimated = nestimated + estimate.(estnames{j});
end    
    ModelDim.nestimated = nestimated; 
    
% shocks
shocks.gamma = 1;
shocks.theta_w = 2;
shocks.g = 3;
shocks.xi = 4;
shocks.pistar = 5;
shocks.theta_p = 6;
shocks.m = 7;
shocks.tau = 8;
shocks.b = 9;
shocks.a = 10;

ModelDim.nshock = 10;


% observation shocks
shocks_oe.wage = ModelDim.nshock + 1;
shocks_oe.bm = ModelDim.nshock + 2;
shocks_oe.Re = ModelDim.nshock + 3;
shocks_oe.RLe = ModelDim.nshock + 4;
shocks_oe.pLe = ModelDim.nshock + 5;

ModelDim.noe = 5;

ModelDim.nvar = ModelDim.nstate + njump;

end

