function [A, B, C] = defineREModelNocapital(vrbs,shocks,ModelDim,params,params_index)

% This function outputs model coefficient matrices A, B and C that will be 
% used in the Reds-Solds algorithm. This defines a set of equilibrium
% conditions in standard canonical form.

% NOTE: mak uo shocks are normalized
nvar = ModelDim.nvar;
nshock = ModelDim.nshock;

[beta, theta_w, sigma, ~, b, xi_w, iota_w, ~, iota_p,  ~, phi_pi,...
    rho_i, phi_x, phi_dx,~, by_ratio, rho, rho_tau, phi_taul, phi_taux, gamma, ~, rho_gamma, rho_theta_w, ...
    rho_theta_p, rho_g, rho_xi, rho_pistar, rho_m,  rho_tau_hat, rho_b, rho_a,sigma_gamma, sigma_theta_w, ...
    sigma_theta_p, sigma_g, sigma_xi, sigma_pistar, sigma_m, sigma_tau_hat, sigma_b, sigma_a, sigma_ggam,~, ...
    ~, P_m, ~, ~, ~, ~,  cy_ratio, ...
    wc_ratio, xi_v, ~, ~, ~, xi_p, c_1w, c_2w, c_3w] = getparamsNocapital(params, params_index);




A = zeros(nvar);
B = zeros(nvar);
C = zeros(nvar, nshock);

%% 1. N - Jump 
A(vrbs.N, vrbs.a_shock) = -1;
B(vrbs.N, vrbs.N) = 1;
B(vrbs.N, vrbs.y) = -1;

%% 2. R - State
A(vrbs.R,vrbs.R) = 1;
B(vrbs.R,vrbs.R) = rho_i;

A(vrbs.R,vrbs.pistar) = -(1-rho_i)*(1-phi_pi);
B(vrbs.R,vrbs.pi) = (1-rho_i)*phi_pi; 

B(vrbs.R,vrbs.c) = ((1-rho_i)*phi_x + phi_dx)*cy_ratio;
A(vrbs.R,vrbs.c_star) = ((1-rho_i)*phi_x + phi_dx)*cy_ratio;

B(vrbs.R,vrbs.c_lag) = -phi_dx*cy_ratio;
B(vrbs.R,vrbs.c_star) = phi_dx*cy_ratio;

A(vrbs.R,vrbs.m) = -1;

%% 3. tau - State
A(vrbs.tau,vrbs.tau) = 1;
B(vrbs.tau,vrbs.tau) = rho_tau;
B(vrbs.tau,vrbs.b_m) = (1-rho_tau)*phi_taul*(1+rho*P_m);                            
B(vrbs.tau,vrbs.P_m) = (1-rho_tau)*phi_taul*rho*by_ratio;                        
B(vrbs.tau,vrbs.c) = (1-rho_tau)*phi_taux*cy_ratio;                                   
B(vrbs.tau,vrbs.c_star) = -(1-rho_tau)*phi_taux*cy_ratio;                                    
A(vrbs.tau,vrbs.tau_shock) = -1;

%% 4. P_m - Jump
A(vrbs.P_m, vrbs.P_m) = -rho*beta*gamma^(-sigma);
A(vrbs.P_m, vrbs.R) = 1;
%A(vrbs.P_m, vrbs.b_shock) = 1;
A(vrbs.P_m, vrbs.b_shock) = sigma*(1+b*gamma^(-1))/(1-b*gamma^(-1)); % rescale
B(vrbs.P_m, vrbs.P_m) = -1;

%% 5. Gamma - Jump
B(vrbs.Gamma, vrbs.Gamma) = -1;
B(vrbs.Gamma, vrbs.y) = 1;
B(vrbs.Gamma, vrbs.N) =   -cy_ratio*wc_ratio;
B(vrbs.Gamma, vrbs.w_r) = -cy_ratio*wc_ratio;



% %% 8b Gamma - Jump (Alternative: using HH budget constraint)
% B(vrbs.Gamma, vrbs.Gamma) = cy_ratio^-1;
% A(vrbs.Gamma,vrbs.tau) = cy_ratio^-1;
% B(vrbs.Gamma, vrbs.N) = wc_ratio;
% B(vrbs.Gamma, vrbs.w_r) = wc_ratio;
% B(vrbs.Gamma, vrbs.c) = -1;
% A(vrbs.Gamma,vrbs.b_m)  =  P_m * cy_ratio^-1;
% B(vrbs.Gamma,vrbs.b_m)  =  beta^(-1)*gamma^(sigma - 1)*P_m * cy_ratio^-1;
% B(vrbs.Gamma, vrbs.pi) = -beta^(-1)*gamma^(sigma - 1)*by_ratio * cy_ratio^-1;                                                
% A(vrbs.Gamma, vrbs.gamma) = beta^(-1)*gamma^(sigma - 1)*by_ratio * cy_ratio^-1;
% B(vrbs.Gamma, vrbs.P_m) = (rho/gamma - 1)*by_ratio * cy_ratio^-1;



%% 6. c - Jump
B(vrbs.c, vrbs.N) = -xi_v;
B(vrbs.c, vrbs.c) = sigma*(1+b*gamma^(-1))/(1-b*gamma^(-1));
B(vrbs.c, vrbs.c_lag) = -sigma*b*gamma^(-1)/(1-b*gamma^(-1));
A(vrbs.c, vrbs.R) = -1;
%A(vrbs.c, vrbs.b_shock) = -1;
A(vrbs.c, vrbs.b_shock) = -sigma*(1+b*gamma^(-1))/(1-b*gamma^(-1)); % rescale
A(vrbs.c, vrbs.pi) = 1;
A(vrbs.c, vrbs.gamma) = -sigma*(b * gamma^(-1)*(1-rho_gamma)/(1-b*gamma^(-1)) - rho_gamma);                                  
A(vrbs.c, vrbs.N) = -xi_v;
A(vrbs.c, vrbs.c) = sigma/(1-b*gamma^(-1));                                                                           
A(vrbs.c, vrbs.xi) = -rho_xi + 1;


% %% 10. r_star - Jump
% B(vrbs.r_star, vrbs.N_star) = -xi_v;
% B(vrbs.r_star, vrbs.c_star) = sigma*(1+b*gamma^(-1))/(1-b*gamma^(-1));
% B(vrbs.r_star, vrbs.c_star_lag) = -sigma*b*gamma^(-1)/(1-b*gamma^(-1));
% B(vrbs.r_star, vrbs.r_star) = 1;
% 
% %A(vrbs.r_star, vrbs.b_shock) = -1;
% A(vrbs.r_star, vrbs.b_shock) = -sigma*(1+b*gamma^(-1))/(1-b*gamma^(-1)); % rescale
% 
% A(vrbs.r_star, vrbs.gamma) = -sigma*(b * gamma^(-1)*(1-rho_gamma)/(1-b*gamma^(-1)) - rho_gamma);                                  
% A(vrbs.r_star, vrbs.N_star) = -xi_v;
% A(vrbs.r_star, vrbs.c_star) = sigma/(1-b*gamma^(-1));                                                                           
% A(vrbs.r_star, vrbs.xi) = -rho_xi + 1;



%% 7. w_r - Jump
B(vrbs.w_r, vrbs.w_r) = -xi_w*(theta_w*c_3w+c_1w);
B(vrbs.w_r, vrbs.N) = -xi_w*c_3w;
B(vrbs.w_r, vrbs.c) = xi_w/(1-b*gamma^(-1));
B(vrbs.w_r, vrbs.c_lag) = -xi_w*(b*gamma^(-1))/(1-b*gamma^(-1));

B(vrbs.w_r, vrbs.w_r_lag) = 1;
B(vrbs.w_r, vrbs.pi_lag) = iota_w;
B(vrbs.w_r, vrbs.gamma) = iota_w;                                                                                      
B(vrbs.w_r, vrbs.pi) = -(1 + beta*gamma^(1-sigma)*iota_w);

A(vrbs.w_r, vrbs.w_r) = -beta * gamma^(1-sigma);
A(vrbs.w_r, vrbs.pi) = -beta * gamma^(1-sigma);
A(vrbs.w_r, vrbs.gamma) = xi_w*c_2w -beta * gamma^(1-sigma) * rho_gamma;
A(vrbs.w_r, vrbs.theta_w) = -xi_w*(theta_w*c_3w+c_1w-1); % rescaling

%% 8. c_r_star - Jump
A(vrbs.c_star, vrbs.c_star) = 1/(1-b*gamma^(-1)) - c_3w*cy_ratio;
B(vrbs.c_star, vrbs.c_star) = (b*gamma^(-1))/(1-b*gamma^(-1));
A(vrbs.c_star, vrbs.a_shock) = -(1-c_3w);
A(vrbs.c_star, vrbs.g) = -c_3w;
A(vrbs.c_star, vrbs.gamma) = (b*gamma^(-1))/(1-b*gamma^(-1));

%% 9. pi - Jump
B(vrbs.pi, vrbs.pi) = -1-beta * gamma^(1-sigma)*iota_p;
B(vrbs.pi, vrbs.w_r) = xi_p;
A(vrbs.pi, vrbs.a_shock) = xi_p;

% A(vrbs.pi, vrbs.theta_p) = xi_p/(theta_p - 1);
A(vrbs.pi, vrbs.theta_p) = -(1+beta * gamma^(1-sigma)*iota_p); %rescale
B(vrbs.pi, vrbs.pi_lag) = iota_p;
A(vrbs.pi, vrbs.pi) = -beta * gamma^(1-sigma);                                                                            
% B(vrbs.pi, vrbs.pi) = -beta * gamma^(1-sigma)*iota_p;

%% 10. b_m - State
A(vrbs.b_m, vrbs.b_m) = P_m;
B(vrbs.b_m, vrbs.b_m) = beta^(-1)*gamma^(sigma - 1)*P_m;
B(vrbs.b_m, vrbs.pi) = -beta^(-1)*gamma^(sigma - 1)*by_ratio;                                                
A(vrbs.b_m, vrbs.gamma) = beta^(-1)*gamma^(sigma - 1)*by_ratio;
B(vrbs.b_m, vrbs.P_m) = (rho/gamma - 1)*by_ratio;
A(vrbs.b_m, vrbs.tau) = 1;
%A(vrbs.b_m, vrbs.g) = -gy_ratio;
A(vrbs.b_m, vrbs.g) = -1;

%% 11. y - Jump
B(vrbs.y, vrbs.y) = -1;
B(vrbs.y, vrbs.c) = cy_ratio;
%A(vrbs.y, vrbs.g) = -gy_ratio;
A(vrbs.y, vrbs.g) = -1;

%% SHOCKS %%

%% 12. TFP shock
A(vrbs.gamma,vrbs.gamma) = 1;
B(vrbs.gamma,vrbs.gamma) = rho_gamma;
C(vrbs.gamma,shocks.gamma) = sigma_gamma;

%% 13. labor supply shock
A(vrbs.theta_w,vrbs.theta_w) = 1;
B(vrbs.theta_w,vrbs.theta_w) = rho_theta_w;
%B(vrbs.theta_w,vrbs.theta_w_eps) = -phi_theta_w; % MA component
C(vrbs.theta_w,shocks.theta_w) = sigma_theta_w;

%% 14. government spending shock
A(vrbs.g,vrbs.g) = 1;
B(vrbs.g,vrbs.g) = rho_g;
C(vrbs.g,shocks.g) = sigma_g;
C(vrbs.g,shocks.a) = sigma_ggam * sigma_a;


%% 15. preferences shock
A(vrbs.xi,vrbs.xi) = 1;
B(vrbs.xi,vrbs.xi) = rho_xi;
C(vrbs.xi,shocks.xi) = sigma_xi;

%% 16. Inflation target shock
A(vrbs.pistar,vrbs.pistar) = 1;
B(vrbs.pistar,vrbs.pistar) = rho_pistar;
C(vrbs.pistar,shocks.pistar) = sigma_pistar;

%% 17. cost-push shock
A(vrbs.theta_p,vrbs.theta_p) = 1;
B(vrbs.theta_p,vrbs.theta_p) = rho_theta_p;
%B(vrbs.theta_p,vrbs.theta_p_eps) = -phi_theta_p; % MA component
C(vrbs.theta_p,shocks.theta_p) = sigma_theta_p;

%% 18. policy shock
A(vrbs.m,vrbs.m) = 1;
B(vrbs.m,vrbs.m) = rho_m;
C(vrbs.m,shocks.m) = sigma_m;

%% 19. tax shock
A(vrbs.tau_shock,vrbs.tau_shock) = 1;
B(vrbs.tau_shock,vrbs.tau_shock) = rho_tau_hat;
C(vrbs.tau_shock,shocks.tau) = sigma_tau_hat;

%% 20. b shock
A(vrbs.b_shock,vrbs.b_shock) = 1;
B(vrbs.b_shock,vrbs.b_shock) = rho_b;
C(vrbs.b_shock,shocks.b) = sigma_b;

%% 21. a shock
A(vrbs.a_shock,vrbs.a_shock) = 1;
B(vrbs.a_shock,vrbs.a_shock) = rho_a;
C(vrbs.a_shock,shocks.a) = sigma_a;


% %% 35. theta_w innovation (for MA component)
% A(vrbs.theta_w_eps,vrbs.theta_w_eps) = 1;
% C(vrbs.theta_w_eps,shocks.theta_w) = sigma_theta_w;
% 
% %% 36. theta_p innovation (for MA component)
% A(vrbs.theta_p_eps,vrbs.theta_p_eps) = 1;
% C(vrbs.theta_p_eps,shocks.theta_p) = sigma_theta_p;

%% LAGS %%

%% 22. c_lag
A(vrbs.c_lag, vrbs.c_lag) = 1;
B(vrbs.c_lag, vrbs.c) = 1;

%% 23. w_r_lag
A(vrbs.w_r_lag, vrbs.w_r_lag) = 1;
B(vrbs.w_r_lag, vrbs.w_r) = 1;

%% 24. pi_lag
A(vrbs.pi_lag, vrbs.pi_lag) = 1;
B(vrbs.pi_lag, vrbs.pi) = 1;

%% 24. y_lag
A(vrbs.y_lag, vrbs.y_lag) = 1;
B(vrbs.y_lag, vrbs.y) = 1;

end

