function priors_est = definePriorsNocapital(params_fixed, params_index)


%% Households
priors.betaT.shape        = 'gampdf';         priors.betaT.mean     = 0.25;      priors.betaT.std  = 0.1;     %priors.betaT.fixed   = 0;
priors.theta_w.shape     = 'unspecified';  priors.theta_w.mean  = NaN;       priors.theta_w.std  = NaN;  %priors.theta_w.fixed = 1;
priors.sigma.shape       = 'normpdf';       priors.sigma.mean    = 1.5;       priors.sigma.std  = 0.5;   %priors.sigma.fixed = 0;
% Note increased std from 0.37 to 0.5, Dec 1, 3:07
%priors.phi_n.shape       = 'gampdf';      priors.phi_n.mean    = 0.5;       priors.phi_n.std  = 0.3;    %priors.phi_n.fixed = 0;
priors.phi_nT.shape       = 'normpdf';      priors.phi_nT.mean    = 2.0;       priors.phi_nT.std  = 0.75;    %priors.phi_n.fixed = 0;


priors.b.shape           = 'betapdf';         priors.b.mean        = 0.5;       priors.b.std  = 0.15;       % priors.b.fixed = 0;
% Note: I changed the mean to 0.6 from 0.7 on November 21, 11;10am.  
% Note: I changed the mean to 0.5 from 0.7 on November 21, 16;45am.  
% Note: I changed the std to 0.2 from 0.1 on Dec 1, 10;08am.  
% Note: I changed the std to 0.15 from 0.2 on Dec 1, 12;20am.  

%priors.xi_w.shape        = 'gampdf';      priors.xi_w.mean     = 0.1;       priors.xi_w.std  = 0.05;     %priors.xi_w.fixed = 0;
priors.xi_wT.shape        = 'betapdf';      priors.xi_wT.mean     = 0.5;       priors.xi_wT.std  = 0.05;     %priors.xi_w.fixed = 0;
priors.iota_w.shape      = 'betapdf';         priors.iota_w.mean   = 0.5;       priors.iota_w.std  = 0.15;  % priors.iota_w.fixed = 0;

%% Firms I
priors.gamma_1.shape     = 'betapdf';      priors.gamma_1.mean  = 0.5;     priors.gamma_1.std  = 0.05;  %priors.gamma_1.fixed = 0;
priors.iota_p.shape      = 'betapdf';         priors.iota_p.mean   = 0.5;     priors.iota_p.std  = 0.15;  %priors.iota_p.fixed = 0;

%priors.theta_p.shape     = 'unspecified';  priors.theta_p.mean  = NaN;     priors.theta_p.std  = NaN;  %priors.theta_p.fixed = 1;
priors.theta_pT.shape     = 'normpdf';  priors.theta_pT.mean  = 1.25;     priors.theta_pT.std  = 0.12;  %priors.theta_p.fixed = 1;


%% Monetary Policy
priors.phi_pi.shape      = 'normpdf';       priors.phi_pi.mean  = 1.5;      priors.phi_pi.std  = 0.15;  %priors.phi_pi.fixed = 0;
% Note: I changed the std to 0.15 from 0.25 on November 28, 11;08am.  
% Note: I changed the mean to 2 and std to 0.25on November 28, 16;36am. 
% Note: changed mean to 1.5 at some point before Nov 29.
% Note changed mean to 2 and std to 4, on Dec 1, 3:07 (from 1.5, 0.15
% baseline)

priors.rho_i.shape       = 'betapdf';       priors.rho_i.mean   = 0.5;     priors.rho_i.std  = 0.1;   %priors.rho_i.fixed = 0;
priors.phi_x.shape       = 'normpdf';       priors.phi_x.mean   = 0.12;      priors.phi_x.std  = 0.05;  %priors.phi_x.fixed = 0;
priors.phi_dx.shape       = 'normpdf';      priors.phi_dx.mean   = 0.12;     priors.phi_dx.std  = 0.05;  %priors.phi_x.fixed = 0;
priors.pi.shape          = 'gampdf';        priors.pi.mean      = 0.62;     priors.pi.std  = 0.10;  	  %priors.pi.fixed = 0;

%% Fiscal Policy
priors.by_ratio.shape    = 'unspecified';        priors.by_ratio.mean  = NaN;    priors.by_ratio.std  = NaN;  %priors.by_ratio.fixed = 1;
priors.rho.shape         = 'unspecified';           priors.rho.mean       = NaN;    priors.rho.std  = NaN;       %priors.rho.fixed = 1;
priors.rho_tau.shape     = 'betapdf';           priors.rho_tau.mean   = 0.5;    priors.rho_tau.std  = 0.1;   %priors.rho_tau.fixed = 1;
priors.phi_taul.shape    = 'gampdf';        priors.phi_taul.mean  = 0.07;    priors.phi_taul.std  = 0.02;  %priors.phi_taul.fixed = 1;
priors.phi_taux.shape    = 'normpdf';        priors.phi_taux.mean  = 0.02;    priors.phi_taux.std  = 0.1;  %priors.phi_taux.fixed = 1;
priors.gammaT.shape       = 'normpdf';        priors.gammaT.mean     = 0.4;    priors.gammaT.std  = 0.05; %priors.gamma.fixed = 1;


priors.gy_ratio.shape    = 'unspecified';        priors.gy_ratio.mean  = NaN;    priors.gy_ratio.std  = NaN;  %priors.gy_ratio.fixed = 1;

%% Learning
%priors.k_g.shape         = 'gampdf';           priors.k_g.mean       = 0.03;    priors.k_g.std  = 0.035;       %priors.rho.fixed = 1;
priors.k_g.shape         = 'gampdf';           priors.k_g.mean       = 0.035;    priors.k_g.std  = 0.03;       %priors.rho.fixed = 1; %Milani prior
%Slob-Wouters use m=0.035; std=0.03;
%Bench: 0.031; 0.022

% priors.k_gpi.shape         = 'normpdf';           priors.k_gpi.mean       = 0.03;    priors.k_gpi.std  = 1.035;       %priors.rho.fixed = 1;
% priors.k_gi.shape         = 'normpdf';           priors.k_gi.mean       = 0.03;    priors.k_gi.std  = 1.035;       %priors.rho.fixed = 1;

%% Autocorrelation of shocks
priors.rho_gamma.shape   = 'betapdf';         priors.rho_gamma.mean    = 0.5; priors.rho_gamma.std  = 0.2;    %priors.rho_gamma.fixed = 0;
priors.rho_theta_w.shape = 'betapdf';         priors.rho_theta_w.mean  = 0.5; priors.rho_theta_w.std  = 0.2;  %priors.rho_theta_w.fixed = 0;
priors.rho_theta_p.shape = 'betapdf';         priors.rho_theta_p.mean  = 0.5; priors.rho_theta_p.std  = 0.2;  %priors.rho_theta_p.fixed = 0;
priors.rho_g.shape       = 'betapdf';         priors.rho_g.mean        = 0.5; priors.rho_g.std  = 0.2;        %priors.rho_g.fixed = 0;
priors.rho_xi.shape      = 'betapdf';         priors.rho_xi.mean       = 0.5; priors.rho_xi.std  = 0.2;       %priors.rho_xi.fixed = 0;
priors.rho_pistar.shape  = 'betapdf';         priors.rho_pistar.mean  = 0.5;  priors.rho_pistar.std  = 0.2;   %priors.rho_pistar.fixed = 0;
priors.rho_m.shape       = 'betapdf';         priors.rho_m.mean  = 0.5;       priors.rho_m.std  = 0.2;        %priors.rho_m.fixed = 0;
priors.rho_tau_hat.shape = 'betapdf';         priors.rho_tau_hat.mean  = 0.5; priors.rho_tau_hat.std  = 0.2;  %priors.rho_tau_hat.fixed = 0;
priors.rho_b.shape       = 'betapdf';         priors.rho_b.mean  = 0.5;       priors.rho_b.std  = 0.2;        %priors.rho_b.fixed = 0;
priors.rho_a.shape       = 'betapdf';         priors.rho_a.mean  = 0.5;       priors.rho_a.std  = 0.2;        %priors.rho_b.fixed = 0;

%% MA components
% priors.phi_theta_w.shape = 'betapdf';         priors.phi_theta_w.mean  = 0.5;       priors.phi_theta_w.std  = 0.2;        %priors.rho_b.fixed = 0;
% priors.phi_theta_p.shape = 'betapdf';         priors.phi_theta_p.mean  = 0.5;       priors.phi_theta_p.std  = 0.2;        %priors.rho_b.fixed = 0;

%% Standard deviation of shocks
priors.sigma_gamma.shape    = 'invgampdf'; priors.sigma_gamma.mean  = 0.1;   priors.sigma_gamma.std  = 2.0;    %priors.sigma_gamma.fixed = 0;
priors.sigma_theta_w.shape  = 'invgampdf'; priors.sigma_theta_w.mean  = 0.1; priors.sigma_theta_w.std  = 2.0;  %priors.sigma_theta_w.fixed = 0;
priors.sigma_theta_p.shape  = 'invgampdf'; priors.sigma_theta_p.mean  = 0.1; priors.sigma_theta_p.std  = 2.0;  %priors.sigma_theta_p.fixed = 0;
priors.sigma_g.shape        = 'invgampdf'; priors.sigma_g.mean  = 0.1;       priors.sigma_g.std  = 2.0;        %priors.sigma_g.fixed = 0;
priors.sigma_xi.shape       = 'invgampdf'; priors.sigma_xi.mean  = 0.1;      priors.sigma_xi.std  = 2.0;       %priors.sigma_xi.fixed = 0;
priors.sigma_pistar.shape   = 'invgampdf'; priors.sigma_pistar.mean  = 0.1;  priors.sigma_pistar.std  = 2.0;   %priors.sigma_pistar.fixed = 0;
priors.sigma_m.shape        = 'invgampdf'; priors.sigma_m.mean  = 0.1;       priors.sigma_m.std  = 2.0;        %priors.sigma_m.fixed = 0;
priors.sigma_tau_hat.shape  = 'invgampdf'; priors.sigma_tau_hat.mean  = 0.1; priors.sigma_tau_hat.std  = 2.0;  %priors.sigma_tau_hat.fixed = 0;
priors.sigma_b.shape        = 'invgampdf'; priors.sigma_b.mean  = 0.1;       priors.sigma_b.std  = 2.0;        %priors.sigma_b.fixed = 0;
priors.sigma_a.shape        = 'invgampdf'; priors.sigma_a.mean  = 0.1;       priors.sigma_a.std  = 2.0;        %priors.sigma_b.fixed = 0;
priors.sigma_ggam.shape     = 'betapdf';   priors.sigma_ggam.mean  = 0.5;    priors.sigma_ggam.std  = 0.2;        %priors.sigma_b.fixed = 0;

%% Observation shocks
priors.sigma_oe_w.shape     = 'invgampdf'; priors.sigma_oe_w.mean  = 0.1;    priors.sigma_oe_w.std  = 2.0;     %priors.sigma_oe_w.fixed = 0;
priors.sigma_oe_bm.shape     = 'invgampdf'; priors.sigma_oe_bm.mean  = 0.1;    priors.sigma_oe_bm.std  = 2.0;     %priors.sigma_oe_bm.fixed = 0;
priors.sigma_oe_re.shape     = 'invgampdf'; priors.sigma_oe_re.mean  = 0.1;    priors.sigma_oe_re.std  = 2.0;     %priors.sigma_oe_w.fixed = 0;
priors.sigma_oe_rle.shape     = 'invgampdf'; priors.sigma_oe_rle.mean  = 0.1;    priors.sigma_oe_rle.std  = 2.0;     %priors.sigma_oe_bm.fixed = 0;
priors.sigma_oe_ple.shape     = 'invgampdf'; priors.sigma_oe_ple.mean  = 0.1;    priors.sigma_oe_ple.std  = 2.0;     %priors.sigma_oe_bm.fixed = 0;





%% Spread and Lmean
priors.ffrr.shape      = 'gampdf';  priors.ffrr.mean   = 1;      priors.ffrr.std  = 0.10;  	  %priors.pi.fixed = 0;


priors_est = assignPriorParams(priors,params_fixed, params_index); % Maybe return only priors for estimated params

end
