
function [systemMats, lambda,K_mat,flagd] = defineFullModelNocapital(vrbs,shocks,ModelDim,params,params_index,~, ~)

flagd = 0;
% Initialize canonical-form matrices (which we will later populate)
% Note: these matrices include extra entries for the lags, required for
% Reds-Solds. 

[beta, theta_w, sigma, ~, b, xi_w, iota_w, gamma_1, iota_p,  ~, phi_pi,...
    rho_i, phi_x, phi_dx,~, by_ratio, rho, rho_tau, phi_taul, phi_taux, gamma, ~, rho_gamma, rho_theta_w, ...
    rho_theta_p, rho_g, rho_xi, rho_pistar, rho_m,  rho_tau_hat, rho_b, rho_a,sigma_gamma, sigma_theta_w, ...
    sigma_theta_p, sigma_g, sigma_xi, sigma_pistar, sigma_m, sigma_tau_hat, sigma_b, sigma_a, sigma_ggam,~, ...
    ~, P_m, ~, ~, ~, ~,  cy_ratio, ...
    wc_ratio, xi_v, ~, ~, ~, xi_p, c_1w, c_2w, c_3w] = getparamsNocapital(params, params_index);


nvar = ModelDim.nvar;
nshock = ModelDim.nshock;
nlag = ModelDim.nlag;


% systemMats.A0=zeros(nvar,nvar);
% systemMats.A1=zeros(nvar,nvar);
% systemMats.A2=zeros(nvar,nvar);
% systemMats.A3=zeros(nvar,nvar);
% systemMats.A4=zeros(nvar,nvar);
% systemMats.A5=zeros(nvar,nvar);
% systemMats.A6=zeros(nvar,nshock);

% Matrices do not include lag_variables (redundant here)

systemMats.A0=zeros(nvar-nlag,nvar-nlag);
systemMats.A1=zeros(nvar-nlag,nvar-nlag);
systemMats.A2=zeros(nvar-nlag,nvar-nlag);
systemMats.A3=zeros(nvar-nlag,nvar-nlag);
systemMats.A4=zeros(nvar-nlag,nvar-nlag);
systemMats.A5=zeros(nvar-nlag,nvar-nlag);
systemMats.A6=zeros(nvar-nlag,nshock);



%% Households
% set number of variables
households.nvar  = 4;
households.nstate= 2;

% assign indices to relevant state variables
households.c       = 1;
households.w_r     = 2;
households.w_r_lag = 3;
households.d       = 4;

households.choice={'c','w_r'};

% delta: variables outside households' control

% delta_C = households.c; delta_w = households.w_r; delta_d = households.d-1; % NOT USED

% Define Psi_0 and Psi_1 matrices
households.Psi_0 = zeros(households.nvar,households.nvar);
households.Psi_1 = zeros(households.nvar,households.nvar);

households.Psi_0(households.c, households.c)            = sigma / (1 - b*gamma^(-1));
households.Psi_0(households.c,households.w_r)           = xi_v * theta_w;
households.Psi_0(households.w_r,households.w_r)         = -xi_w^(-1) * beta*gamma^(1-sigma);
households.Psi_0(households.w_r_lag,households.w_r_lag) = 1;
households.Psi_0(households.d, households.d)            = 1/cy_ratio;

households.Psi_1(households.c, households.c)            = sigma / (1 - b*gamma^(-1));
households.Psi_1(households.c,households.w_r)           = xi_v * theta_w;
households.Psi_1(households.w_r, households.c)          = 1 / (1 - b*gamma^(-1));
households.Psi_1(households.w_r,households.w_r)         = -c_1w;
households.Psi_1(households.w_r,households.w_r_lag)     = xi_w^(-1);
households.Psi_1(households.w_r_lag,households.w_r)     = 1;
households.Psi_1(households.d, households.c)            = -1;
households.Psi_1(households.d, households.w_r)          = wc_ratio  * (1 - theta_w);
households.Psi_1(households.d, households.d)            = beta^(-1) * gamma^(sigma - 1)/cy_ratio;


% get decision rule
[households.Dk, households.Dd1,  households.Dd2,  households.Lambda,flag] = getDecision(households.Psi_0, households.Psi_1, households.nstate);

if flag    
    
systemMats = NaN; lambda=NaN; K_mat=NaN; flagd=1; return

end
    
% Reduce size of households.Dd2 to eliminate the third column corresponding to
% households.w_r_lag

households.Dd2 = households.Dd2(:,[1 2 4]);


households.D_lambda1=households.Dd1*[households.Dd2(1,:);zeros(1,households.nvar-1)];
households.D_lambda2=households.Dd1*[zeros(1,households.nvar-1);households.Dd2(2,:)];
lambda_1=households.Lambda(1,1);
lambda_2=households.Lambda(2,2);


% here we check the coefficient on P_m(t-1) equals zero, as this is not one
% of our state variables

identity_1 = (households.Dk(1,2) - (households.D_lambda1(1,3) + households.D_lambda2(1,3))*beta^(-1)*gamma^(sigma-1)/cy_ratio) * by_ratio;
identity_2 = (households.Dk(2,2) - (households.D_lambda1(2,3) + households.D_lambda2(2,3))*beta^(-1)*gamma^(sigma-1)/cy_ratio) * by_ratio;


if identity_1>1e-10 || identity_2>1e-10 
    error('The coefficient on P_m(t-1) does not equal zero. This is likely caused by some error in the household decision rule you have defined.');
end


for l=1:2 % loop through choice variables
%for l=1:1 % loop through choice variables; TEST: only consumption function 
    
    systemMats.A0(vrbs.(households.choice{l}), vrbs.(households.choice{l})) = 1;
    systemMats.A5(vrbs.(households.choice{l}),vrbs.w_r) = households.Dk(l,1);
    systemMats.A5(vrbs.(households.choice{l}),vrbs.b_m) = households.Dk(l,2)*P_m;
    
    
    for  i = 1:2 % loop through eigenvalues
        
        % get D-matrix and lambda value associated with ith eigenvector
        evalc(['D = households.D_lambda' num2str(i)]);
        evalc(['lambda = lambda_' num2str(i)]);
       
        
        
        
        % Contemporaneous terms
        
        
        %P_C (delta_C)
        systemMats.A0(vrbs.(households.choice{l}), vrbs.w_r)        = systemMats.A0(vrbs.(households.choice{l}), vrbs.w_r)         + D(l,1) * xi_v * theta_w;
        systemMats.A0(vrbs.(households.choice{l}), vrbs.N)          = systemMats.A0(vrbs.(households.choice{l}), vrbs.N)           + D(l,1) * xi_v;
        systemMats.A0(vrbs.(households.choice{l}), vrbs.c)          = systemMats.A0(vrbs.(households.choice{l}), vrbs.c)           - D(l,1) * sigma * b * gamma^(-1) / (1 - b * gamma^(-1)) * (1 - lambda^(-1));
        systemMats.A0(vrbs.(households.choice{l}), vrbs.gamma)      = systemMats.A0(vrbs.(households.choice{l}), vrbs.gamma)       - D(l,1) * (sigma * (b * gamma^(-1)*(1-rho_gamma) / (1 - b * gamma^(-1)) - rho_gamma));
        systemMats.A0(vrbs.(households.choice{l}), vrbs.xi)         = systemMats.A0(vrbs.(households.choice{l}), vrbs.xi)          - D(l,1) * (rho_xi - 1);
        systemMats.A5(vrbs.(households.choice{l}), vrbs.c)          = systemMats.A5(vrbs.(households.choice{l}), vrbs.c)           - D(l,1) * (sigma * b * gamma^(-1) / (1 - b * gamma^(-1)));
        systemMats.A0(vrbs.(households.choice{l}), vrbs.R)          = systemMats.A0(vrbs.(households.choice{l}), vrbs.R)           - D(l,1);
        systemMats.A0(vrbs.(households.choice{l}), vrbs.b_shock)    = systemMats.A0(vrbs.(households.choice{l}), vrbs.b_shock)     - D(l,1) * sigma * ((1 + b * gamma^(-1)) / (1 - b * gamma^(-1))); % rescale
        %systemMats.A0(vrbs.(households.choice{l}), vrbs.b_shock)    = systemMats.A0(vrbs.(households.choice{l}), vrbs.b_shock)     - D(l,1);
        
        %P_w (delta_w)
        systemMats.A0(vrbs.(households.choice{l}), vrbs.w_r)    = systemMats.A0(vrbs.(households.choice{l}), vrbs.w_r)    + D(l,2) * c_3w * theta_w;
        systemMats.A0(vrbs.(households.choice{l}), vrbs.N)      = systemMats.A0(vrbs.(households.choice{l}), vrbs.N)      + D(l,2) * c_3w;
        systemMats.A0(vrbs.(households.choice{l}), vrbs.pi)     = systemMats.A0(vrbs.(households.choice{l}), vrbs.pi)     + D(l,2) * (xi_w^(-1) * (1+beta*gamma^(1-sigma)*iota_w) - lambda^(-1) * xi_w^(-1) * iota_w);
        systemMats.A0(vrbs.(households.choice{l}), vrbs.gamma)  = systemMats.A0(vrbs.(households.choice{l}), vrbs.gamma)  + D(l,2) * (c_2w - xi_w^(-1) * beta * gamma^(1-sigma) * rho_gamma - lambda^(-1) * xi_w^(-1) * iota_w);
        %systemMats.A0(vrbs.(households.choice{l}), vrbs.theta_w)= systemMats.A0(vrbs.(households.choice{l}), vrbs.theta_w)+ D(l,2) * (1/(theta_w-1));
        systemMats.A0(vrbs.(households.choice{l}), vrbs.theta_w)= systemMats.A0(vrbs.(households.choice{l}), vrbs.theta_w)+ D(l,2) * (-(c_1w-1+c_3w * theta_w)); %rescale
        systemMats.A0(vrbs.(households.choice{l}), vrbs.c)      = systemMats.A0(vrbs.(households.choice{l}), vrbs.c)      + D(l,2) * lambda^(-1) * b * gamma^(-1) / (1-b*gamma^(-1));
        systemMats.A5(vrbs.(households.choice{l}), vrbs.c)      = systemMats.A5(vrbs.(households.choice{l}), vrbs.c)      - D(l,2) * b * gamma^(-1) / (1-b*gamma^(-1));
        systemMats.A5(vrbs.(households.choice{l}), vrbs.pi)     = systemMats.A5(vrbs.(households.choice{l}), vrbs.pi)     + D(l,2) * xi_w ^(-1) * iota_w;
        systemMats.A5(vrbs.(households.choice{l}), vrbs.gamma)  = systemMats.A5(vrbs.(households.choice{l}), vrbs.gamma)  + D(l,2) * xi_w ^(-1) * iota_w;
        
        %P_d (delta_d)
        systemMats.A0(vrbs.(households.choice{l}), vrbs.P_m)   = systemMats.A0(vrbs.(households.choice{l}), vrbs.P_m)   - D(l,3) * beta^(-1) * gamma^(sigma - 1) * by_ratio / cy_ratio*rho*beta*gamma^(-sigma);
        systemMats.A0(vrbs.(households.choice{l}), vrbs.pi)    = systemMats.A0(vrbs.(households.choice{l}), vrbs.pi)    + D(l,3) * beta^(-1) * gamma^(sigma - 1) * by_ratio / cy_ratio;
        systemMats.A0(vrbs.(households.choice{l}), vrbs.gamma) = systemMats.A0(vrbs.(households.choice{l}), vrbs.gamma) + D(l,3) * beta^(-1) * gamma^(sigma - 1) * by_ratio / cy_ratio;
        systemMats.A0(vrbs.(households.choice{l}), vrbs.w_r)   = systemMats.A0(vrbs.(households.choice{l}), vrbs.w_r)   - D(l,3) * wc_ratio * theta_w;
        systemMats.A0(vrbs.(households.choice{l}), vrbs.N)     = systemMats.A0(vrbs.(households.choice{l}), vrbs.N)     - D(l,3) * wc_ratio;
        systemMats.A0(vrbs.(households.choice{l}), vrbs.Gamma) = systemMats.A0(vrbs.(households.choice{l}), vrbs.Gamma) - D(l,3)/cy_ratio;
        systemMats.A0(vrbs.(households.choice{l}), vrbs.tau)   = systemMats.A0(vrbs.(households.choice{l}), vrbs.tau)   + D(l,3)/cy_ratio;
        systemMats.A0(vrbs.(households.choice{l}), vrbs.R)     = systemMats.A0(vrbs.(households.choice{l}), vrbs.R)     - D(l,3)*lambda^(-1)*beta^(-1)*gamma^(sigma-1) * by_ratio / cy_ratio;
        %systemMats.A0(vrbs.(households.choice{l}), vrbs.b_shock)     = systemMats.A0(vrbs.(households.choice{l}), vrbs.b_shock)     - D(l,3)*lambda^(-1)*beta^(-1)*gamma^(sigma-1) * by_ratio / cy_ratio;
        systemMats.A0(vrbs.(households.choice{l}), vrbs.b_shock)     = systemMats.A0(vrbs.(households.choice{l}), vrbs.b_shock)     - (D(l,3)*lambda^(-1)*beta^(-1)*gamma^(sigma-1) * by_ratio / cy_ratio)*sigma * ((1 + b * gamma^(-1)) / (1 - b * gamma^(-1))); % rescale

        
        % Discounted forecasts
        
        %P_C (delta_C)
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.c)       = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.c)     + D(l,1)*sigma*b*gamma^(-1)*lambda^(-1)/(1-b*gamma^(-1))*(1-lambda^-1);
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.gamma)   = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.gamma) + D(l,1)*lambda^(-1)*sigma*(b*gamma^(-1)*(1-rho_gamma)/(1-b*gamma^(-1)) - rho_gamma);
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.pi)      = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.pi)    - D(l,1);
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.w_r)     = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.w_r)   + D(l,1)*xi_v*theta_w*(1-lambda^(-1));
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.N)       = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.N)     + D(l,1)*(1-lambda^(-1))*xi_v;
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.xi)      = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.xi)    + D(l,1)*lambda^(-1)*(rho_xi - 1);
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.R)       = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.R)     + D(l,1)*lambda^(-1);
%        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.b_shock)       = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.b_shock)     + D(l,1)*lambda^(-1);
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.b_shock)       = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.b_shock)     + D(l,1)*lambda^(-1)*sigma * ((1 + b * gamma^(-1)) / (1 - b * gamma^(-1))); % rescale

        %P_w (delta_w)
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.w_r)     = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.w_r)     - D(l,2)*lambda^(-1)*c_3w*theta_w;
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.N)       = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.N)       - D(l,2)*lambda^(-1)*c_3w;
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.c)       = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.c)       - D(l,2)*lambda^(-2)*b*gamma^(-1)/(1-b*gamma^(-1));
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.pi)      = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.pi)      - D(l,2)*(lambda^(-1)*xi_w^(-1)*(1+beta*gamma^(1-sigma)*iota_w) - lambda^(-2)*xi_w^(-1)*iota_w - xi_w^(-1)*beta*gamma^(1-sigma));
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.gamma)   = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.gamma)   - D(l,2) * (lambda^(-1) * (c_2w - xi_w^(-1)*beta*gamma^(1-sigma)*rho_gamma) - lambda^(-2)*xi_w^(-1)*iota_w);
        %systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.theta_w) = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.theta_w) - D(l,2) * lambda ^(-1)/(theta_w-1);
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.theta_w) = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.theta_w) - D(l,2) * lambda ^(-1)*(-(c_1w-1+c_3w * theta_w)); %rescale;

        %P_d (delta_d)
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.R)       = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.R)     + D(l,3)*lambda^(-2)*beta^(-1)*gamma^(sigma-1)*by_ratio/cy_ratio;
        %systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.b_shock)       = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.b_shock)     + D(l,3)*lambda^(-2)*beta^(-1)*gamma^(sigma-1)*by_ratio/cy_ratio;
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.b_shock)       = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.b_shock)     + (D(l,3)*lambda^(-2)*beta^(-1)*gamma^(sigma-1)*by_ratio/cy_ratio)*sigma * ((1 + b * gamma^(-1)) / (1 - b * gamma^(-1))); % rescale
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.pi)      = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.pi)    - D(l,3)*lambda^(-1)*beta^(-1)*gamma^(sigma-1)*by_ratio/cy_ratio;
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.gamma)   = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.gamma) - D(l,3)*lambda^(-1)*beta^(-1)*gamma^(sigma-1)*by_ratio/cy_ratio;
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.w_r)     = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.w_r)   + D(l,3)*lambda^(-1)*wc_ratio*theta_w;
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.N)       = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.N)     + D(l,3) *lambda^(-1)*wc_ratio;
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.Gamma)   = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.Gamma) + D(l,3) *lambda^(-1)/cy_ratio;
        systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.tau)     = systemMats.(['A' num2str(i)])(vrbs.(households.choice{l}), vrbs.tau)   - D(l,3) *lambda^(-1)/cy_ratio;
        
    end
    
end

%% static wage equation (flex wages): TEST

% systemMats.A0(vrbs.w_r, vrbs.w_r) = c_1w + c_3w*theta_w;
% systemMats.A0(vrbs.w_r, vrbs.N) = c_3w;
% systemMats.A0(vrbs.w_r, vrbs.c) = -1 / (1-b*gamma^(-1));
% systemMats.A7(vrbs.w_r, vrbs.c) = - b*gamma^(-1)/ (1-b*gamma^(-1));



%% Bonds decision rule
lambda_4 = 1/(rho*beta*gamma^(-sigma));

systemMats.A0(vrbs.P_m,vrbs.P_m) = systemMats.A0(vrbs.P_m,vrbs.P_m) +1;
systemMats.A0(vrbs.P_m,vrbs.R)   = systemMats.A0(vrbs.P_m,vrbs.R) +1;
%systemMats.A0(vrbs.P_m,vrbs.b_shock)   = systemMats.A0(vrbs.P_m,vrbs.b_shock) +1;
systemMats.A0(vrbs.P_m,vrbs.b_shock)   = systemMats.A0(vrbs.P_m,vrbs.b_shock) +sigma * ((1 + b * gamma^(-1)) / (1 - b * gamma^(-1))); % rescale

systemMats.A4(vrbs.P_m,vrbs.R) = systemMats.A4(vrbs.P_m, vrbs.R) - rho*beta*gamma^(-sigma);
%systemMats.A6(vrbs.P_m,vrbs.b_shock) = systemMats.A6(vrbs.P_m, vrbs.b_shock) - rho*beta*gamma^(-sigma);
systemMats.A4(vrbs.P_m,vrbs.b_shock) = systemMats.A4(vrbs.P_m, vrbs.b_shock) - rho*beta*gamma^(-sigma)*sigma * ((1 + b * gamma^(-1)) / (1 - b * gamma^(-1))); % rescale


%% Firm's decision rule (intermediate inputs)

% analytic solution: (we will use this to check that the algorithmic
% solution is correct)
lambda_3 = 1/(gamma_1 * beta * gamma^(1-sigma));

systemMats.A0(vrbs.pi, vrbs.pi)      = 1 + beta * gamma^(1-sigma) * iota_p * (1-gamma_1);
systemMats.A5(vrbs.pi, vrbs.pi)      = iota_p;
systemMats.A0(vrbs.pi, vrbs.w_r)     = - xi_p;
%systemMats.A0(vrbs.pi, vrbs.theta_p) = xi_p/(theta_p - 1);
systemMats.A0(vrbs.pi, vrbs.theta_p) = -(1 + beta * gamma^(1-sigma) * iota_p); % rescale
systemMats.A0(vrbs.pi, vrbs.a_shock) = xi_p;

systemMats.A3(vrbs.pi, vrbs.w_r)     = xi_p*gamma_1*beta*gamma^(1-sigma);
%systemMats.A3(vrbs.pi, vrbs.theta_p) = - xi_p*gamma_1*beta*gamma^(1-sigma) /(theta_p - 1);
systemMats.A3(vrbs.pi, vrbs.theta_p) = -gamma_1*beta*gamma^(1-sigma) * (-(1 + beta * gamma^(1-sigma) * iota_p)); % rescale
systemMats.A3(vrbs.pi, vrbs.pi)      = beta*gamma^(1-sigma)*(1-gamma_1)*(1-iota_p*gamma_1*beta*gamma^(1-sigma));
systemMats.A3(vrbs.pi, vrbs.a_shock) = -xi_p*gamma_1*beta*gamma^(1-sigma);


%% Dynamic equilibrium conditions: natural variables


% %% r*
% systemMats.A0(vrbs.r_star, vrbs.r_star) = 1;
% systemMats.A7(vrbs.r_star, :) = Omega_Z(vrbs.r_star,:);
% systemMats.A8(vrbs.r_star, :) = Omega_epsilon(vrbs.r_star,:);


%% Static Equilibrium Conditions %%

%% N - Jump
systemMats.A0(vrbs.N, vrbs.N) = 1;
systemMats.A0(vrbs.N, vrbs.y) = -1;
systemMats.A0(vrbs.N, vrbs.a_shock) = 1;


%% R - State
systemMats.A0(vrbs.R,vrbs.R) = 1;
systemMats.A5(vrbs.R,vrbs.R) = rho_i;

systemMats.A0(vrbs.R,vrbs.pistar) = -(1-rho_i)*(1-phi_pi);
systemMats.A0(vrbs.R,vrbs.pi) = -(1-rho_i)*phi_pi;

systemMats.A0(vrbs.R,vrbs.c) = -((1-rho_i)*phi_x + phi_dx)*cy_ratio;
systemMats.A0(vrbs.R,vrbs.c_star) = ((1-rho_i)*phi_x + phi_dx)*cy_ratio;

systemMats.A5(vrbs.R,vrbs.c) = -phi_dx*cy_ratio;
systemMats.A5(vrbs.R,vrbs.c_star) = phi_dx*cy_ratio;

systemMats.A0(vrbs.R,vrbs.m) = -1;

%% tau - State
systemMats.A0(vrbs.tau,vrbs.tau) = 1;
systemMats.A5(vrbs.tau,vrbs.tau) = rho_tau;
systemMats.A5(vrbs.tau,vrbs.b_m) = (1-rho_tau)*phi_taul*(1+rho*P_m);
systemMats.A0(vrbs.tau,vrbs.P_m) = -(1-rho_tau)*phi_taul*rho*by_ratio;
systemMats.A0(vrbs.tau,vrbs.c) = -(1-rho_tau)*phi_taux*cy_ratio;
systemMats.A0(vrbs.tau,vrbs.c_star) = (1-rho_tau)*phi_taux*cy_ratio;
systemMats.A0(vrbs.tau,vrbs.tau_shock) = -1;


%% Gamma - Jump
systemMats.A0(vrbs.Gamma, vrbs.Gamma) = 1;
systemMats.A0(vrbs.Gamma, vrbs.y) = -1;
systemMats.A0(vrbs.Gamma, vrbs.N) =   cy_ratio*wc_ratio;
systemMats.A0(vrbs.Gamma, vrbs.w_r) = cy_ratio*wc_ratio;


%% c_r_star - Jump
systemMats.A0(vrbs.c_star, vrbs.c_star) = 1/(1-b*gamma^(-1)) - c_3w*cy_ratio;
systemMats.A5(vrbs.c_star, vrbs.c_star) = (b*gamma^(-1))/(1-b*gamma^(-1));
systemMats.A0(vrbs.c_star, vrbs.a_shock) =  -(1-c_3w);
systemMats.A0(vrbs.c_star, vrbs.g) = -c_3w;
systemMats.A0(vrbs.c_star, vrbs.gamma) = (b*gamma^(-1))/(1-b*gamma^(-1));


%% b_m - State
systemMats.A0(vrbs.b_m, vrbs.b_m) = P_m;
systemMats.A5(vrbs.b_m, vrbs.b_m) = beta^(-1)*gamma^(sigma - 1)*P_m;
systemMats.A0(vrbs.b_m, vrbs.pi) = beta^(-1)*gamma^(sigma - 1)*by_ratio;
systemMats.A0(vrbs.b_m, vrbs.gamma) = beta^(-1)*gamma^(sigma - 1)*by_ratio;
systemMats.A0(vrbs.b_m, vrbs.P_m) = -(rho/gamma - 1)*by_ratio;
systemMats.A0(vrbs.b_m, vrbs.tau) = 1;
%systemMats.A0(vrbs.b_m, vrbs.g) = -gy_ratio;
systemMats.A0(vrbs.b_m, vrbs.g) = -1; % rescale


%% y - Jump
systemMats.A0(vrbs.y, vrbs.y) = 1;
systemMats.A0(vrbs.y, vrbs.c) = -cy_ratio;
%systemMats.A0(vrbs.y, vrbs.g) = -gy_ratio;
systemMats.A0(vrbs.y, vrbs.g) = -1; % rescale

%% SHOCKS %%

%% TFP shock
systemMats.A0(vrbs.gamma,vrbs.gamma)=1;
systemMats.A5(vrbs.gamma,vrbs.gamma)=rho_gamma;
systemMats.A6(vrbs.gamma,shocks.gamma)=sigma_gamma;

%% labor supply shock
systemMats.A0(vrbs.theta_w,vrbs.theta_w)=1;
systemMats.A5(vrbs.theta_w,vrbs.theta_w)=rho_theta_w;
% systemMats.A5(vrbs.theta_w,vrbs.theta_w_eps) = -phi_theta_w; % MA component
systemMats.A6(vrbs.theta_w,shocks.theta_w)=sigma_theta_w;

%% government spending shock
systemMats.A0(vrbs.g,vrbs.g)=1;
systemMats.A5(vrbs.g,vrbs.g)=rho_g;
systemMats.A6(vrbs.g,shocks.g)=sigma_g;
systemMats.A6(vrbs.g,shocks.a)=sigma_ggam * sigma_a;

%% preferences shock
systemMats.A0(vrbs.xi,vrbs.xi)=1;
systemMats.A5(vrbs.xi,vrbs.xi)=rho_xi;
systemMats.A6(vrbs.xi,shocks.xi)=sigma_xi;

%% Inflation target shock
systemMats.A0(vrbs.pistar,vrbs.pistar)=1;
systemMats.A5(vrbs.pistar,vrbs.pistar)=rho_pistar;
systemMats.A6(vrbs.pistar,shocks.pistar)=sigma_pistar;

%% cost-push shock
systemMats.A0(vrbs.theta_p,vrbs.theta_p)=1;
systemMats.A5(vrbs.theta_p,vrbs.theta_p)=rho_theta_p;
%systemMats.A5(vrbs.theta_p,vrbs.theta_p_eps)=-phi_theta_p;
systemMats.A6(vrbs.theta_p,shocks.theta_p)=sigma_theta_p;

%% policy shock
systemMats.A0(vrbs.m,vrbs.m)=1;
systemMats.A5(vrbs.m,vrbs.m)=rho_m;
systemMats.A6(vrbs.m,shocks.m)=sigma_m;

%% tax shock
systemMats.A0(vrbs.tau_shock,vrbs.tau_shock)=1;
systemMats.A5(vrbs.tau_shock,vrbs.tau_shock)=rho_tau_hat;
systemMats.A6(vrbs.tau_shock,shocks.tau)=sigma_tau_hat;

%% b shock
systemMats.A0(vrbs.b_shock,vrbs.b_shock)=1;
systemMats.A5(vrbs.b_shock,vrbs.b_shock)=rho_b;
systemMats.A6(vrbs.b_shock,shocks.b)=sigma_b;

%% a shock
systemMats.A0(vrbs.a_shock,vrbs.a_shock)=1;
systemMats.A5(vrbs.a_shock,vrbs.a_shock)=rho_a;
systemMats.A6(vrbs.a_shock,shocks.a)=sigma_a;

% %%  theta_w innovation (for MA component)
% systemMats.A0(vrbs.theta_w_eps,vrbs.theta_w_eps) = 1;
% systemMats.A8(vrbs.theta_w_eps,shocks.theta_w) = sigma_theta_w;
% 
% %%  theta_p innovation (for MA component)
% systemMats.A0(vrbs.theta_p_eps,vrbs.theta_p_eps) = 1;
% systemMats.A8(vrbs.theta_p_eps,shocks.theta_p) = sigma_theta_p;

% %% Remove lag variables as states (they are not necessary)
% if nlag>0
%     remove_inds=nvar-nlag+1:nvar;
% end
% 
% systemMats.A0(remove_inds,:)=[];systemMats.A0(:,remove_inds)=[];
% systemMats.A1(remove_inds,:)=[];systemMats.A1(:,remove_inds)=[];
% systemMats.A2(remove_inds,:)=[];systemMats.A2(:,remove_inds)=[];
% systemMats.A3(remove_inds,:)=[];systemMats.A3(:,remove_inds)=[];
% systemMats.A4(remove_inds,:)=[];systemMats.A4(:,remove_inds)=[];
% systemMats.A5(remove_inds,:)=[];systemMats.A5(:,remove_inds)=[];
% systemMats.A6(remove_inds,:)=[];systemMats.A6(:,remove_inds)=[];
% systemMats.A7(remove_inds,:)=[];systemMats.A7(:,remove_inds)=[];
% systemMats.A8(remove_inds,:)=[];

% save 6 discount factors as one vector
lambda=[lambda_1 lambda_2 lambda_3 lambda_4];


%% Kalman matrix for beliefs updates

    k_g = params(params_index.k_g);
%     k_gpi = params(params_index.k_gpi);
%     k_gi = params(params_index.k_gi);
    
    K_mat = k_g * eye(ModelDim.nestimated);


