
function [F,Sc,Q] = add_to_StateSpaceNocapital(vrbs,params,params_index,T_Z,T_epsilon,nlag,noe,shocks_oe,learning,S)

% NOTE: XX I have added S here!


% extend state space with extra lags and observation errors

F = [T_Z, zeros(size(T_Z,1),nlag + noe)
     zeros(nlag+noe,size(T_Z,2)+nlag + noe)];

Sc = [T_epsilon, zeros(size(T_epsilon,1),noe)
      zeros(nlag+noe,size(T_epsilon,2)+ noe)];

  

%% c_lag
F(S.vrbsL.c_lag , S.vrbsL.c) = 1;

%% w_r_lag
F(S.vrbsL.w_r_lag, S.vrbsL.w_r) = 1;

%% pi_lag
F(S.vrbsL.pi_lag, S.vrbsL.pi) = 1;

%% y_lag
F(S.vrbsL.y_lag, S.vrbsL.y) = 1;


%% observation shock on wage

Sc(S.vrbsL.oe_wage,shocks_oe.wage) = params(params_index.sigma_oe_w);

%% observation shock on gov debt

Sc(S.vrbsL.oe_bm,shocks_oe.bm) = params(params_index.sigma_oe_bm);

%% observation shock on Tbill Q1exp

Sc(S.vrbsL.oe_Re,shocks_oe.Re) = params(params_index.sigma_oe_re);

%% observation shock on Tbill exp 510

Sc(S.vrbsL.oe_RLe,shocks_oe.RLe) = params(params_index.sigma_oe_rle);

%% observation shock on infl exp 510

Sc(S.vrbsL.oe_pLe,shocks_oe.pLe) = params(params_index.sigma_oe_ple);



Q = Sc*Sc'; 
