function [T_Z, T_epsilon, T_0,max_eig] = T_mapNocapital(systemMats_full,Omega_Z, lambda,S,K,nlearn)

% This function takes the system matrices from a full model and rational
% expectations model. It determines whether the RE model serves as a
% solution for the full mode. For derivations of these formulas, please see
% the model documentation.

% compute intermediate product X
fields_to_sum={'A1','A2','A3','A4'};

X = zeros(size(systemMats_full.A0));
X_0 = zeros(size(systemMats_full.A0));

    %invOmZ = inv(eye(size(Omega_Z))-Omega_Z);
    invOmZ = (eye(size(Omega_Z))-Omega_Z)\eye(size(Omega_Z));

for i_mat=1:size(fields_to_sum,2)
    
%    invOmZlam = Omega_Z*inv(eye(size(Omega_Z))-lambda(i_mat)^(-1)*Omega_Z);
    invOmZlam = Omega_Z/(eye(size(Omega_Z))-lambda(i_mat)^(-1)*Omega_Z);
%    inv0mZlam1 = inv(1-lambda(i_mat)^(-1))*eye(size(Omega_Z));

    inv0mZlam1 = (1-lambda(i_mat)^(-1))*eye(size(Omega_Z))\eye(size(Omega_Z));   
    
    X   = X+systemMats_full.(fields_to_sum{i_mat})*invOmZlam;
    %X   = X+systemMats_full.(fields_to_sum{i_mat})*Omega_Z*inv(eye(size(Omega_Z))-lambda(i_mat)^(-1)*Omega_Z);
    X_0 = X_0 + systemMats_full.(fields_to_sum{i_mat})*invOmZ * (inv0mZlam1 - invOmZlam);
%   X_0 = X_0 + systemMats_full.(fields_to_sum{i_mat})*inv(eye(size(Omega_Z))-Omega_Z) * ...
%               (inv(1-lambda(i_mat)^(-1))*eye(size(Omega_Z)) - Omega_Z*inv(eye(size(Omega_Z))-lambda(i_mat)^(-1)*Omega_Z));
end

% calculate T_Z and T_epsilon
% T_Z       = inv(systemMats_full.A0-X)*systemMats_full.A7;
% T_epsilon = inv(systemMats_full.A0-X)*systemMats_full.A8;
% T_0       = inv(systemMats_full.A0-X)*X_0;


T_Z       = (systemMats_full.A0-X)\systemMats_full.A5;
T_epsilon = (systemMats_full.A0-X)\systemMats_full.A6;
T_0       = (systemMats_full.A0-X)\X_0;

max_eig = max(abs(eig(eye(nlearn)+K*S.Sz*(T_0-eye(size(T_0,1)))*S.Som)));


end