function [params, params_index, params_fixed,trspec,bounds] = setParamsLaubach(learning)

% This function outputs the params structure, which contains initialized values 
% of the model paramseters as well as derived steady-state values.

params_index.a_x1 = 1;      params(params_index.a_x1,1)       = 1.6;    params_fixed(params_index.a_x1,1) = 0;    
trspec(params_index.a_x1,:) = [2	1E-5	0	1]; bounds(params_index.a_x1,:) = [1E-5 50.999];

params_index.a_x2 = 2;      params(params_index.a_x2,1)       = -0.8;    params_fixed(params_index.a_x2,1) = 0;   
trspec(params_index.a_x2,:) = zeros(1,4); bounds(params_index.a_x2,:) = [-50.999 50.999];


params_index.a_s1 = 3;      params(params_index.a_s1,1)     = 0;       params_fixed(params_index.a_s1,1) = 1;    
trspec(params_index.a_s1,:) = [2	1E-5	0	1];  bounds(params_index.a_s1,:) = [1E-5 50.999];

params_index.a_s2 = 4;      params(params_index.a_s2,1)     = 0;       params_fixed(params_index.a_s2,1) = 1;   
trspec(params_index.a_s2,:) = zeros(1,4); bounds(params_index.a_s2,:) = [-50.999 50.999];
%trspec(params_index.a_s2,:) = [2	1E-5	0	1]; bounds(params_index.a_s2,:) = [1E-5 50.999];

params_index.a_s3 = 5;      params(params_index.a_s3,1)     = 0.5;       params_fixed(params_index.a_s3,1) = 0;  
trspec(params_index.a_s3,:) = [1	1E-5	.99	1]; bounds(params_index.a_s3,:) = [1E-5 0.989];


params_index.a_f1 = 6;      params(params_index.a_f1,1)     = 0.0;       params_fixed(params_index.a_f1,1) = 1;    
trspec(params_index.a_f1,:) = [2	1E-5	0	1]; bounds(params_index.a_f1,:) = [1E-5 50.999];
% Note: this is the negative of this parameter

params_index.a_f2 = 7;      params(params_index.a_f2,1)     = 0.0;       params_fixed(params_index.a_f2,1) = 1;    
trspec(params_index.a_f2,:) = zeros(1,4); bounds(params_index.a_f2,:) = [-50.999 50.999];
%trspec(params_index.a_f2,:) = [2	1E-5	0	1]; bounds(params_index.a_f2,:) = [1E-5 50.999];

params_index.a_f3 = 8;      params(params_index.a_f3,1)     = 0.3;       params_fixed(params_index.a_f3,1) = 0;    
trspec(params_index.a_f3,:) = [1	1E-5	.99	1]; bounds(params_index.a_f3,:) = [1E-5 0.989];


params_index.a_chi1 = 9;    params(params_index.a_chi1,1)     = 0.1;       params_fixed(params_index.a_chi1,1) = 0;  
trspec(params_index.a_chi1,:) = [2	1E-5	0	1]; bounds(params_index.a_chi1,:) = [1E-5 50.999];
% Note: this is the negative of this parameter

params_index.a_chi2 = 10;    params(params_index.a_chi2,1)     = 0.00;       params_fixed(params_index.a_chi2,1) = 1;    
trspec(params_index.a_chi2,:) = zeros(1,4);  bounds(params_index.a_chi2,:) = [-50.999 50.999];

params_index.a_chi3 = 11;    params(params_index.a_chi3,1)     = 0.9;       params_fixed(params_index.a_chi3,1) = 0;   
trspec(params_index.a_chi3,:) = [1	1E-5	.99	1]; bounds(params_index.a_chi3,:) = [1E-5 0.989]; 


params_index.a_pi1 = 12;     params(params_index.a_pi1,1)      = 0.01;       params_fixed(params_index.a_pi1,1) = 0;      
trspec(params_index.a_pi1,:) = zeros(1,4); bounds(params_index.a_pi1,:) = [-50.999 50.999];

params_index.a_pi2 = 13;    params(params_index.a_pi2,1)      = 0.01;       params_fixed(params_index.a_pi2,1) = 0; 
trspec(params_index.a_pi2,:) = zeros(1,4); bounds(params_index.a_pi2,:) = [-50.999 50.999];

params_index.a_pi3 = 14;    params(params_index.a_pi3,1)      = 0.01;       params_fixed(params_index.a_pi3,1) = 0;      
trspec(params_index.a_pi3,:) = zeros(1,4); bounds(params_index.a_pi3,:) = [-50.999 50.999];


params_index.a_xpi1 = 15;    params(params_index.a_xpi1,1)      = 0.1;       params_fixed(params_index.a_xpi1,1) = 0;     
trspec(params_index.a_xpi1,:) = [2	1E-5	0	1]; bounds(params_index.a_xpi1,:) = [1E-5 50.999];
% Note: this is the negative of this parameter
params_index.a_xpi2 = 16;    params(params_index.a_xpi2,1)      = 0.0;       params_fixed(params_index.a_xpi2,1) = 1;     
trspec(params_index.a_xpi2,:) = zeros(1,4); bounds(params_index.a_xpi2,:) = [-50.999 50.999];

params_index.a_xpi3 = 17;    params(params_index.a_xpi3,1)      = 0.00;       params_fixed(params_index.a_xpi3,1) = 1;     
trspec(params_index.a_xpi3,:) = zeros(1,4); bounds(params_index.a_xpi3,:) = [-50.999 50.999];

rs = 17;

%% Standard deviation of shocks
params_index.sigma_x = rs+1;    params(params_index.sigma_x,1)    = 0.1;       params_fixed(params_index.sigma_x,1) = 0; 
trspec(params_index.sigma_x,:) = [2	1E-5	0 1]; bounds(params_index.sigma_x,:) = [1E-5 50.999];

params_index.sigma_pi = rs+2;  params(params_index.sigma_pi,1)  = 0.15;       params_fixed(params_index.sigma_pi,1) = 0; 
trspec(params_index.sigma_pi,:) = [2	1E-5	0 1]; bounds(params_index.sigma_pi,:) = [1E-5 50.999];

% This ratio might be fixed or not: check the exercise you wanna replicate!
% NOTE: probably useful to add a prior here
params_index.sigma_ustar = rs+3;  params(params_index.sigma_ustar,1)  = 0.12;    params_fixed(params_index.sigma_ustar,1) = 0; 
trspec(params_index.sigma_ustar,:) = [2	1E-5	0 1]; bounds(params_index.sigma_ustar,:) = [1E-5 50.999];

params_index.sigma_g = rs+4;        params(params_index.sigma_g,1)        = 0.07;  params_fixed(params_index.sigma_g,1) = 0;  
trspec(params_index.sigma_g,:) = [2	1E-5	0 1]; bounds(params_index.sigma_g,:) = [1E-5 50.999];

params_index.sigma_s = rs+5;       params(params_index.sigma_s,1)     = 0.15;       params_fixed(params_index.sigma_s,1)  = 0;  
trspec(params_index.sigma_s,:) = [2	1E-5	0 1]; bounds(params_index.sigma_s,:) = [1E-5 50.999];

params_index.sigma_f = rs+6;   params(params_index.sigma_f,1)   = 0.15;         params_fixed(params_index.sigma_f,1) = 0; 
trspec(params_index.sigma_f,:) = [2	1E-5	0 1]; bounds(params_index.sigma_f,:) = [1E-5 50.999];

params_index.sigma_chi = rs+7;        params(params_index.sigma_chi,1)   = 0.24;     params_fixed(params_index.sigma_chi,1)  = 0; 
trspec(params_index.sigma_chi,:) = [2	1E-5	0 1]; bounds(params_index.sigma_chi,:) = [1E-5 50.999];








end

