function [H,M,R] = getMeasurementEquationLaubach(~, vrbs_obs, params,params_index, ModelDim,learning,S,F)
                                         
nobs = ModelDim.nobs;
nvar = ModelDim.nvar;


%% Initialize measurement equation matrices
H = zeros(nobs,nvar);
M = zeros(nobs,1);


%% Populate measurement equation matrices

% 1. unemployment
H(vrbs_obs.u, S.vrbsL.x) = 1;
H(vrbs_obs.u, S.vrbsL.ustar) = 1;

%M(vrbs_obs.u) = 0;

% 2. inflation   
H(vrbs_obs.pi,S.vrbsL.pi) = 1;
%H(vrbs_obs.pi,S.vrbsL.oe_wage) = 1; % observation error on wage growth 


% 3. separation rate 
H(vrbs_obs.s,S.vrbsL.s) = 1;

% 4. job finding rate
H(vrbs_obs.f,S.vrbsL.f) = 1;


% 6. caput

H(vrbs_obs.chi,S.vrbsL.chi) = 1;

% 7. utrend

H(vrbs_obs.utrend,S.vrbsL.utrend) = 1;



H = H'; % Hamilton Notation

R = zeros(nobs,nobs);



