
%function [F,Sc,Q] = add_to_StateSpaceLaubach(vrbs,params,params_index,T_Z,T_epsilon,nvar,nshock,noe,shocks_oe,learning,S)
function [F,Sc,Q] = add_to_StateSpaceLaubach(vrbs,params,params_index,nvar,nshock,noe,shocks,learning,S)


F = zeros(nvar); Sc = zeros(nvar,nshock);

F(vrbs.x,vrbs.x) = params(params_index.a_x1);
F(vrbs.x,vrbs.x_L1) = params(params_index.a_x2);

F(vrbs.x_L1,vrbs.x) = 1;
F(vrbs.x_L2,vrbs.x_L1) = 1;

F(vrbs.pi,vrbs.x) = -params(params_index.a_xpi1);
F(vrbs.pi,vrbs.x_L1) = -params(params_index.a_xpi2);
F(vrbs.pi,vrbs.x_L2) = -params(params_index.a_xpi3);
F(vrbs.pi,vrbs.pi) = 1 + params(params_index.a_pi1);
F(vrbs.pi,vrbs.pi_L1) = params(params_index.a_pi2) - params(params_index.a_pi1);
F(vrbs.pi,vrbs.pi_L2) = params(params_index.a_pi3) - params(params_index.a_pi2);
F(vrbs.pi,vrbs.pi_L3) = -params(params_index.a_pi3);

F(vrbs.pi_L1,vrbs.pi) = 1;
F(vrbs.pi_L2,vrbs.pi_L1) = 1;
F(vrbs.pi_L3,vrbs.pi_L2) = 1;

F(vrbs.ustar,vrbs.ustar) = 1;
F(vrbs.ustar,vrbs.g) = 1;

F(vrbs.g,vrbs.g) = 1;

% s variable

F(vrbs.s,vrbs.s) = params(params_index.a_s3);
F(vrbs.s,vrbs.x_L1) = params(params_index.a_s1)*params(params_index.a_x2);

%Baseline
F(vrbs.s,vrbs.x) = params(params_index.a_s1)*params(params_index.a_x1) + params(params_index.a_s2);

%With trend g
% F(vrbs.s,vrbs.x) = params(params_index.a_s1)*params(params_index.a_x1);
% F(vrbs.s,vrbs.g) = params(params_index.a_s2);
% Note: in this case a_s2 is defined on the positive real line


%With trend ustar
%  F(vrbs.s,vrbs.x) = params(params_index.a_s1)*params(params_index.a_x1);
% F(vrbs.s,vrbs.ustar) = params(params_index.a_s2);
% F(vrbs.s,vrbs.g) = params(params_index.a_s2);
% Sc(vrbs.s,shocks.sig_ustar) = params(params_index.a_s2)*params(params_index.sigma_ustar);

% Note: in this case a_s2 is defined on the positive real line


% f variable

F(vrbs.f,vrbs.f) = params(params_index.a_f3);
%Baseline
F(vrbs.f,vrbs.x) = params(params_index.a_f1)*params(params_index.a_x1) + params(params_index.a_f2);
F(vrbs.f,vrbs.x_L1) = params(params_index.a_f1)*params(params_index.a_x2);

%With trend g
% F(vrbs.f,vrbs.x) = -params(params_index.a_f1)*params(params_index.a_x1);
% F(vrbs.f,vrbs.g) = params(params_index.a_f2);


% chi variable

F(vrbs.chi,vrbs.chi) = params(params_index.a_chi3);
F(vrbs.chi,vrbs.x) = params(params_index.a_chi1)*params(params_index.a_x1) + params(params_index.a_chi2);
F(vrbs.chi,vrbs.x_L1) = params(params_index.a_chi1)*params(params_index.a_x2);

% utrend

F(vrbs.utrend,vrbs.g) = 1;
F(vrbs.utrend,vrbs.utrend) = 1;



Sc(vrbs.x,shocks.sig_x) = params(params_index.sigma_x);

Sc(vrbs.pi,shocks.sig_pi) = params(params_index.sigma_pi);


%Sc(vrbs.ustar,shocks.sig_ustar) = params(params_index.sigma_ustar);
% Note: here it is interepreted as sig_pi = lpi*sig_ustar
Sc(vrbs.ustar,shocks.sig_ustar) = params(params_index.sigma_ustar)*params(params_index.sigma_pi);


%Sc(vrbs.g,shocks.sig_g) = params(params_index.sigma_g);
% Note: here it is interepreted as sig_g = lg*sig_ustar
Sc(vrbs.g,shocks.sig_g) = params(params_index.sigma_g);%*...
                          %params(params_index.sigma_ustar)*params(params_index.sigma_pi);

Sc(vrbs.s,shocks.sig_s) = params(params_index.sigma_s);
Sc(vrbs.s,shocks.sig_x) = params(params_index.a_s1)*params(params_index.sigma_x);



Sc(vrbs.f,shocks.sig_f) = params(params_index.sigma_f);
Sc(vrbs.f,shocks.sig_x) = params(params_index.a_f1)*params(params_index.sigma_x);

Sc(vrbs.chi,shocks.sig_chi) = params(params_index.sigma_chi);
Sc(vrbs.chi,shocks.sig_x) = params(params_index.a_chi1)*params(params_index.sigma_x);

Q = Sc*Sc'; 

% OLD


% % extend state space with extra lags and observation errors
% 
% F = [T_Z, zeros(size(T_Z,1),nlag + noe)
%      zeros(nlag+noe,size(T_Z,2)+nlag + noe)];
% 
% Sc = [T_epsilon, zeros(size(T_epsilon,1),noe)
%       zeros(nlag+noe,size(T_epsilon,2)+ noe)];
% 
%   
% 
% %% c_lag
% F(S.vrbsL.c_lag , S.vrbsL.c) = 1;
% 
% %% w_r_lag
% F(S.vrbsL.w_r_lag, S.vrbsL.w_r) = 1;
% 
% %% pi_lag
% F(S.vrbsL.pi_lag, S.vrbsL.pi) = 1;
% 
% %% y_lag
% F(S.vrbsL.y_lag, S.vrbsL.y) = 1;
% 
% 
% %% observation shock on wage
% 
% Sc(S.vrbsL.oe_wage,shocks_oe.wage) = params(params_index.sigma_oe_w);
% 
% %% observation shock on gov debt
% 
% Sc(S.vrbsL.oe_bm,shocks_oe.bm) = params(params_index.sigma_oe_bm);
% 
% %% observation shock on Tbill Q1exp
% 
% Sc(S.vrbsL.oe_Re,shocks_oe.Re) = params(params_index.sigma_oe_re);
% 
% %% observation shock on Tbill exp 510
% 
% Sc(S.vrbsL.oe_RLe,shocks_oe.RLe) = params(params_index.sigma_oe_rle);
% 
% %% observation shock on infl exp 510
% 
% Sc(S.vrbsL.oe_pLe,shocks_oe.pLe) = params(params_index.sigma_oe_ple);




