function [vrbs, shocks,shocks_oe,ModelDim] = defineVariablesLaubach3()
% This function outputs the following:
% vrbs: a structure containing the position of all variables (with jump
% variables ordered before state variables)
% nvar: the total number of variables (size of vrbs)
% nstate: the number of state variables

% variables
vrbs.pi      = 1;
vrbs.x       = 2; 
vrbs.x_L     = 3;
vrbs.mu      = 4;
vrbs.pistar  = 5;
vrbs.ustar   = 6; % this is u*-ubar
vrbs.utrend  = 7;
vrbs.g       = 8;

% Observation shocks
vrbs.oe_pi510Y_pi = 9;
vrbs.oe_pi12q_pi = 10;
vrbs.oe_utr = 11;


ModelDim.nvar = 11;
    
% shocks
shocks.sig_x = 1;
shocks.sig_pi = 2;
shocks.sig_pistar = 3;
shocks.sig_ustar = 4;
shocks.sig_g = 5;

% Observation shocks
shocks.oe_pi510Y_pi = 6;
shocks.oe_pi12q_pi = 7;
shocks.oe_utr = 8;

shocks_oe = NaN;
ModelDim.nshock = 8;

ModelDim.noe = 3;


end

