
function [F,Sc,Q] = add_to_StateSpaceLaubach3(vrbs,params,params_index,nvar,nshock,~,shocks,~,~)


F = zeros(nvar); Sc = zeros(nvar,nshock);

% Unemployment gap
F(vrbs.x,vrbs.x)    = params(params_index.a_x1);
F(vrbs.x,vrbs.x_L) = params(params_index.a_x2);

% persistent component expectations/supply shocks
F(vrbs.mu,vrbs.mu)    = params(params_index.rho_ze);

% Lag unemployment gap
F(vrbs.x_L,vrbs.x) = 1;

% Inflation

kappa = (1-params(params_index.beta)*params(params_index.kappa))*(1-params(params_index.kappa))/params(params_index.kappa); 

den = (1-params(params_index.beta)*(params(params_index.a_x1) + params(params_index.beta)*params(params_index.a_x2)));

omegapi1 = kappa/den;
                  
omegapi2 = (kappa*params(params_index.beta)*params(params_index.a_x2))/den;


F(vrbs.pi,vrbs.x)       = -(omegapi1*params(params_index.a_x1) + omegapi2);
% Comment if you are doing the simple Laubach
F(vrbs.pi,vrbs.x_L)    = -omegapi1*params(params_index.a_x2);

F(vrbs.pi,vrbs.pi)      = params(params_index.a_pi1);
 
F(vrbs.pi,vrbs.mu)  = params(params_index.rho_ze);
% F(vrbs.pi,vrbs.mu)  = (1/(1-params(params_index.rho_ze)*params(params_index.beta)))*params(params_index.rho_ze);


% Pistar
F(vrbs.pistar,vrbs.pistar) = 1;

% Ustar - utrend
F(vrbs.ustar,vrbs.ustar) = params(params_index.rho_u);

% Utrend
F(vrbs.utrend,vrbs.g) = 1;
F(vrbs.utrend,vrbs.utrend) = 1;

% gt
F(vrbs.g,vrbs.g) = 1;


%% Shocks

% Unemployment gap
Sc(vrbs.x,shocks.sig_x) = params(params_index.sigma_x);

% Inflation
Sc(vrbs.mu,shocks.sig_pi) = params(params_index.sigma_pi);


Sc(vrbs.pi,shocks.sig_x) = -omegapi1*params(params_index.sigma_x);

Sc(vrbs.pi,shocks.sig_pi) = params(params_index.sigma_pi);
%Sc(vrbs.pi,shocks.sig_pi) = (1/(1-params(params_index.rho_ze)*params(params_index.beta)))*params(params_index.sigma_pi);

Sc(vrbs.pi,shocks.sig_pistar) = -params(params_index.a_pi1)*params(params_index.sigma_pistar);


% Pistar
Sc(vrbs.pistar,shocks.sig_pistar) = params(params_index.sigma_pistar);


% Ustar
Sc(vrbs.ustar,shocks.sig_ustar) = params(params_index.sigma_ustar)*params(params_index.sigma_pi);
%Sc(vrbs.ustar,shocks.sig_ustar) = params(params_index.sigma_ustar)*(1/(1-params(params_index.rho_ze)*params(params_index.beta)))*params(params_index.sigma_pi);
%NOTE: here params(params_index.sigma_ustar) is the ratio of std

% gt
Sc(vrbs.g,shocks.sig_g) = params(params_index.sigma_g)*(params(params_index.sigma_ustar))*params(params_index.sigma_pi);

% Observation errors
 Sc(vrbs.oe_pi12q_pi,shocks.oe_pi12q_pi) = params(params_index.sigma_oe_pi12q_pi);
 Sc(vrbs.oe_pi510Y_pi,shocks.oe_pi510Y_pi) = params(params_index.sigma_oe_pi510Y_pi);
    % Sc(vrbs.oe_pi14q_pi,shocks.oe_pi14q_pi) =
    % params(params_index.sigma_oe_pi14q_pi); TO BE DONE

 Sc(vrbs.oe_utr,shocks.oe_utr) = params(params_index.sigma_oe_utr); 
 
 
 
Q = Sc*Sc'; 

%keyboard
% end

%% OLD TRICKS
% Note: here it is interepreted as sig_pi = lpi*sig_ustar
%Sc(vrbs.ustar,shocks.sig_ustar) = params(params_index.sigma_ustar)*params(params_index.sigma_pi);


% Note: here it is interepreted as sig_g = lg*sig_ustar
% Sc(vrbs.g,shocks.sig_g) = params(params_index.sigma_g)*...
%                           params(params_index.sigma_ustar)*params(params_index.sigma_pi);





