function [params, params_index, params_fixed,trspec,bounds] = setParamsLaubach2(learning)

% This function outputs the params structure, which contains initialized values 
% of the model paramseters as well as derived steady-state values.

params_index.a_x1 = 1;      params(params_index.a_x1,1)       = 1.6;    params_fixed(params_index.a_x1,1) = 0;    
trspec(params_index.a_x1,:) = [2	1E-5	0	1]; bounds(params_index.a_x1,:) = [1E-5 50.999];

params_index.a_x2 = 2;      params(params_index.a_x2,1)       = -0.8;    params_fixed(params_index.a_x2,1) = 0;   
trspec(params_index.a_x2,:) = zeros(1,4); bounds(params_index.a_x2,:) = [-50.999 50.999];


params_index.beta = 3;      params(params_index.beta,1)     = 0.99;       params_fixed(params_index.beta,1) = 1;    
trspec(params_index.beta,:) = [1	1E-5	.99	1];  bounds(params_index.beta,:) = [1E-5 0.999];

params_index.kappa = 4;      params(params_index.kappa,1)     = 0.8;       params_fixed(params_index.kappa,1) = 0;   
trspec(params_index.kappa,:) = [2	1E-5	0	1]; bounds(params_index.kappa,:) = [1E-5 50.999];


params_index.a_pi1 = 5;     params(params_index.a_pi1,1)      = 0.5;       params_fixed(params_index.a_pi1,1) = 0;      
trspec(params_index.a_pi1,:) = [1	1E-5	.99	1]; bounds(params_index.a_pi1,:) = [1E-5 0.989];

params_index.a_pi2 = 6;    params(params_index.a_pi2,1)      = 0.0;       params_fixed(params_index.a_pi2,1) = 1; 
trspec(params_index.a_pi2,:) = zeros(1,4); bounds(params_index.a_pi2,:) = [-50.999 50.999];

params_index.a_pi3 = 7;    params(params_index.a_pi3,1)      = 0.0;       params_fixed(params_index.a_pi3,1) = 1;      
trspec(params_index.a_pi3,:) = zeros(1,4); bounds(params_index.a_pi3,:) = [-50.999 50.999];

params_index.a_pi4 = 8;    params(params_index.a_pi4,1)      = 0.0;       params_fixed(params_index.a_pi4,1) = 1;      
trspec(params_index.a_pi4,:) = zeros(1,4); bounds(params_index.a_pi4,:) = [-50.999 50.999];

% NOT used
params_index.a_xpi1 = 9;    params(params_index.a_xpi1,1)      = 0.0;       params_fixed(params_index.a_xpi1,1) = 1;     
trspec(params_index.a_xpi1,:) = [2	1E-5	0	1]; bounds(params_index.a_xpi1,:) = [1E-5 50.999];

params_index.a_xpi2 = 10;    params(params_index.a_xpi2,1)      = 0.0;       params_fixed(params_index.a_xpi2,1) = 1;     
trspec(params_index.a_xpi2,:) = zeros(1,4); bounds(params_index.a_xpi2,:) = [-50.999 50.999];
%

params_index.a_chiAA = 11;      params(params_index.a_chiAA,1)     = 0.8;       params_fixed(params_index.a_chiAA,1) = 0;  
trspec(params_index.a_chiAA,:) = [1	1E-5	.99	1]; bounds(params_index.a_chiAA,:) = [1E-5 0.989];

params_index.a_chiAB = 12;      params(params_index.a_chiAB,1)     = 0.0;       params_fixed(params_index.a_chiAB,1) = 1;  
trspec(params_index.a_chiAB,:) = zeros(1,4);    bounds(params_index.a_chiAB,:) = [-50.999 50.999];


params_index.a_chiA1 = 13;      params(params_index.a_chiA1,1)     = 0.2;       params_fixed(params_index.a_chiA1,1) = 0;  
trspec(params_index.a_chiA1,:) = [2	1E-5	0	1]; bounds(params_index.a_chiA1,:) = [1E-5 50.999];

params_index.a_chiA2 = 14;      params(params_index.a_chiA2,1)     = 0.0;       params_fixed(params_index.a_chiA2,1) = 1;  
trspec(params_index.a_chiA2,:) = zeros(1,4);        bounds(params_index.a_chiA2,:) = [-50.999 50.999];


params_index.a_chiBB = 15;      params(params_index.a_chiBB,1)     = 0.5;       params_fixed(params_index.a_chiBB,1) = 0;  
trspec(params_index.a_chiBB,:) = [1	1E-5	.99	1]; bounds(params_index.a_chiBB,:) = [1E-5 0.989];

params_index.a_chiBA = 16;      params(params_index.a_chiBA,1)     = 0.0;       params_fixed(params_index.a_chiBA,1) = 1;  
trspec(params_index.a_chiBA,:) = zeros(1,4);    bounds(params_index.a_chiBA,:) = [-50.999 50.999];


params_index.a_chiB1 = 17;      params(params_index.a_chiB1,1)     = 0.5;       params_fixed(params_index.a_chiB1,1) = 0;  
trspec(params_index.a_chiB1,:) = [2	1E-5	0	1]; bounds(params_index.a_chiB1,:) = [1E-5 50.999];

params_index.a_chiB2 = 18;      params(params_index.a_chiB2,1)     = 0.0;       params_fixed(params_index.a_chiB2,1) = 1;  
trspec(params_index.a_chiB2,:) = zeros(1,4);        bounds(params_index.a_chiB2,:) = [-50.999 50.999];

params_index.a_chicB = 19;      params(params_index.a_chicB,1)     = 0.0;       params_fixed(params_index.a_chicB,1) = 1;  
trspec(params_index.a_chicB,:) = zeros(1,4);        bounds(params_index.a_chicB,:) = [-50.999 50.999];

params_index.rho_u = 20;      params(params_index.rho_u,1)     = 0.99;       params_fixed(params_index.rho_u,1) = 1;  
trspec(params_index.rho_u,:) = [1	1E-5	.99	1]; bounds(params_index.rho_u,:) = [1E-5 0.989];

params_index.rho_ze = 21;      params(params_index.rho_ze,1)     = 0.5;       params_fixed(params_index.rho_ze,1) = 0;  
trspec(params_index.rho_ze,:) = [1	1E-5	.99	1]; bounds(params_index.rho_ze,:) = [1E-5 0.989];

params_index.Gam = 22;      params(params_index.Gam,1)     = 1;       params_fixed(params_index.Gam,1) = 1;  
trspec(params_index.Gam,:) = zeros(1,4);  bounds(params_index.Gam,:) = [-50.999 50.999];

params_index.theta_usi = 23;      params(params_index.theta_usi,1)     = 1;       params_fixed(params_index.theta_usi,1) = 1;  
trspec(params_index.theta_usi,:) = zeros(1,4);  bounds(params_index.theta_usi,:) = [-50.999 50.999];

params_index.theta_uso = 24;      params(params_index.theta_uso,1)     = 1;       params_fixed(params_index.theta_uso,1) = 1;  
trspec(params_index.theta_uso,:) = zeros(1,4);  bounds(params_index.theta_uso,:) = [-50.999 50.999];

params_index.theta_ridx = 25;      params(params_index.theta_ridx,1)     = 1;       params_fixed(params_index.theta_ridx,1) = 1;  
trspec(params_index.theta_ridx,:) = zeros(1,4);  bounds(params_index.theta_ridx,:) = [-50.999 50.999];

params_index.theta_eeb = 26;      params(params_index.theta_eeb,1)     = 1;       params_fixed(params_index.theta_eeb,1) = 1;  
trspec(params_index.theta_eeb,:) = zeros(1,4);  bounds(params_index.theta_eeb,:) = [-50.999 50.999];

%% intercept in measurement equation
params_index.theta0_usi = 27;      params(params_index.theta0_usi,1)     = -4;       params_fixed(params_index.theta0_usi,1) = 1;
trspec(params_index.theta0_usi,:) = zeros(1,4);  bounds(params_index.theta0_usi,:) = [-50.999 50.999];

params_index.theta0_uso = 28;      params(params_index.theta0_uso,1)     = -4;       params_fixed(params_index.theta0_uso,1) = 1;  
trspec(params_index.theta0_uso,:) = zeros(1,4);  bounds(params_index.theta0_uso,:) = [-50.999 50.999];

params_index.theta0_ridx = 29;      params(params_index.theta0_ridx,1)     = -4;       params_fixed(params_index.theta0_ridx,1) = 1;  
trspec(params_index.theta0_ridx,:) = zeros(1,4); bounds(params_index.theta0_ridx,:) = [-50.999 50.999];

params_index.theta0_eeb = 30;      params(params_index.theta0_eeb,1)     = -4;       params_fixed(params_index.theta0_eeb,1) = 1;  
trspec(params_index.theta0_eeb,:) = zeros(1,4);  bounds(params_index.theta0_eeb,:) = [-50.999 50.999];
%% autocorr coeff in noise

params_index.rho_theta_usi = 31;      params(params_index.rho_theta_usi,1)     = 0.9;       params_fixed(params_index.rho_theta_usi,1) = 1;  
trspec(params_index.rho_theta_usi,:) = [1	1E-5	.99	1]; bounds(params_index.rho_theta_usi,:) = [1E-5 0.989];

params_index.rho_theta_uso = 32;      params(params_index.rho_theta_uso,1)     = 0.9;       params_fixed(params_index.rho_theta_uso,1) = 1;  
trspec(params_index.rho_theta_uso,:) = [1	1E-5	.99	1]; bounds(params_index.rho_theta_uso,:) = [1E-5 0.989];

params_index.rho_theta_ridx = 33;      params(params_index.rho_theta_ridx,1)     = 0.9;       params_fixed(params_index.rho_theta_ridx,1) = 1;  
trspec(params_index.rho_theta_ridx,:) = [1	1E-5	.99	1]; bounds(params_index.rho_theta_ridx,:) = [1E-5 0.989];

params_index.rho_theta_eeb = 34;      params(params_index.rho_theta_eeb,1)     = 0.9;       params_fixed(params_index.rho_theta_eeb,1) = 1;  
trspec(params_index.rho_theta_eeb,:) = [1	1E-5	.99	1]; bounds(params_index.rho_theta_eeb,:) = [1E-5 0.989];



%%
rs = 34;

%% Standard deviation of shocks
params_index.sigma_x = rs+1;    params(params_index.sigma_x,1)    = 0.1;       params_fixed(params_index.sigma_x,1) = 0; 
trspec(params_index.sigma_x,:) = [2	1E-5	0 1]; bounds(params_index.sigma_x,:) = [1E-5 50.999];

params_index.sigma_nu = rs+2;    params(params_index.sigma_nu,1)    = 0.0;       params_fixed(params_index.sigma_nu,1) = 1; 
trspec(params_index.sigma_nu,:) = [2	1E-5	0 1]; bounds(params_index.sigma_nu,:) = [1E-5 50.999];


params_index.sigma_pi = rs+3;  params(params_index.sigma_pi,1)  = 0.15;       params_fixed(params_index.sigma_pi,1) = 0; 
trspec(params_index.sigma_pi,:) = [2	1E-5	0 1]; bounds(params_index.sigma_pi,:) = [1E-5 50.999];

params_index.sigma_pistar = rs+4;  params(params_index.sigma_pistar,1)  = 0.15;       params_fixed(params_index.sigma_pistar,1) = 0; 
trspec(params_index.sigma_pistar,:) = [2	1E-5	0 1]; bounds(params_index.sigma_pistar,:) = [1E-5 50.999];

params_index.sigma_chiA = rs+5;  params(params_index.sigma_chiA,1)  = 0.15;       params_fixed(params_index.sigma_chiA,1) = 0; 
trspec(params_index.sigma_chiA,:) = [2	1E-5	0 1]; bounds(params_index.sigma_chiA,:) = [1E-5 50.999];

params_index.sigma_chiB = rs+6;  params(params_index.sigma_chiB,1)  = 0.15;       params_fixed(params_index.sigma_chiB,1) = 0; 
trspec(params_index.sigma_chiB,:) = [2	1E-5	0 1]; bounds(params_index.sigma_chiB,:) = [1E-5 50.999];

params_index.sigma_ustar = rs+7;  params(params_index.sigma_ustar,1)  = 0.12;    params_fixed(params_index.sigma_ustar,1) = 0; 
trspec(params_index.sigma_ustar,:) = [2	1E-5	0 1]; bounds(params_index.sigma_ustar,:) = [1E-5 50.999];

params_index.sigma_g = rs+8;        params(params_index.sigma_g,1)        = 0.07;  params_fixed(params_index.sigma_g,1) = 0;  
trspec(params_index.sigma_g,:) = [2	1E-5	0 1]; bounds(params_index.sigma_g,:) = [1E-5 50.999];

params_index.sigma_ze = rs+9;        params(params_index.sigma_ze,1)        = 0.2;  params_fixed(params_index.sigma_ze,1) = 1;  
trspec(params_index.sigma_ze,:) = [2	1E-5	0 1]; bounds(params_index.sigma_ze,:) = [1E-5 50.999];

params_index.sigma_oe_pi1q_pi = rs+10;     params(params_index.sigma_oe_pi1q_pi,1)     = 0.0;   params_fixed(params_index.sigma_oe_pi1q_pi,1)  = 1;  
trspec(params_index.sigma_oe_pi1q_pi,:) = [2	1E-5	0 1]; bounds(params_index.sigma_oe_pi1q_pi,:) = [1E-5 50.999];

params_index.sigma_oe_pi14q_pi = rs+11;   params(params_index.sigma_oe_pi14q_pi,1)   = 0.15;   params_fixed(params_index.sigma_oe_pi14q_pi,1) = 1; 
trspec(params_index.sigma_oe_pi14q_pi,:) = [2	1E-5	0 1]; bounds(params_index.sigma_oe_pi14q_pi,:) = [1E-5 50.999];

params_index.sigma_oe_pi510Y_pi = rs+12;  params(params_index.sigma_oe_pi510Y_pi,1)   = 0.05;   params_fixed(params_index.sigma_oe_pi510Y_pi,1)  = 0; 
trspec(params_index.sigma_oe_pi510Y_pi,:) = [2	1E-5	0 1]; bounds(params_index.sigma_oe_pi510Y_pi,:) = [1E-5 50.999];

params_index.sigma_oe_pi14q_u = rs+13;  params(params_index.sigma_oe_pi14q_u,1)   = 0.04;   params_fixed(params_index.sigma_oe_pi14q_u,1)  = 1; 
trspec(params_index.sigma_oe_pi14q_u,:) = [2	1E-5	0 1]; bounds(params_index.sigma_oe_pi14q_u,:) = [1E-5 50.999];

params_index.sigma_oe_pi0 = rs + 14;   params(params_index.sigma_oe_pi0,1) = 0.0;  params_fixed(params_index.sigma_oe_pi0,1)  = 1; 
trspec(params_index.sigma_oe_pi0,:) = [2	1E-5	0 1]; bounds(params_index.sigma_oe_pi0,:) = [1E-5 50.999];

params_index.sigma_oe_pi12q_pi = rs+15;     params(params_index.sigma_oe_pi12q_pi,1)     = 0.15;   params_fixed(params_index.sigma_oe_pi12q_pi,1)  = 0;  
trspec(params_index.sigma_oe_pi12q_pi,:) = [2	1E-5	0 1]; bounds(params_index.sigma_oe_pi12q_pi,:) = [1E-5 50.999];

params_index.sigma_oe_usi = rs + 16;   params(params_index.sigma_oe_usi,1) = 0.1;  params_fixed(params_index.sigma_oe_usi,1)  = 1; 
trspec(params_index.sigma_oe_usi,:) = [2	1E-5	0 1]; bounds(params_index.sigma_oe_usi,:) = [1E-5 50.999];

params_index.sigma_oe_uso = rs + 17;   params(params_index.sigma_oe_uso,1) = 0.1;  params_fixed(params_index.sigma_oe_uso,1)  = 1; 
trspec(params_index.sigma_oe_uso,:) = [2	1E-5	0 1]; bounds(params_index.sigma_oe_uso,:) = [1E-5 50.999];

params_index.sigma_oe_ridx = rs + 18;   params(params_index.sigma_oe_ridx,1) = 0.1;  params_fixed(params_index.sigma_oe_ridx,1)  = 1; 
trspec(params_index.sigma_oe_ridx,:) = [2	1E-5	0 1]; bounds(params_index.sigma_oe_ridx,:) = [1E-5 50.999];

params_index.sigma_oe_eeb = rs + 19;   params(params_index.sigma_oe_eeb,1) = 0.1;  params_fixed(params_index.sigma_oe_eeb,1)  = 1; 
trspec(params_index.sigma_oe_eeb,:) = [2	1E-5	0 1]; bounds(params_index.sigma_oe_eeb,:) = [1E-5 50.999];

params_index.sigma_oe_utr = rs + 20;   params(params_index.sigma_oe_utr,1) = 0.15;  params_fixed(params_index.sigma_oe_utr,1)  = 1; 
trspec(params_index.sigma_oe_utr,:) = [2	1E-5	0 1]; bounds(params_index.sigma_oe_utr,:) = [1E-5 50.999];


end

