function [H,M,R] = getMeasurementEquationLaubach2(~, vrbs_obs, params,params_index, ModelDim,learning,S,F)
                                         
nobs = ModelDim.nobs;
nvar = ModelDim.nvar;

% Inflation and unemployment expectations

ftil_select = [S.vrbsL.x,S.vrbsL.z,S.vrbsL.z_L1,S.vrbsL.pi,S.vrbsL.pi_L1,S.vrbsL.pi_L2,S.vrbsL.pi_L3,S.vrbsL.pistar];
fum_select = [S.vrbsL.x,S.vrbsL.z,S.vrbsL.z_L1,S.vrbsL.ustar,S.vrbsL.utrend,S.vrbsL.g];
F_til = F(ftil_select,ftil_select);
%F_um = F(fum_select,fum_select);

F_til2 = (1/2)*(F_til + F_til^2);
F_til4 = F_til^4;%F_til2;%(1/4)*(F_til + F_til^2 + F_til^3 + F_til^4);
%F_um4 = (1/4)*(F_um + F_um^2 + F_um^3 + F_um^4);

eyep = eye(size(F_til));

F_til510 = zeros(size(F_til));
F_til110 = zeros(size(F_til));
rhotil510 = 0;
for js = 1:20
F_til110 = F_til110 + F_til^js;    
end    
for jj = 21:40    
F_til510 = F_til510 + F_til^jj;
F_til110 = F_til110 + F_til^jj;
rhotil510 = rhotil510 + params(params_index.rho_ze)^jj;
end


 F_til510 = (1/20)*F_til510;
 F_til110 = (1/40)*F_til110;

%= (1/20)*((eyep-F_til)\(eyep - F_til^(40-20)))*F_til^20; % only for
%stationary
%keyboard

%% Initialize measurement equation matrices
H = zeros(nobs,nvar);
M = zeros(nobs,1);


%% Populate measurement equation matrices

% 1. unemployment
H(vrbs_obs.u, S.vrbsL.x) = 1;
H(vrbs_obs.u, S.vrbsL.ustar) = 1;

% 2. inflation  core 
H(vrbs_obs.pi,S.vrbsL.pi) = 1;
H(vrbs_obs.pi,S.vrbsL.oe_pi0) = 1; % observation errors 

% 3. inflation
H(vrbs_obs.pi2,S.vrbsL.pi) = params(params_index.Gam);
H(vrbs_obs.pi2,S.vrbsL.oe_pi1q_pi) = 1; % observation errors 


% 4. caput (chiA)
H(vrbs_obs.chiA,S.vrbsL.chiA) = 1;

% 5. ISM (chiB)
H(vrbs_obs.chiB,S.vrbsL.chiB) = 1;


% 6. utrend
H(vrbs_obs.utrend,S.vrbsL.utrend) = 1;
H(vrbs_obs.utrend,S.vrbsL.oe_utr) = 1;


%% Forecasts

% 7. one-step-ahead inflation expectations 
H(vrbs_obs.exp1q_pi,ftil_select) = F_til(4,:);
%H(vrbs_obs.exp1q_pi,S.vrbsL.oe_pi1q_pi) = 1; % observation errors XX used
%somewhere else!!!
H(vrbs_obs.exp1q_pi,S.vrbsL.ze) = params(params_index.rho_ze); % ze

% 8. two-quarters-ahead inflation expectations 
H(vrbs_obs.exp12q_pi,ftil_select) = F_til2(4,:);
H(vrbs_obs.exp12q_pi,S.vrbsL.oe_pi12q_pi) = 1;
H(vrbs_obs.exp12q_pi,S.vrbsL.ze) = (params(params_index.rho_ze)+params(params_index.rho_ze)^2)/2;

% 9. four-  quarters-ahead inflation expectations
H(vrbs_obs.exp14q_pi,ftil_select) = F_til4(4,:);
H(vrbs_obs.exp14q_pi,S.vrbsL.oe_pi14q_pi) = 1;
H(vrbs_obs.exp14q_pi,S.vrbsL.ze) = params(params_index.rho_ze)^4;

% 10. 5-10 years ahead inflation expectations
H(vrbs_obs.exp510y_pi,ftil_select) = F_til510(4,:);
H(vrbs_obs.exp510y_pi,S.vrbsL.oe_pi510Y_pi) = 1;
H(vrbs_obs.exp510y_pi,S.vrbsL.ze) = rhotil510/20;

% 11. 1-10 years ahead inflation expectations (not used)
H(vrbs_obs.exp110y_pi,ftil_select) = F_til110(4,:);
H(vrbs_obs.exp110y_pi,S.vrbsL.oe_pi14q_u) = 1; %borrowing for the following eq...

% 12. u* mismatch (industry)

H(vrbs_obs.ustr_ind,S.vrbsL.ustar) = params(params_index.theta_usi);
%H(vrbs_obs.ustr_ind,S.vrbsL.utrend) = - params(params_index.theta_usi);
H(vrbs_obs.ustr_ind,S.vrbsL.oe_usi) = 1;
M(vrbs_obs.ustr_ind) = params(params_index.theta0_usi);

% 13. u* mismatch (occupation)

H(vrbs_obs.ustr_occ,S.vrbsL.ustar) = params(params_index.theta_uso);
%H(vrbs_obs.ustr_occ,S.vrbsL.utrend) = - params(params_index.theta_uso);
H(vrbs_obs.ustr_occ,S.vrbsL.oe_uso) = 1;
M(vrbs_obs.ustr_occ) = params(params_index.theta0_uso);

% 14. gap RI signal

H(vrbs_obs.ri_index,S.vrbsL.ustar) = params(params_index.theta_ridx);
%H(vrbs_obs.ri_index,S.vrbsL.utrend) = - params(params_index.theta_ridx);
H(vrbs_obs.ri_index,S.vrbsL.oe_ridx) = 1;
M(vrbs_obs.ri_index) = params(params_index.theta0_ridx);

% 15. u* ext benefits
H(vrbs_obs.ustr_eeb,S.vrbsL.ustar) = params(params_index.theta_eeb);
%H(vrbs_obs.ustr_eeb,S.vrbsL.utrend) = - params(params_index.theta_eeb);
H(vrbs_obs.ustr_eeb,S.vrbsL.oe_eeb) = 1;
M(vrbs_obs.ustr_eeb) = params(params_index.theta0_eeb);

% % 10. one-year-ahead unemployment expectations
% H(vrbs_obs.exp14q_u,fum_select) = F_um4(1,:) + F_um4(4,:);
% %H(vrbs_obs.exp14q_u,S.vrbsL.oe_pi14q_u) = 1;


H = H'; % Hamilton Notation

R = zeros(nobs,nobs);


