

function [Y_main,Y_main_all,vrbs_obs,nobs,trainingSampleLength,Y_pre,startSample,endSample] = getDataLaubach2(trend)


%% Loads and prepared data

% get indices for observables
[vrbs_obs,nobs] = defineObservables();


load DataMat_LaubachFeb2018 utrend
load Joint_estimationlptauf ubar
load EXtra2 lrm

ubar_mean = mean(100*ubar,2);
ubar_mean = [NaN(length(1948:1/4:1975.75),1);ubar_mean];

load CEGSData_mat_6 Y1
% current sample 
%full_sample = 1954.75:1/4:2017.75;
full_sample = 1948:1/4:2018.5;

Y_main_all = NaN(nobs,length(full_sample));

Y_main_all(vrbs_obs.u,:) = Y1(:,1);

Y_main_all(vrbs_obs.pi,:) = Y1(:,3);

Y_main_all(vrbs_obs.chiA,:) = Y1(:,4);

Y_main_all(vrbs_obs.chiB,:) = Y1(:,5);
 
% Y_main_all(vrbs_obs.exp1q_pi,:) = Y1(:,5); %NOT USED
 
%Y_main_all(vrbs_obs.exp12q_pi,:) =  Y1(:,6);
Y_main_all(vrbs_obs.exp12q_pi,:) =  nanmean([Y1(:,7) Y1(:,8)],2);

%Y_main_all(vrbs_obs.exp14q_pi,:) =  Y1(:,7); % four-quarters ahead (I changed it)

Y_main_all(vrbs_obs.exp510y_pi,:) =  nanmean([Y1(:,9) lrm],2);

%Y_main_all(vrbs_obs.exp110y_pi,:) =  Y1(:,10);

% Y_main_all(vrbs_obs.utrend,:) = [NaN(length(1948:1/4:1954.5),1)',utrend,NaN(3,1)'];
Y_main_all(vrbs_obs.utrend,:) = ubar_mean;
 
%Y_main_all(vrbs_obs.pi2,:) = Y1(:,2); 

ust_select_start = 2005;
ust_select_end = 2012.75;

sel_sampl = find(full_sample >= ust_select_start & full_sample <= ust_select_end);

% Y_main_all(vrbs_obs.ustr_occ,sel_sampl) = Y1(sel_sampl,11);
% 
% Y_main_all(vrbs_obs.ustr_ind,sel_sampl) = Y1(sel_sampl,12);
% 
% Y_main_all(vrbs_obs.ri_index,sel_sampl) = Y1(sel_sampl,13); 
% 
% Y_main_all(vrbs_obs.ustr_eeb,sel_sampl) = Y1(sel_sampl,14); 


 

% Old
% Y_main_all(vrbs_obs.u,:) = Unemployment;
% 
% Y_main_all(vrbs_obs.pi,:) = CPIinflation;
% 
% Y_main_all(vrbs_obs.chiA,:) = caput_detrend;
% 
%  Y_main_all(vrbs_obs.chiB,:) = ISMmfg;
%  
%  Y_main_all(vrbs_obs.exp1q_pi,:) = CPI1Q;
%  
%  Y_main_all(vrbs_obs.exp12q_pi,:) =  CPI12Q;
% 
% %Y_main_all(vrbs_obs.exp14q_pi,:) =  CPI14Q;
% 
% Y_main_all(vrbs_obs.exp510y_pi,:) =  CPI510Y;
% 
% Y_main_all(vrbs_obs.utrend,:) = utrend;


% Select variables to be used in estimation      
Y_main = Y_main_all;
  
 
% Restrict Sample
startSample = 1960; %1980; 
endSample = 2018.5; 
 
sampos = find(full_sample >= startSample & full_sample <= endSample);
 
trainingSampleLength = 4;

Y_pre = 0;
 
Y_main = Y_main(:,sampos)';
 
Y_main_all = Y_main_all(:,sampos)';
 
 %% OLD
 
% %% Tranform data
% 
% % Choose which version of unemployment trend: NaN, ytrendl,utrendm
% if trend == 2
% % add trend in u
% Y_main_all = [Y_main_all utrendl];
% % detrend f
% Y_main_all(:,vrbs_obs.f) = -(Y_main_all(:,vrbs_obs.f) - sfll);
% 
% else
% Y_main_all = [Y_main_all utrendm];
% Y_main_all(:,vrbs_obs.f) = -(Y_main_all(:,vrbs_obs.f) - sfm);
% end
% %Y_main_all(:,6) = NaN;
% 
% % rescale separations
% Y_main_all(:,vrbs_obs.s) = 100*Y_main_all(:,vrbs_obs.s);
% 
% % detrend s
% Y_main_all(:,vrbs_obs.s) = Y_main_all(:,vrbs_obs.s) - 100*sh;
% 
% % detrend caput
% [schi,~] = hpfilter(Y_main_all(:,vrbs_obs.chi),5000000);
% Y_main_all(:,vrbs_obs.chi) = -(Y_main_all(:,vrbs_obs.chi) - schi);

 
 
      
