function [vrbs, shocks,shocks_oe,ModelDim] = defineVariablesLaubach2()
% This function outputs the following:
% vrbs: a structure containing the position of all variables (with jump
% variables ordered before state variables)
% nvar: the total number of variables (size of vrbs)
% nstate: the number of state variables

% variables
vrbs.x       = 1;
vrbs.z       = 2;
vrbs.z_L1    = 3; 
vrbs.pi      = 4;
vrbs.pi_L1    = 5;
vrbs.pi_L2    = 6;
vrbs.pi_L3    = 7;
vrbs.chiA     = 8;
vrbs.chiB     = 9;
vrbs.pistar  = 10;
vrbs.ustar   = 11;
vrbs.utrend  = 12;
vrbs.g       = 13;
vrbs.sig_ustar = 14;
vrbs.ze      = 15;

% Observation shocks
vrbs.oe_pi1q_pi = 16;
vrbs.oe_pi14q_pi = 17;
vrbs.oe_pi510Y_pi = 18;
vrbs.oe_pi14q_u = 19;
vrbs.oe_pi0 = 20;
vrbs.oe_pi12q_pi = 21;
vrbs.oe_usi = 22; 
vrbs.oe_uso = 23;
vrbs.oe_ridx = 24;
vrbs.oe_eeb = 25;
vrbs.oe_utr = 26;


ModelDim.nvar = 26;
    
% shocks
shocks.sig_x = 1;
shocks.sig_nu = 2;
shocks.sig_pi = 3;
shocks.sig_chiA = 4;
shocks.sig_chiB = 5;
shocks.sig_pistar = 6;
shocks.sig_ustar = 7;
shocks.sig_g = 8;
shocks.sig_ze = 9;

% Observation shocks
shocks.oe_pi1q_pi = 10;
shocks.oe_pi14q_pi = 11;
shocks.oe_pi510Y_pi = 12;
shocks.oe_pi14q_u = 13;
shocks.oe_pi0 = 14;
shocks.oe_pi12q_pi = 15;
shocks.oe_usi = 16;
shocks.oe_uso = 17;
shocks.oe_ridx = 18;
shocks.oe_eeb = 19;
shocks.oe_utr = 20;

shocks_oe = NaN;
ModelDim.nshock = 20;

ModelDim.noe = 11;


end

