
%function [F,Sc,Q] = add_to_StateSpaceLaubach(vrbs,params,params_index,T_Z,T_epsilon,nvar,nshock,noe,shocks_oe,learning,S)
function [F,Sc,Q] = add_to_StateSpaceLaubach2(vrbs,params,params_index,nvar,nshock,noe,shocks,learning,S)


F = zeros(nvar); Sc = zeros(nvar,nshock);

% Unemployment gap
F(vrbs.x,vrbs.z)    = params(params_index.a_x1);
F(vrbs.x,vrbs.z_L1) = params(params_index.a_x2);

% Persistent component of gap
F(vrbs.z,vrbs.z)    = params(params_index.a_x1);
F(vrbs.z,vrbs.z_L1) = params(params_index.a_x2);

% persistent component expectations/supply shocks
F(vrbs.ze,vrbs.ze)    = params(params_index.rho_ze);

% Lag unemployment gap
F(vrbs.z_L1,vrbs.z) = 1;

% Inflation

kappa = (1-params(params_index.beta)*params(params_index.kappa))*(1-params(params_index.kappa))/params(params_index.kappa); 

den = (1-params(params_index.beta)*(params(params_index.a_x1) + params(params_index.beta)*params(params_index.a_x2)));

omegapi1 = kappa/den;
                  
omegapi2 = (kappa*params(params_index.beta)*params(params_index.a_x2))/den;


%kappa_ze = ((1-params(params_index.kappa))*params(params_index.beta)/(1-params(params_index.beta)*params(params_index.kappa)*params(params_index.rho_ze)))*params(params_index.rho_ze);


F(vrbs.pi,vrbs.z)       = -(omegapi1*params(params_index.a_x1) + omegapi2);
% Comment if you are doing the simple Laubach
F(vrbs.pi,vrbs.z_L1)    = -omegapi1*params(params_index.a_x2);

% F(vrbs.pi,vrbs.z)       = -kappa*params(params_index.a_x1);
% F(vrbs.pi,vrbs.z_L1)    = -kappa*params(params_index.a_x2);

F(vrbs.pi,vrbs.pi)      = params(params_index.a_pi1);
F(vrbs.pi,vrbs.pi_L1)   = params(params_index.a_pi2);
F(vrbs.pi,vrbs.pi_L2)   = params(params_index.a_pi3);
F(vrbs.pi,vrbs.pi_L3)   = params(params_index.a_pi4);

oneminus = 1 - (params(params_index.a_pi1) + params(params_index.a_pi2)+...
                params(params_index.a_pi3) + params(params_index.a_pi4));
                           
F(vrbs.pi,vrbs.pistar)  = oneminus;

F(vrbs.pi,vrbs.ze)  = params(params_index.rho_ze);



% Lagged inflation
F(vrbs.pi_L1,vrbs.pi)    = 1;
F(vrbs.pi_L2,vrbs.pi_L1) = 1;
F(vrbs.pi_L3,vrbs.pi_L2) = 1;

% ChiA
F(vrbs.chiA,vrbs.chiA) = params(params_index.a_chiAA);
F(vrbs.chiA,vrbs.chiB) = params(params_index.a_chiAB);

F(vrbs.chiA,vrbs.x) = params(params_index.a_chiA2);
F(vrbs.chiA,vrbs.z) = -params(params_index.a_chiA1)*params(params_index.a_x1);
F(vrbs.chiA,vrbs.z_L1) = -params(params_index.a_chiA1)*params(params_index.a_x2);

% ChiB
F(vrbs.chiB,vrbs.chiB) = params(params_index.a_chiBB);
F(vrbs.chiB,vrbs.chiA) = params(params_index.a_chiBA);

F(vrbs.chiB,vrbs.x) = params(params_index.a_chiB2);
F(vrbs.chiB,vrbs.z) = -params(params_index.a_chiB1)*params(params_index.a_x1);
F(vrbs.chiB,vrbs.z_L1) = -params(params_index.a_chiB1)*params(params_index.a_x2);

% Pistar
F(vrbs.pistar,vrbs.pistar) = 1;

% Ustar
F(vrbs.ustar,vrbs.ustar) = params(params_index.rho_u);
F(vrbs.ustar,vrbs.utrend) = 1 - params(params_index.rho_u);
F(vrbs.ustar,vrbs.g) = 1;

% Utrend
F(vrbs.utrend,vrbs.g) = 1;
F(vrbs.utrend,vrbs.utrend) = 1;

% gt

F(vrbs.g,vrbs.g) = 1;


%% Shocks

% Unemployment gap
Sc(vrbs.x,shocks.sig_x) = params(params_index.sigma_x);
Sc(vrbs.x,shocks.sig_nu) = params(params_index.sigma_nu);

% Persistent component of the gap
Sc(vrbs.z,shocks.sig_x) = params(params_index.sigma_x);
Sc(vrbs.ze,shocks.sig_pi) = params(params_index.sigma_pi);

% Inflation

Sc(vrbs.pi,shocks.sig_x) = -omegapi1*params(params_index.sigma_x);
%Sc(vrbs.pi,shocks.sig_x) = -kappa*params(params_index.sigma_x);

Sc(vrbs.pi,shocks.sig_nu) = -kappa*params(params_index.sigma_nu);

Sc(vrbs.pi,shocks.sig_pi) = params(params_index.sigma_pi);

Sc(vrbs.pi,shocks.sig_pistar) = oneminus*params(params_index.sigma_pistar);

%Sc(vrbs.pi,shocks.sig_ze) = params(params_index.sigma_ze);


% ChiA
Sc(vrbs.chiA,shocks.sig_chiA) = params(params_index.sigma_chiA);
Sc(vrbs.chiA,shocks.sig_x) = -params(params_index.a_chiA1)*params(params_index.sigma_x);
Sc(vrbs.chiA,shocks.sig_nu) = -params(params_index.a_chiA1)*params(params_index.sigma_nu);


% ChiB
Sc(vrbs.chiB,shocks.sig_chiB) = params(params_index.sigma_chiB);
Sc(vrbs.chiB,shocks.sig_x) = -params(params_index.a_chiB1)*params(params_index.sigma_x);
Sc(vrbs.chiB,shocks.sig_nu) = -params(params_index.a_chiB1)*params(params_index.sigma_nu);
Sc(vrbs.chiB,shocks.sig_chiA) = params(params_index.a_chicB)*params(params_index.sigma_chiA);


% Pistar
Sc(vrbs.pistar,shocks.sig_pistar) = params(params_index.sigma_pistar);


% Ustar
Sc(vrbs.ustar,shocks.sig_ustar) = (params(params_index.sigma_ustar))*params(params_index.sigma_pi);
%NOTE: here params(params_index.sigma_ustar) is the ratio of std

%Sc(vrbs.sig_ustar,shocks.sig_ustar) = (params(params_index.sigma_ustar))*params(params_index.sigma_pi);


% gt
Sc(vrbs.g,shocks.sig_g) = params(params_index.sigma_g)*(params(params_index.sigma_ustar))*params(params_index.sigma_pi);

% Observation errors
 Sc(vrbs.oe_pi0,shocks.oe_pi0) = params(params_index.sigma_oe_pi0);
 Sc(vrbs.oe_pi1q_pi,shocks.oe_pi1q_pi) = params(params_index.sigma_oe_pi1q_pi);
 Sc(vrbs.oe_pi12q_pi,shocks.oe_pi12q_pi) = params(params_index.sigma_oe_pi12q_pi);
 Sc(vrbs.oe_pi14q_pi,shocks.oe_pi14q_pi) = params(params_index.sigma_oe_pi14q_pi);
 Sc(vrbs.oe_pi510Y_pi,shocks.oe_pi510Y_pi) = params(params_index.sigma_oe_pi510Y_pi);
 Sc(vrbs.oe_pi14q_u,shocks.oe_pi14q_u) = params(params_index.sigma_oe_pi14q_u); 

 
 F(vrbs.oe_usi,vrbs.oe_usi) = params(params_index.rho_theta_usi);
 F(vrbs.oe_uso,vrbs.oe_uso) = params(params_index.rho_theta_uso);
 F(vrbs.oe_ridx,vrbs.oe_ridx) = params(params_index.rho_theta_ridx);
 F(vrbs.oe_eeb,vrbs.oe_eeb) = params(params_index.rho_theta_eeb);
 Sc(vrbs.oe_usi,shocks.oe_usi) = params(params_index.sigma_oe_usi); 
 Sc(vrbs.oe_uso,shocks.oe_uso) = params(params_index.sigma_oe_uso); 
 Sc(vrbs.oe_ridx,shocks.oe_ridx) = params(params_index.sigma_oe_ridx); 
 Sc(vrbs.oe_eeb,shocks.oe_eeb) = params(params_index.sigma_oe_eeb); 
 Sc(vrbs.oe_utr,shocks.oe_utr) = params(params_index.sigma_oe_utr); 
 
 
 
Q = Sc*Sc'; 


% end

%% OLD TRICKS
% Note: here it is interepreted as sig_pi = lpi*sig_ustar
%Sc(vrbs.ustar,shocks.sig_ustar) = params(params_index.sigma_ustar)*params(params_index.sigma_pi);


% Note: here it is interepreted as sig_g = lg*sig_ustar
% Sc(vrbs.g,shocks.sig_g) = params(params_index.sigma_g)*...
%                           params(params_index.sigma_ustar)*params(params_index.sigma_pi);





