
%% Main Gibbs


 % Model with no observed trend and without ubar (only u_star)

 MH_select = [1 2 3 4 5 6 10];
 CF_select = [7 8 9 ];

 
 % Priors for parameter drwn in closed-form
 
 PriorsCF.Psix = 0.15^2*5;
 PriorsCF.df_x = 3;
 
 PriorsCF.Psimu = 1;
 PriorsCF.df_mu = 3;
 
 PriorsCF.SC0pist = 0.15^2*5;
 PriorsCF.df0pist = 3;
 
 Ndraws = 120000;disc_draws = 20000;
 
 csquare = .45;
 sigscaleGibbs = 1/26;
 
% Initial conditions
X_draws = params_estimated;

%Generate ubar path draws. Loaded ubar variable
%load Ubar_mat ubar
load Joint_estimationBASElineUbar_mat

n_draws_swl = 1;

drawsel = randperm(size(ubar,2));

ubar_draws = ubar(:,drawsel(1:min(n_draws_swl,size(ubar,2))));

Y_main(:,end) = 100*mean(ubar,2);  

%X_draws_mat = []; xi_TT_mat = [];
%load ubar_robust
X_draws_mat = NaN(length(X_draws),Ndraws);
xi_TT_mat = NaN(ModelDim.nvar,Ndraws,size(Y_main,1));
ustar_mat = NaN(size(Y_main,1),Ndraws);
ubar_mat = NaN(size(Y_main,1),Ndraws);
Y_pred_mat = NaN(ModelDim.nobs,Ndraws,size(Y_main,1));

for jj = 1:n_draws_swl
    
Y_main(:,end) = NaN;

% Compute initial conditions

 disp(['initial conditions for ubar draw:',num2str(jj)]);
  findModeGibbs;
  X_draws = xmode;


%X_draws = params_estimated;
 tic
 for jm = 1:Ndraws 
   
 
 %for jn = 1:1000 
[X_draws,xi_TT,Y_pred,Logpost_draw,accept,accept_var,p_acc,p_acc_var] = ...
                    Gibbs_draw2(sigscaleGibbs,X_draws,csquare,MH_select,CF_select,...
                    Mspec,priors,PriorsCF,params,params_index,params_estimated_index,...
                    bounds,trspec,vrbs,vrbs_obs,shocks,shocks_oe,ModelDim,Sml, type,learning,Y_main,Y_pre,trainingSampleLength);
 %end
 
%  eval(['X_draws_mat',num2str(jj),'(:,jm) = X_draws;']);
%  eval(['xi_TT_mat',num2str(jj),'(:,:,jm) = xi_TT;']);
 
 X_draws_mat(:,jm) = X_draws;
 xi_TT_mat(:,jm,:) = xi_TT;
 Y_pred_mat(:,jm,:) = Y_pred;
 ustar_mat(:,jm) = xi_TT(vrbs.ustar,:)' + Y_main(:,end);
 ubar_mat(:,jm) = Y_main(:,end);
%  Y_pred_mat(:,:,jm) = Y_pred;

% Display

 P_acc(jm)    = p_acc;
 P_acc_var(jm)= p_acc_var;
    
    if mod(jm,10)==0  % Print to command window
        if jm>1
            if jm <=1000
                disp([num2str(jm),'th draw of ',num2str(Ndraws),'; Elapsed time: ',num2str(toc),' seconds'])
                disp(['Acceptance rate so far: ',num2str(mean(P_acc(1:jm)))])
                disp(['Acceptance rate so far: ',num2str(mean(P_acc_var(1:jm)))])
            elseif jm <10000
                disp([num2str(jm),'th draw of ',num2str(Ndraws),'; Elapsed time: ',num2str(toc),' seconds'])
                disp(['Acceptance rate of the last 1k draws: ',num2str(mean(P_acc(jm-1000+1:jm)))])
                disp(['Acceptance rate of the last 1k draws: ',num2str(mean(P_acc_var(jm-1000+1:jm)))])
            else
                disp([num2str(jm),'th draw of ',num2str(Ndraws),'; Elapsed time: ',num2str(toc),' seconds'])
                disp(['Acceptance rate of the last 10k draws: ',num2str(mean(P_acc(jm-5000+1:jm)))])
                disp(['Acceptance rate of the last 10k draws: ',num2str(mean(P_acc_var(jm-5000+1:jm)))])
            end
        end
        
    end
                

 end
xi_TT_mat = xi_TT_mat(:,disc_draws+1:end,:);
Y_pred_mat = Y_pred_mat(:,disc_draws+1:end,:);
X_draws_mat = X_draws_mat(:,disc_draws+1:end);
ustar_mat = ustar_mat(:,disc_draws+1:end);
ubar_mat  = ubar_mat(:,disc_draws+1:end);
 if jj == 1
xi_TT_all = xi_TT_mat;
Y_pred_all = Y_pred_mat;
X_draws_all = X_draws_mat;
ustar_all = ustar_mat;
ubar_all = ubar_mat;  
else
xi_TT_all = [xi_TT_all,xi_TT_mat]; 
Y_pred_all = [Y_pred_all, Y_pred_mat];
X_draws_all = [X_draws_all X_draws_mat];
ustar_all = [ustar_all ustar_mat];
ubar_all =[ubar_all ubar_mat];
 end 
end
Results.Y_pred_all = Y_pred_all;
Results.xi_TT_all = xi_TT_all;
Results.X_draws_all = X_draws_all;
Results.P_acc = P_acc;
Results.P_acc_var = P_acc_var;
Results.ubar_draws = ubar_draws;
Results.ustar_all = ustar_all;
Results.ubar_all = ubar_all;
  save_name = 'US_noubar2';       
 save(save_name,'Results','-v7.3')