function [ xi_hat, shock_mat ] = shockDec(F_til,xi_tt_mat,Ptt_mat,xi_tl_mat,Ptl_mat, Sc_til, SIG_eps, h )
% This function decomposes the shocks of the economy into (a) the individual
% stochastic shocks as well as the natural evolution from its initial
% state.

ind_smooth_shocks = size(F_til,1) - size(SIG_eps,1) ; 
F = F_til(1:ind_smooth_shocks,:);
Sc = Sc_til(1:ind_smooth_shocks,:);
shock_mat = NaN(size(F,1), h, size(SIG_eps,1));
xi_simfwd = NaN( size(F,1) ,  h);

%-------------------OBTAINING SMOOTHED SHOCK ESTIMATES--------------------%

[xi_mat_smoothed, ~] = kalman_smoother(F_til,xi_tt_mat,Ptt_mat,xi_tl_mat,Ptl_mat);

% We obtain the smoothed shocks from the extended xi matrix:
e_smoothed = xi_mat_smoothed(ind_smooth_shock+1:end,:) ;
    
xi_simfwd(:,1) = xi_mat_smoothed(:,1);
 
%------------------------DECOMPOSING THE SHOCKS--------------------------%
    

for jj = 2:size(SIG_eps,1)+1;
    
    % We isolate the individual shocks from the smoothed shock matrix:
    e_j = zeros( size (SIG_eps,1) , h ) ; 
    e_j(jj-1,:) = e_smoothed(jj-1,:);
    
    % Initialize starting values of the shock matrix..
    shock_mat(:, 1 ,jj) =  F*xi_simfwd(:,1) % + Sc* e_j(:,1);

    for ll = 2:h ;
        xi_simfwd(:,i) = F * xi_simfwd(:,i-1);
        shock_mat(:,ll,jj-1) = F*shock_mat(:,ll-1,jj-1) + Sc * e_j(:,ll);
    end
    
    xi_hat = xi_simfwd;
    
end 

end

