function [] = plotShocks( shock_mat , vrbs_obs , shocks ,xi_mat_smoothed);
% This function creates a figure containing a series of graphs (one for 
% each observable) where each individual graph contains stacked bars that
% reflect the contribution of each shock toward the overall path of the
% observable. Superimposed on each graph is a line that contains the 
% smoothed path of the observable.

%Recall the dimensions of the input shock_mat:
%    shock_mat = NaN(size(F,1), h, size(SIG_eps,1));
% The first dimension contains observables, the second dimension contains
% the time period and the third dimension contains the shock.

namesShocks = fieldnames(shocks);
namesVrbs=fieldnames(vrbs_obs);
ny = size(namesVrbs,1);
ax1 = subplot(ny,1,1);
y = NaN(ny,1);
list_vrbs = [1,5,7];
% if you want to type in 

 ii = 0;
 figure;

for dd = list_vrbs; %iterate through y_observations
    ii = ii+1;
    ax = subplot(ny,1,ii);

    tt = [squeeze(shock_mat(dd,:,:)) , xi_hat'] ; % isolate the shock-path for a single observable, concatenate natural evolution transposed.s
   
    y = bar(tt,'stacked');  

    legend(y,[namesShocks' ; 'Nat. Evolution'],'Location','bestoutside') ;
    title([namesVrbs(dd),'Smoothed Shock Decompostion']);
    xlabel('Time Period');
    ylabel([namesVrbs(dd)])
    hold on
    plot(xi_mat_smoothed(dd,:),'LineWidth',2);
    hold on
  
end


    
end

