function [T_Z, T_epsilon, T_0] = T_map(systemMats_full,Omega_Z, lambda)

% This function takes the system matrices from a full model and rational
% expectations model. It determines whether the RE model serves as a
% solution for the full mode. For derivations of these formulas, please see
% the model documentation.

% compute intermediate product X
fields_to_sum={'A1','A2','A3','A4','A5','A6'};

X = zeros(size(systemMats_full.A0));
X_0 = zeros(size(systemMats_full.A0));

for i_mat=1:size(fields_to_sum,2)
    
    
    X   = X+systemMats_full.(fields_to_sum{i_mat})*Omega_Z*inv(eye(size(Omega_Z))-lambda(i_mat)^(-1)*Omega_Z);
    X_0 = X_0 + systemMats_full.(fields_to_sum{i_mat})*inv(eye(size(Omega_Z))-Omega_Z) * ...
                (inv(1-lambda(i_mat)^(-1))*eye(size(Omega_Z)) - Omega_Z*inv(eye(size(Omega_Z))-lambda(i_mat)^(-1)*Omega_Z));
end

% calculate T_Z and T_epsilon
T_Z       = inv(systemMats_full.A0-X)*systemMats_full.A7;
T_epsilon = inv(systemMats_full.A0-X)*systemMats_full.A8;
T_0       = inv(systemMats_full.A0-X)*X_0;
end