% function kalman_smoother.m performs the Kalman smoothing given the
% estimated states and their variances delivered by the Kalman filter

function [xi_smoothed,P_smoothed] = kalman_smoother(F_mat, xi_TT_out,P_TT_out,xi_TL_out,P_TL_out)



% Kalman smoother recursions (following Hamilton 1994, pp. 394-397)
T = size(xi_TT_out,2);
ny = size(xi_TT_out,1);
xi_smoothed = NaN(ny,T);
P_smoothed = NaN(ny,ny,T);

xi_smoothed(:,T) = xi_TT_out(:,T);
P_smoothed(:,:,T) = P_TT_out(:,:,T);

for t = T-1:-1:1
    
    J(:,:,t) = P_TT_out(:,:,t)*F_mat'*pinv(P_TL_out(:,:,t));
    
    xi_smoothed(:,t) = xi_TT_out(:,t) + J(:,:,t)*(xi_smoothed(:,t+1)-xi_TL_out(:,t));
    
    P_smoothed(:,:,t) = P_TT_out(:,:,t) + J(:,:,t)*(P_smoothed(:,:,t+1)-P_TL_out(:,:,t));
   
end;


