function [statesDec_mat, obsDec_mat] = ShockDec_fun(Filtered_shocks,Initial_state,sampleT,nshock,shock_ind,F,Sc,Hm,group_cell)


 if isempty(group_cell) 
  
% Define matrices for shock decomposition (first "shock" is the initial
 % condition)
 
 statesDec_mat = NaN(size(F,1),sampleT,length(shock_ind)+1);
 
 obsDec_mat = NaN(size(Hm',1),sampleT,length(shock_ind)+1);
 
 
 % initial state
 
 statesDec_mat(:,1,1) = Initial_state;
 
 statesDec_mat(:,1,2:end) = zeros(length(Initial_state),length(shock_ind));
 
 for hh = 1:length(shock_ind)+1
 
 obsDec_mat(:,1,hh) = Hm' * statesDec_mat(:,1,hh);  
 
 Filtered_shocks_hh = zeros(size(Filtered_shocks));
 
 if hh ~= 1
 
 Filtered_shocks_hh(shock_ind(hh-1),:) = Filtered_shocks(shock_ind(hh-1),:);
     
 end    
 
 for jj = 2:sampleT
    
 statesDec_mat(:,jj,hh) = F * statesDec_mat(:,jj-1,hh) +  Sc(:,1:nshock) * Filtered_shocks_hh(:,jj);
 
 obsDec_mat(:,jj,hh) = Hm' * statesDec_mat(:,jj,hh);
 
 end
 
 end


 else % group_cell
     
     
% Define matrices for shock decomposition (first "shock" is the initial
 % condition)
 
 statesDec_mat = NaN(size(F,1),sampleT,size(group_cell,1)+1);
 
 obsDec_mat = NaN(size(Hm',1),sampleT,size(group_cell,1)+1);
 
 
 % initial state
 
 statesDec_mat(:,1,1) = Initial_state;
 
 statesDec_mat(:,1,2:end) = zeros(length(Initial_state),size(group_cell,1));
 
 for hh = 1:size(group_cell,1)+1
 
 obsDec_mat(:,1,hh) = Hm' * statesDec_mat(:,1,hh);  
 
 Filtered_shocks_hh = zeros(size(Filtered_shocks));
 
 if hh ~= 1
 
 Filtered_shocks_hh(group_cell{hh-1},:) = Filtered_shocks(group_cell{hh-1},:);
     
 end    
 
 for jj = 2:sampleT
    
 statesDec_mat(:,jj,hh) = F * statesDec_mat(:,jj-1,hh) +  Sc(:,1:nshock) * Filtered_shocks_hh(:,jj);
 
 obsDec_mat(:,jj,hh) = Hm' * statesDec_mat(:,jj,hh);
 
 end
 
 end
 
 end % group_cell
     


