function [F, Q,flag_solve] = solveModel(A, B, C, systemMats_full, lambda, vrbs, type, nvar, nshock, nstate,params, learning)

flag_solve = 0;

% solve rational expectations model
[Br,Cr,Lr,NF,flag_reds] = redsf(A,B,C,nvar,nshock,nstate);
if flag_reds
F=NaN; Q=NaN; flag_solve = 1; return   
else
[D,F,G,H,flag_solds] = soldsf(Br,Cr,Lr,nvar,nshock,nstate,NF);
end

if flag_solds
    F=NaN; Q=NaN; flag_solve = 1; return    
else
D = real(D); F = real(F); G = real(G); H = real(H);
end

% Convert to VAR form
[Omega_Z, Omega_epsilon] = getVAR(D,F,G,H,vrbs,type);

if learning
    [T_Z, T_epsilon, T_0] = fullToRE(systemMats_full,Omega_Z,lambda);
else
    T_Z=Omega_Z; T_epsilon=Omega_epsilon;
end

% Get Q matrix
epsilon_vect = [];
parameters = fields(params);
for i = 1 : length(parameters)
    if strncmp(parameters(i), 'sigma_', 6) && ~strcmp(parameters(i), 'sigma_obs');
        epsilon_vect = [epsilon_vect; params.(parameters{i})];
    end
end
Epsilon = diag(epsilon_vect);

% assign output matrices
F = T_Z;
Q = T_epsilon * Epsilon * Omega_epsilon';

end

