function [params, params_index, params_fixed,trspec,bounds] = setParamsv1()

% This function outputs the params structure, which contains initialized values 
% of the model paramseters as well as derived steady-state values.

%% Households
params_index.betaT = 1;      params(params_index.betaT,1)       = 0.15;   params_fixed(params_index.betaT,1) = 0;   trspec(params_index.betaT,:) = [2	1E-5	0	1]; 
params_index.theta_w = 2;    params(params_index.theta_w,1)     = 3;     params_fixed(params_index.theta_w,1) = 1; trspec(params_index.theta_w,:) = zeros(1,4); 
params_index.sigma = 3;      params(params_index.sigma,1)       = 1.45;    params_fixed(params_index.sigma,1) = 0;   trspec(params_index.sigma,:) = [2	1E-5	0	1];
%params_index.phi_n = 4;      params(params_index.phi_n,1)       = 1;      params_fixed(params_index.phi_n,1) = 0;   trspec(params_index.phi_n,:) = [2	1E-5	0	1];

params_index.phi_nT = 4;      params(params_index.phi_nT,1)       = 2.5;      params_fixed(params_index.phi_nT,1) = 0;  trspec(params_index.phi_nT,:) = [2	1E-5	0	1];


params_index.b = 5;          params(params_index.b,1)           = 0.71;    params_fixed(params_index.b,1) = 0;       trspec(params_index.b,:) = [1	1E-5	.99	1];
% params_index.xi_w = 6;       params(params_index.xi_w,1)        = 0.085;  params_fixed(params_index.xi_w,1)= 0;     trspec(params_index.xi_w,:) = [2	1E-5	0	1];

params_index.xi_wT = 6;       params(params_index.xi_wT,1)        = 0.80;  params_fixed(params_index.xi_wT,1)= 0;     trspec(params_index.xi_wT,:) = [1	1E-5	.99	1];

params_index.iota_w = 7;     params(params_index.iota_w,1)      = 0.57;    params_fixed(params_index.iota_w,1) = 0;  trspec(params_index.iota_w,:) = [1	1E-5	.99	1];

hh = 7;

%% Firms I
params_index.gamma_1 = hh+1; params(params_index.gamma_1,1)     = 0.70;   params_fixed(params_index.gamma_1,1) = 0; trspec(params_index.gamma_1,:) = [1	1E-5	.99	1];
params_index.iota_p = hh+2;  params(params_index.iota_p,1)      = 0.29;   params_fixed(params_index.iota_p,1) = 0;  trspec(params_index.iota_p,:) = [1	1E-5	.99	1];
params_index.alpha = hh+3;   params(params_index.alpha,1)       = 0.16;    params_fixed(params_index.alpha,1) = 0;   trspec(params_index.alpha,:) = [1	1E-5	.99	1];

%params_index.theta_p = hh+4; params(params_index.theta_p,1)     = 2.7;     params_fixed(params_index.theta_p,1) = 1; trspec(params_index.theta_p,:) = [2	1E-5	0	1];

params_index.theta_pT = hh+4; params(params_index.theta_pT,1)     = 1.72;     params_fixed(params_index.theta_pT,1) = 0; trspec(params_index.theta_pT,:) = zeros(1,4);


%% Firms II
% params_index.xi_I = hh+5;    params(params_index.xi_I,1)        = 0.2;    params_fixed(params_index.xi_I,1) = 0;    trspec(params_index.xi_I,:) = [2	1E-5	0	1];
% params_index.xi_a = hh+6;    params(params_index.xi_a,1)        = 1;      params_fixed(params_index.xi_a,1) = 0;    trspec(params_index.xi_a,:) = [2	1E-5	0	1];

params_index.xi_IT = hh+5;    params(params_index.xi_IT,1)        = 6.11;    params_fixed(params_index.xi_IT,1) = 0;    trspec(params_index.xi_IT,:) = [2	1E-5	0	1];
params_index.xi_aT = hh+6;    params(params_index.xi_aT,1)        = 0.73;      params_fixed(params_index.xi_aT,1) = 0;    trspec(params_index.xi_aT,:) = [2	1E-5	0	1];

params_index.delta = hh+7;   params(params_index.delta,1)       = 0.025;  params_fixed(params_index.delta,1) = 1;   trspec(params_index.delta,:) = [1	1E-5	0.99 1];

bgg = hh+7;

%% Financial frictions

params_index.Fom = bgg+1;        params(params_index.Fom) = 1-(1-0.03)^(1/4);    params_fixed(params_index.Fom,1) = 1; trspec(params_index.Fom,:) = [1	1E-5	0.99 1];
params_index.ss_spread = bgg+2;  params(params_index.ss_spread) = (1+1.75/100)^(1/4);  params_fixed(params_index.ss_spread,1) = 1; trspec(params_index.ss_spread,:) =  [2	1E-5	0	1];
params_index.zeta_sp = bgg+3;  params(params_index.zeta_sp) = 0.00;  params_fixed(params_index.zeta_sp,1) = 1; trspec(params_index.zeta_sp,:) =  [2	1E-5	0	1];
params_index.gammstar = bgg+4;  params(params_index.gammstar) = 0.99;  params_fixed(params_index.gammstar,1) = 1; trspec(params_index.gammstar,:) =  [1	1E-5	0.995 1];

ff = bgg+4;


%% Monetary Policy
params_index.phi_pi = ff+1;  params(params_index.phi_pi,1)      = 2.03;       params_fixed(params_index.phi_pi,1)  = 0; trspec(params_index.phi_pi,:) = [2	1E-5	0 1];
params_index.rho_i = ff+2;   params(params_index.rho_i,1)       = 0.83;       params_fixed(params_index.rho_i,1) = 0;   trspec(params_index.rho_i,:) = [1	1E-5	0.99 1];
params_index.phi_x = ff+3;   params(params_index.phi_x,1)       = 0.08;      params_fixed(params_index.phi_x,1) = 0;   trspec(params_index.phi_x,:) = zeros(1,4);
params_index.phi_dx = ff+4;  params(params_index.phi_dx,1)       = 0.24;      params_fixed(params_index.phi_dx,1) = 0;   trspec(params_index.phi_dx,:) = zeros(1,4);

%% Fiscal Policy
params_index.by_ratio = ff+5;  params(params_index.by_ratio,1)    = 4*0.002;    params_fixed(params_index.by_ratio,1) = 1;  trspec(params_index.by_ratio,:) = [2	1E-5	0 1];
params_index.rho = ff+6;       params(params_index.rho,1)         = 0.97;     params_fixed(params_index.rho,1) = 1;       trspec(params_index.rho,:) = [1	1E-5	0.99 1];
params_index.rho_tau = ff+7;   params(params_index.rho_tau,1)     = 0.7;      params_fixed(params_index.rho_tau,1) = 1;   trspec(params_index.rho_tau,:) = [1	1E-5	0.99 1];
params_index.phi_taul = ff+8;  params(params_index.phi_taul,1)    = 0.05;     params_fixed(params_index.phi_taul,1) = 1;  trspec(params_index.phi_taul,:) = [1	1E-5	0.99 1];
params_index.phi_taux = ff+9;  params(params_index.phi_taux,1)    = 0.00;     params_fixed(params_index.phi_taux,1) = 1;  trspec(params_index.phi_taux,:) = zeros(1,4); % changed (base: 0.02)
params_index.gammaT = ff+10;    params(params_index.gammaT,1)      = 0.37;      params_fixed(params_index.gammaT,1) = 0;    trspec(params_index.gammaT,:) = [1	1E-5	0.99 1];
params_index.gy_ratio = ff+11; params(params_index.gy_ratio,1)    = 0.18;      params_fixed(params_index.gy_ratio,1) = 1;  trspec(params_index.gy_ratio,:) = [1	1E-5	.99 1];

% params.k_g = 0.05;

mp = ff+11;

%% Autocorrelation of shocks
params_index.rho_gamma = mp+1;   params(params_index.rho_gamma,1)   = 0;         params_fixed(params_index.rho_gamma,1) = 1;  trspec(params_index.rho_gamma,:) = [1	1E-5	0.999 1];
params_index.rho_theta_w = mp+2; params(params_index.rho_theta_w,1) = 0.976;      params_fixed(params_index.rho_theta_w,1) = 0; trspec(params_index.rho_theta_w,:) = [1	1E-5	0.999 1];
params_index.rho_theta_p = mp+3; params(params_index.rho_theta_p,1) = 0.87;      params_fixed(params_index.rho_theta_p,1) = 0; trspec(params_index.rho_theta_p,:) = [1	1E-5	0.999 1];
params_index.rho_g = mp+4;       params(params_index.rho_g,1)      = 0.975;           params_fixed(params_index.rho_g,1) = 0;   trspec(params_index.rho_g,:) = [1	1E-5	0.999 1];
params_index.rho_xi = mp+5;      params(params_index.rho_xi,1)      = 0.0;           params_fixed(params_index.rho_xi,1) = 1; trspec(params_index.rho_xi,:) = [1	1E-5	0.999 1];
params_index.rho_pistar = mp+6;  params(params_index.rho_pistar,1)  = 0;       params_fixed(params_index.rho_pistar,1) = 1; trspec(params_index.rho_pistar,:) = [1	1E-5	0.999 1];
params_index.rho_m = mp+7;       params(params_index.rho_m,1)       = 0.12;           params_fixed(params_index.rho_m,1) = 0;  trspec(params_index.rho_m,:) = [1	1E-5	0.999 1];
params_index.rho_mu = mp+8;      params(params_index.rho_mu,1)     = 0.70;          params_fixed(params_index.rho_mu,1) = 0;   trspec(params_index.rho_mu,:) = [1	1E-5	0.999 1];
params_index.rho_tau_hat = mp+9; params(params_index.rho_tau_hat,1) = 0;      params_fixed(params_index.rho_tau_hat,1) = 1; trspec(params_index.rho_tau_hat,:) = [1	1E-5	0.999 1];
params_index.rho_b = mp+10;      params(params_index.rho_b,1)      = 0.21;           params_fixed(params_index.rho_b,1) = 0;   trspec(params_index.rho_b,:) = [1	1E-5	0.999 1];
params_index.rho_a = mp+11;      params(params_index.rho_a,1)      = 0.976;           params_fixed(params_index.rho_a,1) = 0;   trspec(params_index.rho_a,:) = [1	1E-5	0.999 1];
params_index.rho_som = mp+12;    params(params_index.rho_som,1)      = 0.989;           params_fixed(params_index.rho_som,1) = 0;   trspec(params_index.rho_som,:) = [1	1E-5	0.999 1];

%% MA parameters
params_index.phi_theta_w = mp+13; params(params_index.phi_theta_w,1)= 0.96;      params_fixed(params_index.phi_theta_w,1) = 0;   trspec(params_index.phi_theta_w,:) = [1	1E-5	0.999 1];
params_index.phi_theta_p = mp+14; params(params_index.phi_theta_p,1)= 0.74;      params_fixed(params_index.phi_theta_p,1) = 0;   trspec(params_index.phi_theta_p,:) = [1	1E-5	0.999 1];

rs = mp+14;

%% Standard deviation of shocks
params_index.sigma_gamma = rs+1;    params(params_index.sigma_gamma,1)    = 0;       params_fixed(params_index.sigma_gamma,1) = 1;  trspec(params_index.sigma_gamma,:) = [2	1E-5	0 1];
params_index.sigma_theta_w = rs+2;  params(params_index.sigma_theta_w,1)  = 0.27;     params_fixed(params_index.sigma_theta_w,1) = 0;  trspec(params_index.sigma_theta_w,:) = [2	1E-5	0 1];
params_index.sigma_theta_p = rs+3;  params(params_index.sigma_theta_p,1)  = 0.14;     params_fixed(params_index.sigma_theta_p,1) = 0;  trspec(params_index.sigma_theta_p,:) = [2	1E-5	0 1];
params_index.sigma_g = rs+4;        params(params_index.sigma_g,1)        = 0.52;          params_fixed(params_index.sigma_g,1) = 0;   trspec(params_index.sigma_g,:) = [2	1E-5	0 1];
params_index.sigma_xi = rs+5;       params(params_index.sigma_xi,1)     = 0;         params_fixed(params_index.sigma_xi,1)  = 1;    trspec(params_index.sigma_xi,:) = [2	1E-5	0 1];
params_index.sigma_pistar = rs+6;   params(params_index.sigma_pistar,1)   = 0;      params_fixed(params_index.sigma_pistar,1) = 1;  trspec(params_index.sigma_pistar,:) = [2	1E-5	0 1];
params_index.sigma_m = rs+7;        params(params_index.sigma_m,1)        = 0.24;           params_fixed(params_index.sigma_m,1)  = 0; trspec(params_index.sigma_m,:) = [2	1E-5	0 1];
params_index.sigma_mu = rs+8;       params(params_index.sigma_mu,1)       = 0.42;          params_fixed(params_index.sigma_mu,1) = 0;  trspec(params_index.sigma_mu,:) = [2	1E-5	0 1];
params_index.sigma_tau_hat = rs+9;  params(params_index.sigma_tau_hat,1)  = 0;     params_fixed(params_index.sigma_tau_hat,1) = 1;  trspec(params_index.sigma_tau_hat,:) = [2	1E-5	0 1];
params_index.sigma_b = rs+10;       params(params_index.sigma_b,1)        = 0.21;           params_fixed(params_index.sigma_b,1) = 0;  trspec(params_index.sigma_b,:) = [2	1E-5	0 1];
params_index.sigma_a = rs+11;       params(params_index.sigma_a,1)        = 0.45;           params_fixed(params_index.sigma_a,1) = 0;  trspec(params_index.sigma_a,:) = [2	1E-5	0 1];
params_index.sigma_ggam = rs+12;    params(params_index.sigma_ggam,1)    = 0.52;           params_fixed(params_index.sigma_ggam,1) = 0;    trspec(params_index.sigma_ggam,:) = [1	1E-5	0.99 1];
params_index.sigma_som = rs+13;    params(params_index.sigma_som,1)    = 0.05;           params_fixed(params_index.sigma_som,1) = 0;    trspec(params_index.sigma_som,:) = [1	1E-5	0.99 1];

params_index.sigma_oe_w = rs+14;   params(params_index.sigma_oe_w,1)    = 0;       params_fixed(params_index.sigma_oe_w,1) = 1;    trspec(params_index.sigma_oe_w,:) = [2	1E-5	0 1];
params_index.sigma_oe_bm = rs+15;   params(params_index.sigma_oe_bm,1)    = 0;       params_fixed(params_index.sigma_oe_bm,1) = 1;    trspec(params_index.sigma_oe_bm,:) = [2	1E-5	0 1];

params_index.rho_oe_s = rs+16;    params(params_index.rho_oe_s,1)      = 0.0;           params_fixed(params_index.rho_oe_s,1) = 1;   trspec(params_index.rho_oe_s,:) = [1	1E-5	0.99 1];
params_index.sigma_oe_s = rs+17;   params(params_index.sigma_oe_s,1)    = 0.00;       params_fixed(params_index.sigma_oe_s,1) = 1;    trspec(params_index.sigma_oe_s,:) = [2	1E-5	0 1];

sd = rs+17;
%% In observation equations only

params_index.Lmean = sd +1;         params(params_index.Lmean)    = -43.7;            params_fixed(params_index.Lmean) = 0;        trspec(params_index.Lmean,:) = zeros(1,4); %trspec(params_index.Lmean,:) = [2	1E-5	0 1];
params_index.Spread = sd +2;        params(params_index.Spread)   = 2;            params_fixed(params_index.Spread) = 0;        trspec(params_index.Spread,:) = [2	1E-5	0 1];
params_index.pi = sd+3;             params(params_index.pi)       = 0.63;       params_fixed(params_index.pi) = 0;      trspec(params_index.pi,:) = [2	1E-5	0 1];
params_index.spc = sd+4;             params(params_index.spc)       = 0.009;       params_fixed(params_index.spc) = 0;      trspec(params_index.spc,:) = [1	1E-5	0.99 1];



%% Bounds (for MH algorithm)
% Households
bounds(params_index.betaT,:) = [1E-5 .99999];  bounds(params_index.xi_wT,:) = [1E-5 0.99999];  %bounds(params_index.xi_w,:) = [1E-5 10.99999];   
bounds(params_index.theta_w,:) = [1E-5 50.99999];  bounds(params_index.iota_w,:) = [1E-5 .99999];    
bounds(params_index.sigma,:) = [1E-5 50.99999]; bounds(params_index.phi_nT,:) = [1E-5 50.99999]; %bounds(params_index.phi_n,:) = [1E-5 50.99999]; 
bounds(params_index.b,:) = [1E-5 .99999]; 

% Firms I
bounds(params_index.gamma_1,:) = [1E-5 .99999];  %bounds(params_index.theta_p,:) = [1E-5 50.99999];  
bounds(params_index.iota_p,:) = [1E-5 .99999]; bounds(params_index.theta_pT,:) = [1E-5 50.99999];   
bounds(params_index.alpha,:) = [1E-5 .99999];    

% Firms II
% bounds(params_index.xi_I,:) = [1E-5 50.99999]; 
% bounds(params_index.xi_a,:) = [1E-5 50.99999];

bounds(params_index.xi_IT,:) = [1E-5 50.99999]; 
bounds(params_index.xi_aT,:) = [1E-5 50.99999];

bounds(params_index.delta,:) = [1E-5 .99999]; 

% BGG

bounds(params_index.Fom,:) = [1E-5 50.99999]; 
bounds(params_index.ss_spread,:) = [1E-5 50.99999]; 
bounds(params_index.gammstar,:) = [1E-5 50.99999]; 
bounds(params_index.zeta_sp,:) = [1E-5 50.99999]; 



% Monetary policy
bounds(params_index.phi_pi,:) = [1E-5 50.99999];bounds(params_index.rho_i,:) = [1E-5 .99999]; bounds(params_index.phi_x,:) = [-50 50.99999];
bounds(params_index.phi_dx,:) = [-50 50.99999];

% Fiscal Policy
bounds(params_index.by_ratio,:) = [1E-5 50.99999];bounds(params_index.rho,:) = [1E-5 .99999]; bounds(params_index.rho_tau ,:) = [1E-5 .99999];
bounds(params_index.phi_taul,:) = [1E-5 .99999]; bounds(params_index.phi_taux,:) = [-1 .99999];bounds(params_index.gammaT,:) = [1E-5 0.99999];
bounds(params_index.gy_ratio,:) = [1E-5 .99999];

% Autocorrelation of shocks
bounds(params_index.rho_gamma,:) = [1E-5 .99999];bounds(params_index.rho_g,:) = [1E-5 .99999]; bounds(params_index.rho_pistar,:) = [1E-5 .99999];
bounds(params_index.rho_theta_w,:) = [1E-5 .99999]; bounds(params_index.rho_xi,:) = [1E-5 .99999];
bounds(params_index.rho_theta_p,:) = [1E-5 .99999];bounds(params_index.rho_m,:) = [1E-5 .99999]; bounds(params_index.rho_mu,:) = [1E-5 .99999];
bounds(params_index.rho_tau_hat,:) = [1E-5 .99999];bounds(params_index.rho_b,:) = [1E-5 .99999];bounds(params_index.rho_a,:) = [1E-5 .99999];
bounds(params_index.rho_som,:) = [1E-5 .99999];


% MA components

bounds(params_index.phi_theta_w,:) = [1E-5 .99999];bounds(params_index.phi_theta_p,:) = [1E-5 .99999];

% Standard deviation of shocks

bounds(params_index.sigma_gamma,:) = [1E-5 50.99999];bounds(params_index.sigma_g,:) = [1E-5 50.99999]; bounds(params_index.sigma_pistar,:) = [1E-5 50.99999];
bounds(params_index.sigma_theta_w,:) = [1E-5 50.99999]; bounds(params_index.sigma_xi,:) = [1E-5 50.99999];
bounds(params_index.sigma_theta_p,:) = [1E-5 50.99999];bounds(params_index.sigma_m,:) = [1E-5 50.99999]; bounds(params_index.sigma_mu,:) = [1E-5 50.99999];
bounds(params_index.sigma_tau_hat,:) = [1E-5 50.99999];bounds(params_index.sigma_b,:) = [1E-5 50.99999]; bounds(params_index.sigma_ggam,:) = [1E-5 50.99999];
bounds(params_index.sigma_som,:) = [1E-5 50.99999];
bounds(params_index.sigma_oe_w,:) = [1E-5 50.99999]; bounds(params_index.sigma_oe_bm,:) = [1E-5 50.99999];bounds(params_index.sigma_a,:) = [1E-5 50.99999];

bounds(params_index.sigma_oe_s,:) = [1E-5 50.99999];
bounds(params_index.rho_oe_s,:) = [1E-5 .99999];

% In observation equations only
bounds(params_index.Lmean,:) = [-50 50.99999];%[-1E-5 50.99999];
bounds(params_index.Spread,:) = [-1E-5 50.99999];
bounds(params_index.pi,:) = [1E-5 50.99999];
bounds(params_index.spc,:) = [1E-5 50.99999];





end

