function [params, params_index, params_fixed] = setParams()
% This function outputs the params structure, which contains initialized values 
% of the model paramseters as well as derived steady-state values.

%% Households
params.betaT       = 0.25;   params_index.betaT = 1;    params_fixed.betaT = 0;
params.theta_w     = 10;     params_index.theta_w = 2;  params_fixed.theta_w = 1;
params.sigma       = 1.5;    params_index.sigma = 3;    params_fixed.sigma = 0;
params.phi_n       = 1;      params_index.phi_n = 4;    params_fixed.phi_n = 0;
params.b           = 0.5;    params_index.b = 5;        params_fixed.b = 0;
params.xi_w        = 0.085;  params_index.xi_w = 6;     params_fixed.xi_w = 0;
params.iota_w      = 0.2;    params_index.iota_w = 7;   params_fixed.iota_w = 0;

hh = 7;

%% Firms I
params.gamma_1     = 0.75;   params_index.gamma_1 = hh+1;  params_fixed.gamma_1 = 0; 
params.iota_p      = 0.15;   params_index.iota_p = hh+2;   params_fixed.iota_p = 0; 
params.alpha       = 0.3;    params_index.alpha = hh+3;    params_fixed.alpha = 0; 
params.theta_p     = 11;     params_index.theta_p = hh+4;  params_fixed.theta_p = 1; 

%% Firms II
params.xi_I        = 2;      params_index.xi_I = hh+5;     params_fixed.xi_I = 0; 
params.xi_a        = 1;      params_index.xi_a = hh+6;     params_fixed.xi_a = 0;
params.delta       = 0.025;  params_index.delta = hh+7;    params_fixed.delta = 1; 

ff = hh+7;

%% Monetary Policy
params.phi_pi      = 1.5;    params_index.phi_pi = ff+1;   params_fixed.phi_pi = 0; 
params.rho_i       = 0.7;    params_index.rho_i = ff+2;    params_fixed.rho_i = 0; 
params.phi_x       = 0.00;   params_index.phi_x = ff+3;    params_fixed.phi_x = 0; % changed (base: 0.05)
params.pi          = 1;      params_index.pi = ff+4;       params_fixed.pi = 0; 

%% Fiscal Policy
params.by_ratio    = 4*0.2;  params_index.by_ratio = ff+5;  params_fixed.by_ratio = 1; 
params.rho         = 0.97;   params_index.rho = ff+6;       params_fixed.rho = 1; 
params.rho_tau     = 0.7;    params_index.rho_tau = ff+7;   params_fixed.rho_tau = 0; 
params.phi_taul    = 0.05;   params_index.phi_taul = ff+8;  params_fixed.phi_taul = 0; 
params.phi_taux    = 0.00;   params_index.phi_taux = ff+9;  params_fixed.phi_taux = 0; % changed (base: 0.02)
params.gamma       = 1.004;  params_index.gamma = ff+10;     params_fixed.gamma = 0; 
params.gy_ratio    = 0.2;    params_index.gy_ratio = ff+11;  params_fixed.gy_ratio = 1; 

% params.k_g = 0.05;

mp = ff+11;

%% Autocorrelation of shocks
params.rho_gamma   = 0.2;    params_index.rho_gamma = mp+1;    params_fixed.rho_gamma = 0; 
params.rho_theta_w = 0.8;    params_index.rho_theta_w = mp+2;  params_fixed.rho_theta_w = 0; 
params.rho_theta_p = 0.8;    params_index.rho_theta_p = mp+3;  params_fixed.rho_theta_p = 0; 
params.rho_g       = 0.8;    params_index.rho_g = mp+4;        params_fixed.rho_g = 0; 
params.rho_xi      = 0.8;    params_index.rho_xi = mp+5;       params_fixed.rho_xi = 0; 
params.rho_pistar  = 0.8;    params_index.rho_pistar = mp+6;   params_fixed.rho_pistar = 0; 
params.rho_m       = 0.8;    params_index.rho_m = mp+7;        params_fixed.rho_m = 0; 
params.rho_mu      = 0.8;    params_index.rho_mu = mp+8;       params_fixed.rho_mu = 0;  
params.rho_tau_hat = 0.8;    params_index.rho_tau_hat = mp+9;  params_fixed.rho_tau_hat = 0; 
params.rho_b       = 0.8;    params_index.rho_b = mp+10;        params_fixed.rho_b = 0; 

rs = mp+10;

%% Standard deviation of shocks
params.sigma_gamma    = 1;   params_index.sigma_gamma = rs+1;    params_fixed.sigma_gamma = 0; 
params.sigma_theta_w  = 1;   params_index.sigma_theta_w = rs+2;  params_fixed.sigma_theta_w = 0; 
params.sigma_theta_p  = 1;   params_index.sigma_theta_p = rs+3;  params_fixed.sigma_theta_p = 0; 
params.sigma_g        = 1;   params_index.sigma_g = rs+4;        params_fixed.sigma_g = 0; 
params.sigma_xi       = 1;   params_index.sigma_xi = rs+5;       params_fixed.sigma_xi = 0; 
params.sigma_pistar   = 1;   params_index.sigma_pistar = rs+6;   params_fixed.sigma_pistar = 0; 
params.sigma_m        = 1;   params_index.sigma_m = rs+7;        params_fixed.sigma_m = 0; 
params.sigma_mu       = 1;   params_index.sigma_mu = rs+8;       params_fixed.sigma_mu = 0; 
params.sigma_tau_hat  = 1;   params_index.sigma_tau_hat = rs+9;  params_fixed.sigma_tau_hat = 0; 
params.sigma_b        = 1;   params_index.sigma_b = rs+10;        params_fixed.sigma_b = 0; 
params.sigma_oe_w     = 1;   params_index.sigma_oe_w = rs+11;     params_fixed.sigma_oe_w = 0; 




%% Steady-state values (MOVE)
params.beta           = (params.betaT/100+1)^-1; 
params.R              = params.beta^(-1) * params.gamma^(params.sigma);
params.P_m            = 1/(params.beta^(-1)*params.gamma^(params.sigma)-params.rho);
params.sy_ratio       = (params.beta^-1*params.gamma^(params.sigma-1)-1)*params.by_ratio;
params.R_K            = params.beta^(-1) * params.gamma^(params.sigma) - (1 - params.delta);
params.ik_ratio       = 1 - (1 - params.delta) * params.gamma^(-1);
params.S              = (params.theta_p - 1) / params.theta_p;
params.w_r            = (params.S * (1 - params.alpha)*(params.alpha/(1-params.alpha))^params.alpha / (params.R_K^params.alpha)) ^ (1/(1-params.alpha));
params.kN_ratio       = params.alpha/(1-params.alpha)*(params.w_r/params.R_K)*params.gamma;
params.yN_ratio       = params.gamma^(-params.alpha)*(params.kN_ratio)^(params.alpha)*params.S;
params.yk_ratio       = params.S*params.gamma^(-1)*((params.alpha/(1-params.alpha))*(params.w_r/params.R_K))^(params.alpha-1);
params.iy_ratio       = params.ik_ratio/params.yk_ratio;
params.ck_ratio       = (1-params.gy_ratio)*params.yk_ratio-params.ik_ratio; 
params.cy_ratio       = 1-params.ik_ratio/params.yk_ratio-params.gy_ratio;
params.wc_ratio       = (1-params.alpha)/params.alpha*(params.ck_ratio)^-1*(params.R_K/params.gamma);
params.xi_v           = (params.sigma-1)/(1-(params.gamma^-1)*params.b)*(params.theta_w-1)/params.theta_w * params.wc_ratio;
params.xi_vv          = params.phi_n^-1 +(params.sigma-1)/params.sigma*params.xi_v;
params.tauy_ratio     = params.sy_ratio+params.gy_ratio;
params.F_y_ratio      = (1-params.S)/params.S;    % set temporarily as zero; we need to figure out its inital value later
params.xi_p           = (1-params.gamma_1)*(1-params.gamma_1*params.beta*params.gamma^(1-params.sigma))*params.gamma_1^(-1);

% calculate some intermediate paramseters
params.c_1w = -(params.xi_v - params.xi_vv)*params.theta_w + 1 + params.xi_w ^ (-1) + params.xi_w^(-1)*params.beta*params.gamma^(1-params.sigma);
params.c_2w = params.xi_w^(-1)*(1+params.beta*params.gamma^(1-params.sigma)*params.iota_w - params.xi_w*(1-params.b*params.gamma^(-1))^(-1));
params.c_3w = params.xi_v - params.xi_vv;


end

