function [spc,beta, theta_w, sigma, phi_n, b, xi_w, iota_w, gamma_1, iota_p, alpha, theta_p, xi_a, delta, phi_pi,...
    rho_i, phi_x, phi_dx,pi, by_ratio, rho, rho_tau, phi_taul, phi_taux, gamma, gy_ratio, rho_gamma, rho_theta_w, ...
    rho_theta_p, rho_g, rho_xi, rho_pistar, rho_m, rho_mu, rho_tau_hat, rho_b, rho_a,rho_som,phi_theta_w,phi_theta_p,sigma_gamma, sigma_theta_w, ...
    sigma_theta_p, sigma_g, sigma_xi, sigma_pistar, sigma_m, sigma_mu, sigma_tau_hat, sigma_b, sigma_a, sigma_ggam,sigma_som,sigma_oe_w, ...
    R, P_m, sy_ratio, R_K, ik_ratio, S, w_r, kN_ratio, yN_ratio, yk_ratio, iy_ratio, ck_ratio, cy_ratio, ...
    wc_ratio, xi_v, xi_vv, tauy_ratio, F_y_ratio, xi_p, xi_I, c_1w, c_2w, c_3w] = getparamsv1(params, params_index)
% Function assigns model parameter values as a function of the vector
% params. Each parameters is determined by the location index params_index

% NOTE: we have tranformed some of the params to match SmetsWouters priors
betaT = params(params_index.betaT) ;
theta_w = params(params_index.theta_w) ;
sigma = params(params_index.sigma) ;
%phi_n = params(params_index.phi_n) ;

spc = params(params_index.spc) ;

phi_nT = params(params_index.phi_nT) ;

b = params(params_index.b) ;
%xi_w = params(params_index.xi_w) ;

xi_wT = params(params_index.xi_wT) ;

iota_w = params(params_index.iota_w) ;
gamma_1 = params(params_index.gamma_1) ;
iota_p = params(params_index.iota_p) ;
alpha = params(params_index.alpha) ;

% theta_p = params(params_index.theta_p);

theta_pT = params(params_index.theta_pT);

% xi_a = params(params_index.xi_a) ;
% xi_I = params(params_index.xi_I) ;

xi_aT = params(params_index.xi_aT) ;
xi_IT = params(params_index.xi_IT) ;

delta = params(params_index.delta) ;
phi_pi = params(params_index.phi_pi) ;
rho_i = params(params_index.rho_i) ;
phi_x = params(params_index.phi_x) ;
phi_dx = params(params_index.phi_dx) ;
pi = params(params_index.pi) ;
by_ratio = params(params_index.by_ratio) ;
rho = params(params_index.rho) ;
rho_tau = params(params_index.rho_tau) ;
phi_taul = params(params_index.phi_taul) ;
phi_taux = params(params_index.phi_taux) ;
gammaT = params(params_index.gammaT) ;
gy_ratio = params(params_index.gy_ratio) ;
rho_gamma = params(params_index.rho_gamma) ;
rho_theta_w = params(params_index.rho_theta_w) ;
rho_theta_p = params(params_index.rho_theta_p) ;
rho_g = params(params_index.rho_g) ;
rho_xi = params(params_index.rho_xi) ;
rho_pistar = params(params_index.rho_pistar) ;
rho_m = params(params_index.rho_m) ;
rho_mu = params(params_index.rho_mu) ;
rho_tau_hat = params(params_index.rho_tau_hat) ;
rho_b = params(params_index.rho_b) ;
rho_a = params(params_index.rho_a) ;
rho_som = params(params_index.rho_som) ;
phi_theta_w = params(params_index.phi_theta_w) ;
phi_theta_p = params(params_index.phi_theta_p) ;
sigma_gamma = params(params_index.sigma_gamma) ;
sigma_theta_w = params(params_index.sigma_theta_w) ;
sigma_theta_p = params(params_index.sigma_theta_p) ;
sigma_g = params(params_index.sigma_g) ;
sigma_xi = params(params_index.sigma_xi) ;
sigma_pistar = params(params_index.sigma_pistar) ;
sigma_m = params(params_index.sigma_m) ;
sigma_mu= params(params_index.sigma_mu) ;
sigma_tau_hat = params(params_index.sigma_tau_hat) ;
sigma_b = params(params_index.sigma_b) ;
sigma_a = params(params_index.sigma_a) ;
sigma_ggam = params(params_index.sigma_ggam) ;
sigma_som = params(params_index.sigma_som) ;
sigma_oe_w = params(params_index.sigma_oe_w) ;


% Calculate untranformed parameters

beta           = (betaT/100+1)^-1; 
gamma          = gammaT/100+1;
theta_p        = 1/(theta_pT-1) + 1;
xi_p           = (1-gamma_1)*(1-gamma_1*beta*gamma^(1-sigma))*gamma_1^(-1); %note: no real rigidities in wage and price setting
stcw = (1/(theta_w-1))*10 + 1;
xi_w           = (1-beta*gamma^(1-sigma)*xi_wT)*(1-xi_wT)/(xi_wT*stcw); % adds real rigidities as in SW

%phi_n          = phi_nT^-1;

xi_a           = xi_aT/(1- xi_aT);
xi_I           = xi_IT^-1;

% Calculate Steady State Values    

R              = beta^(-1) * gamma^(sigma);
P_m            = 1/(beta^(-1)*gamma^(sigma)-rho);
sy_ratio       = (beta^-1*gamma^(sigma-1)-1)*by_ratio;
R_K            = beta^(-1) * gamma^(sigma) - (1 - delta);
ik_ratio       = 1 - (1 - delta) * gamma^(-1);
S              = (theta_p - 1) / theta_p;
w_r            = (S * (1 - alpha)*(alpha/(1-alpha))^alpha / (R_K^alpha)) ^ (1/(1-alpha));
kN_ratio       = alpha/(1-alpha)*(w_r/R_K)*gamma;
yN_ratio       = gamma^(-alpha)*(kN_ratio)^(alpha)*S;
yk_ratio       = S*gamma^(-1)*((alpha/(1-alpha))*(w_r/R_K))^(alpha-1);
iy_ratio       = ik_ratio/yk_ratio;
ck_ratio       = (1-gy_ratio)*yk_ratio-ik_ratio; 
cy_ratio       = 1-iy_ratio-gy_ratio;
wc_ratio       = (1-alpha)/alpha*(ck_ratio)^-1*(R_K/gamma);
xi_v           = (sigma-1)/(1-(gamma^-1)*b)*(theta_w-1)/theta_w * wc_ratio;

phi_n          = 1/(phi_nT + sigma^-1*xi_v); % this accords with the SW constant-consumption elasticity of labor supply (see "CompareModels" notes)

xi_vv          = phi_n^-1 +(sigma-1)/sigma*xi_v;
tauy_ratio     = sy_ratio+gy_ratio;
F_y_ratio      = (1-S)/S;    % set temporarily as zero; we need to figure out its inital value later

% calculate some intermediate parameters
c_1w = -(xi_v - xi_vv)*theta_w + 1 + xi_w ^ (-1) + xi_w^(-1)*beta*gamma^(1-sigma);
c_2w = xi_w^(-1)*(1+beta*gamma^(1-sigma)*iota_w - xi_w*(1-b*gamma^(-1))^(-1));
c_3w = xi_v - xi_vv;

