function [H,M,R] = getMeasurementEquation(vrbs, vrbs_obs, params,params_index, ModelDim)
                                         
nobs = ModelDim.nobs;
nvar = ModelDim.nvar;

%% Initialize measurement equation matrices
H = zeros(nobs,nvar);
M = zeros(nobs,1);

%% Populate measurement equation matrices

% 1. Output growth
H(vrbs_obs.GDP, vrbs.y) = 1;
H(vrbs_obs.GDP, vrbs.y_lag) = -1;
H(vrbs_obs.GDP,vrbs.gamma) = 1;

M(vrbs_obs.GDP) = params(params_index.gammaT);

% 2. Hours 
H(vrbs_obs.Hours,vrbs.N) = 1;
M(vrbs_obs.Hours) = params(params_index.Lmean);

% 3. Real Wage Growth (defined as labor share)   
H(vrbs_obs.Wage,vrbs.w_r) = 1;
H(vrbs_obs.Wage,vrbs.w_r_lag) = -1;
H(vrbs_obs.Wage,vrbs.gamma) = 1;
M(vrbs_obs.Wage) = params(params_index.gammaT);

H(vrbs_obs.Wage,vrbs.oe_wage) = 1; % observation error on wage growth 


% 4. Inflation
H(vrbs_obs.Inflation, vrbs.pi) = 1;
M(vrbs_obs.Inflation) = params(params_index.pi);

% 5. Nominal interest rate 
H(vrbs_obs.FedFunds,vrbs.R) = 1;

PIstar = params(params_index.pi)/100 +1;
beta = (params(params_index.betaT)/100+1)^-1;
gamma = (params(params_index.gammaT)/100+1);
%M(vrbs_obs.FedFunds) = 100*log(beta^(-1)*gamma^(params(params_index.sigma))) + params(params_index.pi);
M(vrbs_obs.FedFunds) = 100*(beta^(-1)*gamma^(params(params_index.sigma))*PIstar - 1);

% 6. Consumption Growth
H(vrbs_obs.C,vrbs.c) = 1; 
H(vrbs_obs.C,vrbs.c_lag) = -1; 
H(vrbs_obs.C,vrbs.gamma) = 1; 
M(vrbs_obs.C) = params(params_index.gammaT);

% 7. Investment Growth
H(vrbs_obs.I,vrbs.i) = 1; 
H(vrbs_obs.I,vrbs.i_lag) = -1; 
H(vrbs_obs.I,vrbs.gamma) = 1; 
M(vrbs_obs.I) = params(params_index.gammaT);

% 8. Spread
% H(vrbs_obs.Spread,vrbs.b_shock) = (params(params_index.sigma)*...
%                                   (1+params(params_index.b)*...
%                                   gamma^(-1))/(1-params(params_index.b)*gamma^(-1))); % I am messing with it!
% 
%  H(vrbs_obs.Spread,vrbs.som_shock) = 1; %add corporate spread
 
% H(vrbs_obs.Spread,vrbs.k) = params(params_index.spc);
% H(vrbs_obs.Spread,vrbs.P_k) = 0.05;

H(vrbs_obs.Spread,vrbs.Spread) = 1;

H(vrbs_obs.Spread,vrbs.oe_s) = 1; % observation shock

M(vrbs_obs.Spread) = params(params_index.Spread)/4;


% 9. Tax revenues

H(vrbs_obs.Tax,vrbs.tau) = 1;

sy_ratio = (beta^-1*gamma^(params(params_index.sigma)-1)-1)*params(params_index.by_ratio);

tau_y_ratio = sy_ratio + params(params_index.gy_ratio);

M(vrbs_obs.Tax) = tau_y_ratio;

% 10. Gov Debt

Pm = 1/(beta^(-1)*gamma^(params(params_index.sigma))-params(params_index.rho)); 


H(vrbs_obs.GDebt,vrbs.b_m) = (1/4)*Pm;

H(vrbs_obs.GDebt,vrbs.P_m) = params(params_index.by_ratio)/4;

H(vrbs_obs.GDebt,vrbs.y) = -params(params_index.by_ratio)/4;

H(vrbs_obs.GDebt,vrbs.oe_bm) = 1;

M(vrbs_obs.GDebt) = params(params_index.by_ratio)/4;

H = H'; % Hamilton Notation

R = zeros(nobs,nobs);

