clear;close all;

% get parameters and variable indices
params = setParams();
[vrbs, shocks, nvar, nstate, nshock] = defineModel();

% Initialize canonical-form matrices (which we will later populate)
A0=zeros(nvar,nvar);
A1=zeros(nvar,nvar);
A2=zeros(nvar,nvar);
A3=zeros(nvar,nvar);
A4=zeros(nvar,nvar);
A5=zeros(nvar,nvar);
A6=zeros(nvar,nvar);

%% Firm's Decision Rule (capital accumulation and investment)
firms=struct;

% set number of variables
firms.nvar  = 3;
firms.nstate= 1;

% assign indices to relevant state variables
firms.i     = 1;
firms.P_k   = 2;
firms.i_lag = 3;

% Define Psi_0 and Psi_1 matrices
firms.Psi_0 = zeros(firms.nvar,firms.nvar);
firms.Psi_1 = zeros(firms.nvar,firms.nvar);

firms.Psi_0(firms.i,firms.i)          = -params.beta*params.gamma^(1-params.sigma);
firms.Psi_0(firms.P_k,firms.P_k)      = params.beta*params.gamma^(1-params.sigma)*(1-params.delta);
firms.Psi_0(firms.i_lag,firms.i_lag)  = 1;

firms.Psi_1(firms.i,firms.i)          = -(1+params.beta*params.gamma^(1-params.sigma));
firms.Psi_1(firms.i,firms.P_k)        = params.xi_I;
firms.Psi_1(firms.i,firms.i_lag)      = 1;
firms.Psi_1(firms.P_k,firms.P_k)      = 1;
firms.Psi_1(firms.i_lag,firms.i)      = 1;

% get decision rule
[firms.Dk, firms.Dd1, firms.Dd2, firms.Lambda] = getDecision(firms.Psi_0,firms.Psi_1,firms.nstate);
firms.Dl4=firms.Dd1*[firms.Dd2(1,:);zeros(1,firms.nvar)];
firms.Dl5=firms.Dd1*[zeros(1,firms.nvar);firms.Dd2(2,:)];
lambda_4=firms.Lambda(1,1);
lambda_5=firms.Lambda(2,2);

% i 
%P_1_lambda_4
A0(vrbs.i,vrbs.mu)=A0(firms.i,vrbs.mu)-firms.Dl4(firms.i,1)*params.xi_I;
A0(vrbs.i,vrbs.gamma)=A0(firms.i,vrbs.gamma)-firms.Dl4(firms.i,1)*(params.beta*params.gamma^(1-params.sigma)*params.rho_gamma-1);
A4(vrbs.i,vrbs.mu)=A4(firms.i,vrbs.mu)+firms.Dl4(firms.i,1)/lambda_4*params.xi_I;
A4(vrbs.i,vrbs.gamma)=A4(firms.i,vrbs.gamma)+firms.Dl4(firms.i,1)/lambda_4*(params.beta*params.gamma^(1-params.sigma)*params.rho_gamma-1);
%P_1_lambda_5
A0(vrbs.i,vrbs.mu)=A0(vrbs.i,vrbs.mu)-firms.Dl5(firms.i,1)*params.xi_I;
A0(vrbs.i,vrbs.gamma)=A0(vrbs.i,vrbs.gamma)-firms.Dl5(firms.i,1)*(params.beta*params.gamma^(1-params.sigma)*params.rho_gamma-1);
A5(vrbs.i,vrbs.mu)=A5(vrbs.i,vrbs.mu)+firms.Dl5(firms.i,1)/lambda_5*params.xi_I;
A5(vrbs.i,vrbs.gamma)=A5(vrbs.i,vrbs.gamma)+firms.Dl5(firms.i,1)/lambda_5*(params.beta*params.gamma^(1-params.sigma)*params.rho_gamma-1);
%P_2_lambda_4
A0(vrbs.i,vrbs.R)=A0(vrbs.i,vrbs.R)-firms.Dl4(firms.i,2);
A4(vrbs.i,vrbs.R_k)=A4(vrbs.i,vrbs.R_k)-firms.Dl4(firms.i,2)*(1-params.beta*params.gamma^(-params.sigma)*(1-params.delta));
A4(vrbs.i,vrbs.R)=A4(vrbs.i,vrbs.R)+firms.Dl4(firms.i,2)/lambda_4;
A4(vrbs.i,vrbs.pi)=A4(vrbs.i,vrbs.mu)-firms.Dl4(firms.i,1);
%P_2_lambda_5
A0(vrbs.i,vrbs.R)=A0(vrbs.i,vrbs.R)-firms.Dl5(firms.i,2);
A5(vrbs.i,vrbs.R_k)=A5(vrbs.i,vrbs.R_k)-firms.Dl5(firms.i,2)*(1-params.beta*params.gamma^(-params.sigma)*(1-params.delta));
A5(vrbs.i,vrbs.R)=A5(vrbs.i,vrbs.R)+firms.Dl5(firms.i,2)/lambda_5;
A5(vrbs.i,vrbs.pi)=A5(vrbs.i,vrbs.mu)-firms.Dl5(firms.i,1);

% P_k
%P_1_lambda_4
A0(vrbs.P_k,vrbs.mu)=A0(vrbs.P_k,vrbs.mu)-firms.Dl4(firms.P_k,1)*params.xi_I;
A0(vrbs.P_k,vrbs.gamma)=A0(vrbs.P_k,vrbs.gamma)-firms.Dl4(firms.P_k,1)*(params.beta*params.gamma^(1-params.sigma)*params.rho_gamma-1);
A4(vrbs.P_k,vrbs.mu)=A4(vrbs.P_k,vrbs.mu)+firms.Dl4(firms.P_k,1)/lambda_4*params.xi_I;
A4(vrbs.P_k,vrbs.gamma)=A4(vrbs.P_k,vrbs.gamma)+firms.Dl4(firms.P_k,1)/lambda_4*(params.beta*params.gamma^(1-params.sigma)*params.rho_gamma-1);
%P_1_lambda_5
A0(vrbs.P_k,vrbs.mu)=A0(vrbs.P_k,vrbs.mu)-firms.Dl5(firms.P_k,1)*params.xi_I;
A0(vrbs.P_k,vrbs.gamma)=A0(vrbs.P_k,vrbs.gamma)-firms.Dl5(firms.P_k,1)*(params.beta*params.gamma^(1-params.sigma)*params.rho_gamma-1);
A5(vrbs.P_k,vrbs.mu)=A5(vrbs.P_k,vrbs.mu)+firms.Dl5(firms.P_k,1)/lambda_5*params.xi_I;
A5(vrbs.P_k,vrbs.gamma)=A5(vrbs.P_k,vrbs.gamma)+firms.Dl5(firms.P_k,1)/lambda_5*(params.beta*params.gamma^(1-params.sigma)*params.rho_gamma-1);
%P_2_lambda_4
A0(vrbs.P_k,vrbs.R)=A0(vrbs.P_k,vrbs.R)-firms.Dl4(firms.P_k,2);
A4(vrbs.P_k,vrbs.R_k)=A4(vrbs.P_k,vrbs.R_k)-firms.Dl4(firms.P_k,2)*(1-params.beta*params.gamma^(-params.sigma)*(1-params.delta));
A4(vrbs.P_k,vrbs.R)=A4(vrbs.P_k,vrbs.R)+firms.Dl4(firms.P_k,2)/lambda_4;
A4(vrbs.P_k,vrbs.pi)=A4(vrbs.P_k,vrbs.mu)-firms.Dl4(firms.P_k,1);
%P_2_lambda_5
A0(vrbs.P_k,vrbs.R)=A0(vrbs.P_k,vrbs.R)-firms.Dl5(firms.P_k,2);
A5(vrbs.P_k,vrbs.R_k)=A5(vrbs.P_k,vrbs.R_k)-firms.Dl5(firms.P_k,2)*(1-params.beta*params.gamma^(-params.sigma)*(1-params.delta));
A5(vrbs.P_k,vrbs.R)=A5(vrbs.P_k,vrbs.R)+firms.Dl5(firms.P_k,2)/lambda_5;
A5(vrbs.P_k,vrbs.pi)=A5(vrbs.P_k,vrbs.mu)-firms.Dl5(firms.P_k,1);


%% bonds decision rule
lambda_6=params.rho*params.beta*params.gamma^(1-params.sigma);
A0(vrbs.P_m,vrbs.P_m)=A0(2,vrbs.P_m)+1;
A0(vrbs.P_m,vrbs.R)=A0(2,vrbs.R)+1;
A6(vrbs.P_m,vrbs.R)=-params.rho*params.beta*params.gamma^(params.sigma-1);


%% Firm's decision rule (intermediate inputs)

% calculate gamma 1
a = params.beta*params.gamma^(1-params.sigma);
b = -(params.beta*params.gamma^(1-params.sigma) + 1 + params.xi_p);
c = 1;
gamma_1 = (-b - sqrt(b^2 - 4*a*c))/(2*a);                                               %%% (-b - sprt(b^2 - 4ac))/2a, this is likely to be the value of gamma_1, but we have to check ???
lambda_3 = 1/(params.rho * params.beta * params.gamma^(1-params.sigma));
A0(3, vrbs.pi) = 1 + params.beta * params.gamma^(1-params.sigma) * params.iota_p * (1-gamma_1);
A7(1, vrbs.pi) = params.iota_p;
A0(3, vrbs.w_r) =  - params.xi_p * (1 - params.alpha);
A0(3, vrbs.R_k) =  - params.xi_p * params.alpha;
A0(3, vrbs.theta_p) = 1/(params.theta_p - 1);
A3(1, vrbs.w_r) = params.xi_p*gamma_1*params.beta*params.gamma^(1-params.sigma)*(1-params.alpha);
A3(1, vrbs.R_k) = params.xi_p*gamma_1*params.beta*params.gamma^(1-params.sigma)*params.alpha;
A3(1, vrbs.theta_p) = - params.xi_p*gamma_1*params.beta*params.gamma^(1-params.sigma) /(params.theta_p - 1);
A3(1, vrbs.pi) = params.beta*params.gamma^(1-params.sigma)*(1-gamma_1)*(1-params.iota_p*gamma_1*params.beta*params.gamma^(1-params.sigma));


%% Households
% set number of variables
households.nvar  = 4;
households.nstate= 2;

% assign indices to relevant state variables
households.c       = 1;
households.w_r     = 2;
households.d       = 3;
households.w_r_lag = 4;

c_1w = -(params.xi_v - params.xi_vv)*params.theta_w + 1 + params.xi_w ^ (-1) + params.xi_w^(-1)*params.beta*params.gamma^(1-params.sigma);
c_2w = params.xi_w^(-1)*(1+params.beta*params.gamma^(1-params.sigma)*params.iota_w - params.xi_w*(1-params.b*params.gamma^(-1))^(-1));
c_3w = params.xi_v - params.xi_vv;

% Define Psi_0 and Psi_1 matrices
households.Psi_0 = zeros(households.nvar,households.nvar);
households.Psi_1 = zeros(households.nvar,households.nvar);

households.Psi_0(households.c, households.c)            = params.sigma / (1 - params.b*params.gamma^(-1));
households.Psi_0(households.c,households.w_r)           = params.xi_v * params.theta_w;
households.Psi_0(households.w_r,households.w_r)         = -params.xi_w^(-1) * params.beta*params.gamma^(1-params.sigma);
households.Psi_0(households.w_r_lag,households.w_r_lag) = 1;
households.Psi_0(households.d, households.d)            = 1/params.cy_ratio;

households.Psi_1(households.c, households.c)            = params.sigma / (1 - params.b*params.gamma^(-1));
households.Psi_1(households.c,households.w_r)           = params.xi_v * params.theta_w;
households.Psi_1(households.w_r, households.c)          = params.sigma / (1 - params.b*params.gamma^(-1));
households.Psi_1(households.w_r,households.w_r)         = -c_1w;
households.Psi_1(households.w_r,households.w_r_lag)     = params.xi_w^(-1);
households.Psi_1(households.w_r_lag,households.w_r)     = 1;
households.Psi_1(households.d, households.c)            = -1;
households.Psi_1(households.d, households.w_r)          = params.wc_ratio * (1 - params.theta_w);
households.Psi_1(households.d, households.d)            = params.beta^(-1) * params.gamma^(params.sigma - 1)/params.cy_ratio;

% get decision rule
[households.Dk, households.Dd1,  households.Dd2,  households.Lambda] = getDecision( households.Psi_0, households.Psi_1, households.nstate);
households.Dl1=households.Dd1*[households.Dd2(1,:);zeros(1,households.nvar)];
households.Dl2=households.Dd1*[zeros(1,households.nvar);households.Dd2(2,:)];
lambda_1=households.Lambda(1,1);
lambda_2=households.Lambda(2,2);

%% Contemporaneous terms
%P_1_c 
A0(vrbs.c, vrbs.w_r)   = A0(vrbs.c, vrbs.w_r) + households.Dl1(1,1) * params.xi_v * params.theta_w;
A0(vrbs.c, vrbs.N)     = A0(vrbs.c, vrbs.N) + households.Dl1(1,1) * params.xi_v;
A0(vrbs.c, vrbs.c)     = A0(vrbs.c, vrbs.c) - households.Dl1(1,1) * params.sigma * params.b * params.gamma^(-1) / (1 - params.b * params.gamma^(-1)) * (1 - params.gamma^(-1));
A0(vrbs.c, vrbs.gamma) = A0(vrbs.c, vrbs.gamma) - households.Dl1(1,1) * (params.sigma * (1-params.rho_gamma) / (1 - params.b * params.gamma^(-1)) - params.rho_gamma);
A0(vrbs.c, vrbs.xi)    = A0(vrbs.c, vrbs.xi) - households.Dl1(1,1) * (params.rho_xi - 1);
A7(vrbs.c, vrbs.c)     = A0(vrbs.c, vrbs.c) + households.Dl1(1,1) * (params.sigma * params.b * params.gamma^(-1) / (1 - params.b * params.gamma^(-1))); 

%P_2_c
A0(vrbs.c, vrbs.w_r)   = A0(vrbs.c, vrbs.w_r) + households.Dl1(1,2) * c_3w * params.theta_w;
A0(vrbs.c, vrbs.N)     = A0(vrbs.c, vrbs.N) + households.Dl1(1,2) * c_3w * params.theta_w;
A0(vrbs.c, vrbs.pi)    = A0(vrbs.c, vrbs.pi) + households.Dl1(1,2) * (params.xi_w^(-1) * (1+params.beta*params.gamma^(1-params.sigma)*params.iota_w) - lambda_1^(-1) * params.xi_w^(-1) * params.iota_w);
A0(vrbs.c, vrbs.gamma) = A0(vrbs.c, vrbs.gamma) + households.Dl1(1,2) * (c_2w - params.xi_w^(-1) * params.beta * params.gamma^(1-params.sigma) * params.rho_gamma - lambda_1^(-1) * params.xi_w^(-1) * params.iota_w);
A0(vrbs.c, vrbs.pi)    = A0(vrbs.c, vrbs.pi) + households.Dl1(1,2) / (params.theta_w - 1);
A0(vrbs.c, vrbs.c)     = A0(vrbs.c, vrbs.c) + households.Dl1(1,2) * lambda_1^(-1) * params.b * params.gamma^(-1) / (1-params.b*params.gamma^(-1));
A7(vrbs.c, vrbs.c)     = A7(vrbs.c, vrbs.c) - households.Dl1(1,2) * params.b * params.gamma^(-1) / (1-params.b*params.gamma^(-1));
A7(vrbs.c, vrbs.pi)    = A7(vrbs.c, vrbs.pi) - households.Dl1(1,2) * params.xi_w ^(-1) * params.iota_w;
A7(vrbs.c, vrbs.gamma) = A7(vrbs.c, vrbs.gamma) - households.Dl1(1,2) * params.xi_w ^(-1) * params.iota_w;

%P_3_c
A0(vrbs.c, vrbs.w_r)   = A0(vrbs.c, vrbs.w_r) + households.Dl2(1,1) * params.xi_v * params.theta_w;
A0(vrbs.c, vrbs.N)     = A0(vrbs.c, vrbs.N) + households.Dl2(1,1) * params.xi_v;
A0(vrbs.c, vrbs.c)     = A0(vrbs.c, vrbs.c) - households.Dl2(1,1) * params.sigma * params.b * params.gamma^(-1) / (1 - params.b * params.gamma^(-1)) * (1 - params.gamma^(-1));
A0(vrbs.c, vrbs.gamma) = A0(vrbs.c, vrbs.gamma) - households.Dl2(1,1) * (params.sigma * (1-params.rho_gamma) / (1 - params.b * params.gamma^(-1)) - params.rho_gamma);
A0(vrbs.c, vrbs.xi)    = A0(vrbs.c, vrbs.xi) - households.Dl2(1,1) * (params.rho_xi - 1);
A7(vrbs.c, vrbs.c)     = A0(vrbs.c, vrbs.c) + households.Dl2(1,1) * (params.sigma * params.b * params.gamma^(-1) / (1 - params.b * params.gamma^(-1))); 

%P_4_c
A0(vrbs.c, vrbs.w_r)   = A0(vrbs.c, vrbs.w_r) + households.Dl2(1,2) * c_3w * params.theta_w;
A0(vrbs.c, vrbs.N)     = A0(vrbs.c, vrbs.N) + households.Dl2(1,2) * c_3w * params.theta_w;
A0(vrbs.c, vrbs.pi)    = A0(vrbs.c, vrbs.pi) + households.Dl2(1,2) * (params.xi_w^(-1) * (1+params.beta*params.gamma^(1-params.sigma)*params.iota_w) - lambda_1^(-1) * params.xi_w^(-1) * params.iota_w);
A0(vrbs.c, vrbs.gamma) = A0(vrbs.c, vrbs.gamma) + households.Dl2(1,2) * (c_2w - params.xi_w^(-1) * params.beta * params.gamma^(1-params.sigma) * params.rho_gamma - lambda_1^(-1) * params.xi_w^(-1) * params.iota_w);
A0(vrbs.c, vrbs.pi)    = A0(vrbs.c, vrbs.pi) + households.Dl2(1,2) / (params.theta_w - 1);
A0(vrbs.c, vrbs.c)     = A0(vrbs.c, vrbs.c) + households.Dl2(1,2) * lambda_1^(-1) * params.b * params.gamma^(-1) / (1-params.b*params.gamma^(-1));
A7(vrbs.c, vrbs.c)     = A7(vrbs.c, vrbs.c) - households.Dl2(1,2) * params.b * params.gamma^(-1) / (1-params.b*params.gamma^(-1));
A7(vrbs.c, vrbs.pi)    = A7(vrbs.c, vrbs.pi) - households.Dl2(1,2) * params.xi_w ^(-1) * params.iota_w;
A7(vrbs.c, vrbs.gamma) = A7(vrbs.c, vrbs.gamma) - households.Dl2(1,2) * params.xi_w ^(-1) * params.iota_w;

%P_5_c
A0(vrbs.c, vrbs.R)     = A0(vrbs.c, vrbs.R) - households.Dl2(1,3) * params.beta^(-1) * params.gamma^(params.sigma - 1) * params.by_ratio / params.cy_ratio;
A0(vrbs.c, vrbs.pi)    = A0(vrbs.c, vrbs.pi) + households.Dl2(1,3) * params.beta^(-1) * params.gamma^(params.sigma - 1) * params.by_ratio / params.cy_ratio;
A0(vrbs.c, vrbs.gamma) = A0(vrbs.c, vrbs.gamma) + households.Dl2(1,3) * params.beta^(-1) * params.gamma^(params.sigma - 1) * params.by_ratio / params.cy_ratio;
A0(vrbs.c, vrbs.w_r)   = A0(vrbs.c, vrbs.w_r) + households.Dl2(1,3) * params.w_r * params.N / params.c * params.theta_w;
A0(vrbs.c, vrbs.N)     = A0(vrbs.c, vrbs.N) + households.Dl2(1,3) * params.w_r * params.N / params.c;
A0(vrbs.c, vrbs.Gamma) = A0(vrbs.c, vrbs.Gamma) - households.Dl2(1,3)/params.cy_ratio;
A0(vrbs.c, vrbs.tau)   = A0(vrbs.c, vrbs.tau) + households.Dl2(1,3)/params.cy_ratio;

%P_6_c
A0(vrbs.c, vrbs.R)     = A0(vrbs.c, vrbs.R) - households.Dl1(1,3) * params.beta^(-1) * params.gamma^(params.sigma - 1) * params.by_ratio / params.cy_ratio;
A0(vrbs.c, vrbs.pi)    = A0(vrbs.c, vrbs.pi) + households.Dl1(1,3) * params.beta^(-1) * params.gamma^(params.sigma - 1) * params.by_ratio / params.cy_ratio;
A0(vrbs.c, vrbs.gamma) = A0(vrbs.c, vrbs.gamma) + households.Dl1(1,3) * params.beta^(-1) * params.gamma^(params.sigma - 1) * params.by_ratio / params.cy_ratio;
A0(vrbs.c, vrbs.w_r)   = A0(vrbs.c, vrbs.w_r) + households.Dl1(1,3) * params.w_r * params.N / params.c * params.theta_w;
A0(vrbs.c, vrbs.N)     = A0(vrbs.c, vrbs.N) + households.Dl1(1,3) * params.w_r * params.N / params.c;
A0(vrbs.c, vrbs.Gamma) = A0(vrbs.c, vrbs.Gamma) - households.Dl1(1,3)/params.cy_ratio;
A0(vrbs.c, vrbs.tau)   = A0(vrbs.c, vrbs.tau) + households.Dl1(1,3)/params.cy_ratio;

%P_1_w_r
A0(vrbs.w_r, vrbs.w_r)   = A0(vrbs.w_r, vrbs.w_r) + households.Dl1(2,1) * params.xi_v * params.theta_w;
A0(vrbs.w_r, vrbs.N)     = A0(vrbs.w_r, vrbs.N) + households.Dl1(2,1) * params.xi_v;
A0(vrbs.w_r, vrbs.c)     = A0(vrbs.w_r, vrbs.c) - households.Dl1(2,1) * params.sigma * params.b * params.gamma^(-1) / (1 - params.b * params.gamma^(-1)) * (1 - params.gamma^(-1));
A0(vrbs.w_r, vrbs.gamma) = A0(vrbs.w_r, vrbs.gamma) - households.Dl1(2,1) * (params.sigma * (1-params.rho_gamma) / (1 - params.b * params.gamma^(-1)) - params.rho_gamma);
A0(vrbs.w_r, vrbs.xi)    = A0(vrbs.w_r, vrbs.xi) - households.Dl1(2,1) * (params.rho_xi - 1);
A7(vrbs.w_r, vrbs.c)     = A0(vrbs.w_r, vrbs.c) + households.Dl1(2,1) * (params.sigma * params.b * params.gamma^(-1) / (1 - params.b * params.gamma^(-1))); 

%P_2_w_r
A0(vrbs.w_r, vrbs.w_r)   = A0(vrbs.w_r, vrbs.w_r) + households.Dl1(2,2) * c_3w * params.theta_w;
A0(vrbs.w_r, vrbs.N)     = A0(vrbs.w_r, vrbs.N) + households.Dl1(2,2) * c_3w * params.theta_w;
A0(vrbs.w_r, vrbs.pi)    = A0(vrbs.w_r, vrbs.pi) + households.Dl1(2,2) * (params.xi_w^(-1) * (1+params.beta*params.gamma^(1-params.sigma)*params.iota_w) - lambda_1^(-1) * params.xi_w^(-1) * params.iota_w);
A0(vrbs.w_r, vrbs.gamma) = A0(vrbs.w_r, vrbs.gamma) + households.Dl1(2,2) * (c_2w - params.xi_w^(-1) * params.beta * params.gamma^(1-params.sigma) * params.rho_gamma - lambda_1^(-1) * params.xi_w^(-1) * params.iota_w);
A0(vrbs.w_r, vrbs.pi)    = A0(vrbs.w_r, vrbs.pi) + households.Dl1(2,2) / (params.theta_w - 1);
A0(vrbs.w_r, vrbs.c)     = A0(vrbs.w_r, vrbs.c) + households.Dl1(2,2) * lambda^(-1) * params.b * params.gamma^(-1) / (1-params.b*params.gamma^(-1));
A7(vrbs.w_r, vrbs.c)     = A7(vrbs.w_r, vrbs.c) - households.Dl1(2,2) * params.b * params.gamma^(-1) / (1-params.b*params.gamma^(-1));
A7(vrbs.w_r, vrbs.pi)    = A7(vrbs.w_r, vrbs.pi) - households.Dl1(2,2) * params.xi_w ^(-1) * params.iota_w;
A7(vrbs.w_r, vrbs.gamma) = A7(vrbs.w_r, vrbs.gamma) - households.Dl1(2,2) * params.xi_w ^(-1) * params.iota_w;

%P_3_w_r
A0(vrbs.w_r, vrbs.w_r)   = A0(vrbs.w_r, vrbs.w_r) + households.Dl2(2,1) * params.xi_v * params.theta_w;
A0(vrbs.w_r, vrbs.N)     = A0(vrbs.w_r, vrbs.N) + households.Dl2(2,1) * params.xi_v;
A0(vrbs.w_r, vrbs.c)     = A0(vrbs.w_r, vrbs.c) - households.Dl2(2,1) * params.sigma * params.b * params.gamma^(-1) / (1 - params.b * params.gamma^(-1)) * (1 - params.gamma^(-1));
A0(vrbs.w_r, vrbs.gamma) = A0(vrbs.w_r, vrbs.gamma) - households.Dl2(2,1) * (params.sigma * (1-params.rho_gamma) / (1 - params.b * params.gamma^(-1)) - params.rho_gamma);
A0(vrbs.w_r, vrbs.xi)    = A0(vrbs.w_r, vrbs.xi) - households.Dl2(2,1) * (params.rho_xi - 1);
A7(vrbs.w_r, vrbs.c)     = A0(vrbs.w_r, vrbs.c) + households.Dl2(2,1) * (params.sigma * params.b * params.gamma^(-1) / (1 - params.b * params.gamma^(-1))); 

%P_4_w_r
A0(vrbs.w_r, vrbs.w_r)   = A0(vrbs.w_r, vrbs.w_r) + households.Dl2(2,2) * c_3w * params.theta_w;
A0(vrbs.w_r, vrbs.N)     = A0(vrbs.w_r, vrbs.N) + households.Dl2(2,2) * c_3w * params.theta_w;
A0(vrbs.w_r, vrbs.pi)    = A0(vrbs.w_r, vrbs.pi) + households.Dl2(2,2) * (params.xi_w^(-1) * (1+params.beta*params.gamma^(1-params.sigma)*params.iota_w) - lambda_1^(-1) * params.xi_w^(-1) * params.iota_w);
A0(vrbs.w_r, vrbs.gamma) = A0(vrbs.w_r, vrbs.gamma) + households.Dl2(2,2) * (c_2w - params.xi_w^(-1) * params.beta * params.gamma^(1-params.sigma) * params.rho_gamma - lambda_1^(-1) * params.xi_w^(-1) * params.iota_w);
A0(vrbs.w_r, vrbs.pi)    = A0(vrbs.w_r, vrbs.pi) + households.Dl2(2,2) / (params.theta_w - 1);
A0(vrbs.w_r, vrbs.c)     = A0(vrbs.w_r, vrbs.c) + households.Dl2(2,2) * lambda^(-1) * params.b * params.gamma^(-1) / (1-params.b*params.gamma^(-1));
A7(vrbs.w_r, vrbs.c)     = A7(vrbs.w_r, vrbs.c) - households.Dl2(2,2) * params.b * params.gamma^(-1) / (1-params.b*params.gamma^(-1));
A7(vrbs.w_r, vrbs.pi)    = A7(vrbs.w_r, vrbs.pi) - households.Dl2(2,2) * params.xi_w ^(-1) * params.iota_w;
A7(vrbs.w_r, vrbs.gamma) = A7(vrbs.w_r,vrbs.gamma) - households.Dl2(2,2) * params.xi_w ^(-1) * params.iota_w;

%P_5_w_r
A0(vrbs.w_r, vrbs.R)     = A0(vrbs.w_r, vrbs.R) - households.Dl2(2,3) * params.beta^(-1) * params.gamma^(params.sigma - 1) * params.by_ratio / params.cy_ratio;
A0(vrbs.w_r, vrbs.pi)    = A0(vrbs.w_r, vrbs.pi) + households.Dl2(2,3) * params.beta^(-1) * params.gamma^(params.sigma - 1) * params.by_ratio / params.cy_ratio;
A0(vrbs.w_r, vrbs.gamma) = A0(vrbs.w_r, vrbs.gamma) + households.Dl2(2,3) * params.beta^(-1) * params.gamma^(params.sigma - 1) * params.by_ratio / params.cy_ratio;
A0(vrbs.w_r, vrbs.w_r)   = A0(vrbs.w_r, vrbs.w_r) + households.Dl2(2,3) * params.w_r * params.N / params.c * params.theta_w;
A0(vrbs.w_r, vrbs.N)     = A0(vrbs.w_r, vrbs.N) + households.Dl2(2,3) * params.w_r * params.N / params.c;
A0(vrbs.w_r, vrbs.Gamma) = A0(vrbs.w_r, vrbs.Gamma) - households.Dl2(2,3)/params.cy_ratio;
A0(vrbs.w_r, vrbs.tau)   = A0(vrbs.w_r, vrbs.tau) + households.Dl2(2,3)/params.cy_ratio;

%P_6_w_r
A0(vrbs.w_r, vrbs.R)     = A0(vrbs.w_r, vrbs.R) - households.Dl1(2,3) * params.beta^(-1) * params.gamma^(params.sigma - 1) * params.by_ratio / params.cy_ratio;
A0(vrbs.w_r, vrbs.pi)    = A0(vrbs.w_r, vrbs.pi) + households.Dl1(2,3) * params.beta^(-1) * params.gamma^(params.sigma - 1) * params.by_ratio / params.cy_ratio;
A0(vrbs.w_r, vrbs.gamma) = A0(vrbs.w_r, vrbs.gamma) + households.Dl1(2,3) * params.beta^(-1) * params.gamma^(params.sigma - 1) * params.by_ratio / params.cy_ratio;
A0(vrbs.w_r, vrbs.w_r)   = A0(vrbs.w_r, vrbs.w_r) + households.Dl1(2,3) * params.w_r * params.N / params.c * params.theta_w;
A0(vrbs.w_r, vrbs.N)     = A0(vrbs.w_r, vrbs.N) + households.Dl1(2,3) * params.w_r * params.N / params.c;
A0(vrbs.w_r, vrbs.Gamma) = A0(vrbs.w_r, vrbs.Gamma) - households.Dl1(2,3)/params.cy_ratio;
A0(vrbs.w_r, vrbs.tau)   = A0(vrbs.w_r, vrbs.tau) + households.Dl1(2,3)/params.cy_ratio;

%% Discounted forecasts
% c
%P_1_lambda1
A1(vrbs.c, vrbs.c) = A1(vrbs.c, vrbs.c) + households.Dl1(1,1)*params.sigma*params.b*params.gamma^(-1)*lambda_1*(1-lambda^(-1))/(1-params.b*params.gamma^(-1));
A1(vrbs.c, vrbs.gamma) = A1(vrbs.c, vrbs.gamma) + households.Dl1(1,1)*lambda_1^(-1)*params.sigma*((1-params.rho)/(1-params.b*params.gamma^(-1)) - params.rho.gamma);
A1(vrbs.c, vrbs.R) = A1(vrbs.c, vrbs.R) + households.Dl1(1,1);
A1(vrbs.c, vrbs.pi) = A1(vrbs.c, vrbs.pi) - households.Dl1(1,1);
A1(vrbs.c, vrbs.w_r) = A1(vrbs.c, vrbs.w_r) + households.Dl1(1,1)*params.xi_v*params.theta_w*(1-lambda_1^(-1));
A1(vrbs.c, vrbs.N) = A1(vrbs.c, vrbs.N) + households.Dl1(1,1)*(1-lambda^(-1))*params.xi_v;
A1(vrbs.c, vrbs.xi) = A1(vrbs.c, vrbs.xi) + households.Dl1(1,1)*lambda^(-1)*(params.rho_xi - 1);

%P_2_lambda1
A1(vrbs.c, vrbs.w_r) = A1(vrbs.c, vrbs.w_r) - households.Dl1(1,2)*lambda_1^(-1)*c_3w;
A1(vrbs.c, vrbs.N) = A1(vrbs.c, vrbs.N) - households.Dl1(1,2)*lambda_1^(-1)*c_3w;
A1(vrbs.c, vrbs.c) = A1(vrbs.c, vrbs.c) - households.Dl1(1,2)*lambda_1^(-2)*params.b*params.gamma^(-1)/(1-params.b*params.gamma^(-1));
A1(vrbs.c, vrbs.pi) = A1(vrbs.c, vrbs.pi) - households.Dl1(1,2)*(lambda_1^(-1)*params.xi_w^(-1)*(1+params.beta*params.gamma^(1-params.sigma)*params.iota_w) - lambda_1^(-2)*params.xi_w^(-1)*params.iota_w - params.xi_w^(-1)*params.beta*params^(1-params.sigma));
A1(vrbs.c, vrbs.gamma) = A1(vrbs.c, vrbs.gamma) - households.Dl1(1,2) * (lambda_1^(-1) * (c_2w - params.xi_w^(-1)*params.beta*params.gamma^(1-params.sigma)*params.rho_gamma) - lambda_1^(-2)*params.xi_w^(-1)*params.iota_w);
A1(vrbs.c, vrbs.theta_w) = A1(vrbs.c, vrbs.theta_w) - households.Dl1(1,2) * lambda_1 ^(-1)/(params.theta_w-1);

%P_3_lambda1
A0(vrbs.c, vrbs.R) = A0(vrbs.c, vrbs.R) + households.Dl1(1,3)*params.beta^(-1)*params.gamma^(params.sigma-1)*params.by_ratio*params.cy_ratio;
A0(vrbs.c, vrbs.pi) = A0(vrbs.c, vrbs.pi) -  households.Dl1(1,3)*params.beta^(-1)*params.gamma^(params.sigma-1)*params.by_ratio*params.cy_ratio;
A0(vrbs.c, vrbs.gamma) = A0(vrbs.c, vrbs.gamma) -  households.Dl1(1,3)*params.beta^(-1)*params.gamma^(params.sigma-1)*params.by_ratio*params.cy_ratio;
A0(vrbs.c, vrbs.w_r) = A0(vrbs.c, vrbs.w_r) + households.Dl1(1,3)*params.w_r*params.N/params.c*params.theta_w;
A0(vrbs.c, vrbs.N) = A0(vrbs.c, vrbs.N) + households.Dl1(1,3) * params.w_r*params.N/params.c;
A0(vrbs.c, vrbs.Gamma) = A0(vrbs.c, vrbs.Gamma) + households.Dl1(1,3) /params.cy_ratio;
A0(vrbs.c, vrbs.tau) = A0(vrbs.c, vrbs.tau) - households.Dl1(1,3) /params.cy_ratio;

A1(vrbs.c, vrbs.R) = A1(vrbs.c, vrbs.R) + households.Dl1(1,3)*params.beta^(-1)*params.gamma^(params.sigma-1)*params.by_ratio*params.cy_ratio;
A1(vrbs.c, vrbs.pi) = A1(vrbs.c, vrbs.pi) -  households.Dl1(1,3)*params.beta^(-1)*params.gamma^(params.sigma-1)*params.by_ratio*params.cy_ratio;
A1(vrbs.c, vrbs.gamma) = A1(vrbs.c, vrbs.gamma) -  households.Dl1(1,3)*params.beta^(-1)*params.gamma^(params.sigma-1)*params.by_ratio*params.cy_ratio;
A1(vrbs.c, vrbs.w_r) = A1(vrbs.c, vrbs.w_r) + households.Dl1(1,3)*params.w_r*params.N/params.c*params.theta_w;
A1(vrbs.c, vrbs.N) = A1(vrbs.c, vrbs.N) + households.Dl1(1,3) * params.w_r*params.N/params.c;
A1(vrbs.c, vrbs.Gamma) = A1(vrbs.c, vrbs.Gamma) + households.Dl1(1,3) /params.cy_ratio;
A1(vrbs.c, vrbs.tau) = A1(vrbs.c, vrbs.tau) - households.Dl1(1,3) /params.cy_ratio;

%P_1_lambda2
A2(vrbs.c, vrbs.c) = A2(vrbs.c, vrbs.c) + households.Dl1(1,1)*params.sigma*params.b*params.gamma^(-1)*lambda_2*(1-lambda^(-1))/(1-params.b*params.gamma^(-1));
A2(vrbs.c, vrbs.gamma) = A2(vrbs.c, vrbs.gamma) + households.Dl1(1,1)*lambda_2^(-1)*params.sigma*((1-params.rho)/(1-params.b*params.gamma^(-1)) - params.rho.gamma);
A2(vrbs.c, vrbs.R) = A2(vrbs.c, vrbs.R) + households.Dl1(1,1);
A2(vrbs.c, vrbs.pi) = A2(vrbs.c, vrbs.pi) - households.Dl1(1,1);
A2(vrbs.c, vrbs.w_r) = A2(vrbs.c, vrbs.w_r) + households.Dl1(1,1)*params.xi_v*params.theta_w*(1-lambda_2^(-1));
A2(vrbs.c, vrbs.N) = A2(vrbs.c, vrbs.N) + households.Dl1(1,1)*(1-lambda_2^(-1))*params.xi_v;
A2(vrbs.c, vrbs.xi) = A2(vrbs.c, vrbs.xi) + households.Dl1(1,1)*lambda_2^(-1)*(params.rho_xi - 1);

%P_2_lambda2
A2(vrbs.c, vrbs.w_r) = A2(vrbs.c, vrbs.w_r) - households.Dl1(1,2)*lambda_2^(-1)*c_3w;
A2(vrbs.c, vrbs.N) = A2(vrbs.c, vrbs.N) - households.Dl1(1,2)*lambda_2^(-1)*c_3w;
A2(vrbs.c, vrbs.c) = A2(vrbs.c, vrbs.c) - households.Dl1(1,2)*lambda_2^(-2)*params.b*params.gamma^(-1)/(1-params.b*params.gamma^(-1));
A2(vrbs.c, vrbs.pi) = A2(vrbs.c, vrbs.pi) - households.Dl1(1,2)*(lambda_2^(-1)*params.xi_w^(-1)*(1+params.beta*params.gamma^(1-params.sigma)*params.iota_w) - lambda_2^(-2)*params.xi_w^(-1)*params.iota_w - params.xi_w^(-1)*params.beta*params^(1-params.sigma));
A2(vrbs.c, vrbs.gamma) = A2(vrbs.c, vrbs.gamma) - households.Dl1(1,2) * (lambda_2^(-1) * (c_2w - params.xi_w^(-1)*params.beta*params.gamma^(1-params.sigma)*params.rho_gamma) - lambda_2^(-2)*params.xi_w^(-1)*params.iota_w);
A2(vrbs.c, vrbs.theta_w) = A2(vrbs.c, vrbs.theta_w) - households.Dl1(1,2) * lambda_2 ^(-1)/(params.theta_w-1);

%P_3_lambda2
A2(vrbs.c, vrbs.R) = A2(vrbs.c, vrbs.R) + households.Dl1(1,3)*params.beta^(-1)*params.gamma^(params.sigma-1)*params.by_ratio*params.cy_ratio;
A2(vrbs.c, vrbs.pi) = A2(vrbs.c, vrbs.pi) -  households.Dl1(1,3)*params.beta^(-1)*params.gamma^(params.sigma-1)*params.by_ratio*params.cy_ratio;
A2(vrbs.c, vrbs.gamma) = A2(vrbs.c, vrbs.gamma) -  households.Dl1(1,3)*params.beta^(-1)*params.gamma^(params.sigma-1)*params.by_ratio*params.cy_ratio;
A2(vrbs.c, vrbs.w_r) = A2(vrbs.c, vrbs.w_r) + households.Dl1(1,3)*params.w_r*params.N/params.c*params.theta_w;
A2(vrbs.c, vrbs.N) = A2(vrbs.c, vrbs.N) + households.Dl1(1,3) * params.w_r*params.N/params.c;
A2(vrbs.c, vrbs.Gamma) = A2(vrbs.c, vrbs.Gamma) + households.Dl1(1,3) /params.cy_ratio;
A2(vrbs.c, vrbs.tau) = A2(vrbs.c, vrbs.tau) - households.Dl1(1,3) /params.cy_ratio;

% w_r
%P_1_lambda1
A1(vrbs.w_r, vrbs.c) = A1(vrbs.w_r, vrbs.c) + households.Dl1(1,1)*params.sigma*params.b*params.gamma^(-1)*lambda_1*(1-lambda^(-1))/(1-params.b*params.gamma^(-1));
A1(vrbs.w_r, vrbs.gamma) = A1(vrbs.w_r, vrbs.gamma) + households.Dl1(1,1)*lambda_1^(-1)*params.sigma*((1-params.rho)/(1-params.b*params.gamma^(-1)) - params.rho.gamma);
A1(vrbs.w_r, vrbs.R) = A1(vrbs.w_r, vrbs.R) + households.Dl1(1,1);
A1(vrbs.w_r, vrbs.pi) = A1(vrbs.w_r, vrbs.pi) - households.Dl1(1,1);
A1(vrbs.w_r, vrbs.w_r) = A1(vrbs.w_r, vrbs.w_r) + households.Dl1(1,1)*params.xi_v*params.theta_w*(1-lambda_1^(-1));
A1(vrbs.w_r, vrbs.N) = A1(vrbs.w_r, vrbs.N) + households.Dl1(1,1)*(1-lambda^(-1))*params.xi_v;
A1(vrbs.w_r, vrbs.xi) = A1(vrbs.w_r, vrbs.xi) + households.Dl1(1,1)*lambda^(-1)*(params.rho_xi - 1);

%P_2_lambda1
A1(vrbs.w_r, vrbs.w_r) = A1(vrbs.w_r, vrbs.w_r) - households.Dl1(1,2)*lambda_1^(-1)*c_3w;
A1(vrbs.w_r, vrbs.N) = A1(vrbs.w_r, vrbs.N) - households.Dl1(1,2)*lambda_1^(-1)*c_3w;
A1(vrbs.w_r, vrbs.c) = A1(vrbs.w_r, vrbs.c) - households.Dl1(1,2)*lambda_1^(-2)*params.b*params.gamma^(-1)/(1-params.b*params.gamma^(-1));
A1(vrbs.w_r, vrbs.pi) = A1(vrbs.w_r, vrbs.pi) - households.Dl1(1,2)*(lambda_1^(-1)*params.xi_w^(-1)*(1+params.beta*params.gamma^(1-params.sigma)*params.iota_w) - lambda_1^(-2)*params.xi_w^(-1)*params.iota_w - params.xi_w^(-1)*params.beta*params^(1-params.sigma));
A1(vrbs.w_r, vrbs.gamma) = A1(vrbs.w_r, vrbs.gamma) - households.Dl1(1,2) * (lambda_1^(-1) * (c_2w - params.xi_w^(-1)*params.beta*params.gamma^(1-params.sigma)*params.rho_gamma) - lambda_1^(-2)*params.xi_w^(-1)*params.iota_w);
A1(vrbs.w_r, vrbs.theta_w) = A1(vrbs.w_r, vrbs.theta_w) - households.Dl1(1,2) * lambda_1 ^(-1)/(params.theta_w-1);

%P_3_lambda1
A0(vrbs.w_r, vrbs.R) = A0(vrbs.w_r, vrbs.R) + households.Dl1(1,3)*params.beta^(-1)*params.gamma^(params.sigma-1)*params.by_ratio*params.cy_ratio;
A0(vrbs.w_r, vrbs.pi) = A0(vrbs.w_r, vrbs.pi) -  households.Dl1(1,3)*params.beta^(-1)*params.gamma^(params.sigma-1)*params.by_ratio*params.cy_ratio;
A0(vrbs.w_r, vrbs.gamma) = A0(vrbs.w_r, vrbs.gamma) -  households.Dl1(1,3)*params.beta^(-1)*params.gamma^(params.sigma-1)*params.by_ratio*params.cy_ratio;
A0(vrbs.w_r, vrbs.w_r) = A0(vrbs.w_r, vrbs.w_r) + households.Dl1(1,3)*params.w_r*params.N/params.c*params.theta_w;
A0(vrbs.w_r, vrbs.N) = A0(vrbs.w_r, vrbs.N) + households.Dl1(1,3) * params.w_r*params.N/params.c;
A0(vrbs.w_r, vrbs.Gamma) = A0(vrbs.w_r, vrbs.Gamma) + households.Dl1(1,3) /params.cy_ratio;
A0(vrbs.w_r, vrbs.tau) = A0(vrbs.w_r, vrbs.tau) - households.Dl1(1,3) /params.cy_ratio;

A1(vrbs.w_r, vrbs.R) = A1(vrbs.w_r, vrbs.R) + households.Dl1(1,3)*params.beta^(-1)*params.gamma^(params.sigma-1)*params.by_ratio*params.cy_ratio;
A1(vrbs.w_r, vrbs.pi) = A1(vrbs.w_r, vrbs.pi) -  households.Dl1(1,3)*params.beta^(-1)*params.gamma^(params.sigma-1)*params.by_ratio*params.cy_ratio;
A1(vrbs.w_r, vrbs.gamma) = A1(vrbs.w_r, vrbs.gamma) -  households.Dl1(1,3)*params.beta^(-1)*params.gamma^(params.sigma-1)*params.by_ratio*params.cy_ratio;
A1(vrbs.w_r, vrbs.w_r) = A1(vrbs.w_r, vrbs.w_r) + households.Dl1(1,3)*params.w_r*params.N/params.c*params.theta_w;
A1(vrbs.w_r, vrbs.N) = A1(vrbs.w_r, vrbs.N) + households.Dl1(1,3) * params.w_r*params.N/params.c;
A1(vrbs.w_r, vrbs.Gamma) = A1(vrbs.w_r, vrbs.Gamma) + households.Dl1(1,3) /params.cy_ratio;
A1(vrbs.w_r, vrbs.tau) = A1(vrbs.w_r, vrbs.tau) - households.Dl1(1,3) /params.cy_ratio;

%P_1_lambda2
A2(vrbs.w_r, vrbs.c) = A2(vrbs.w_r, vrbs.c) + households.Dl1(1,1)*params.sigma*params.b*params.gamma^(-1)*lambda_2*(1-lambda^(-1))/(1-params.b*params.gamma^(-1));
A2(vrbs.w_r, vrbs.gamma) = A2(vrbs.w_r, vrbs.gamma) + households.Dl1(1,1)*lambda_2^(-1)*params.sigma*((1-params.rho)/(1-params.b*params.gamma^(-1)) - params.rho.gamma);
A2(vrbs.w_r, vrbs.R) = A2(vrbs.w_r, vrbs.R) + households.Dl1(1,1);
A2(vrbs.w_r, vrbs.pi) = A2(vrbs.w_r, vrbs.pi) - households.Dl1(1,1);
A2(vrbs.w_r, vrbs.w_r) = A2(vrbs.w_r, vrbs.w_r) + households.Dl1(1,1)*params.xi_v*params.theta_w*(1-lambda_2^(-1));
A2(vrbs.w_r, vrbs.N) = A2(vrbs.w_r, vrbs.N) + households.Dl1(1,1)*(1-lambda_2^(-1))*params.xi_v;
A2(vrbs.w_r, vrbs.xi) = A2(vrbs.w_r, vrbs.xi) + households.Dl1(1,1)*lambda_2^(-1)*(params.rho_xi - 1);

%P_2_lambda2
A2(vrbs.w_r, vrbs.w_r) = A2(vrbs.w_r, vrbs.w_r) - households.Dl1(1,2)*lambda_2^(-1)*c_3w;
A2(vrbs.w_r, vrbs.N) = A2(vrbs.w_r, vrbs.N) - households.Dl1(1,2)*lambda_2^(-1)*c_3w;
A2(vrbs.w_r, vrbs.c) = A2(vrbs.w_r, vrbs.c) - households.Dl1(1,2)*lambda_2^(-2)*params.b*params.gamma^(-1)/(1-params.b*params.gamma^(-1));
A2(vrbs.w_r, vrbs.pi) = A2(vrbs.w_r, vrbs.pi) - households.Dl1(1,2)*(lambda_2^(-1)*params.xi_w^(-1)*(1+params.beta*params.gamma^(1-params.sigma)*params.iota_w) - lambda_2^(-2)*params.xi_w^(-1)*params.iota_w - params.xi_w^(-1)*params.beta*params^(1-params.sigma));
A2(vrbs.w_r, vrbs.gamma) = A2(vrbs.w_r, vrbs.gamma) - households.Dl1(1,2) * (lambda_2^(-1) * (c_2w - params.xi_w^(-1)*params.beta*params.gamma^(1-params.sigma)*params.rho_gamma) - lambda_2^(-2)*params.xi_w^(-1)*params.iota_w);
A2(vrbs.w_r, vrbs.theta_w) = A2(vrbs.w_r, vrbs.theta_w) - households.Dl1(1,2) * lambda_2 ^(-1)/(params.theta_w-1);

%P_3_lambda2
A2(vrbs.w_r, vrbs.R) = A2(vrbs.w_r, vrbs.R) + households.Dl1(1,3)*params.beta^(-1)*params.gamma^(params.sigma-1)*params.by_ratio*params.cy_ratio;
A2(vrbs.w_r, vrbs.pi) = A2(vrbs.w_r, vrbs.pi) -  households.Dl1(1,3)*params.beta^(-1)*params.gamma^(params.sigma-1)*params.by_ratio*params.cy_ratio;
A2(vrbs.w_r, vrbs.gamma) = A2(vrbs.w_r, vrbs.gamma) -  households.Dl1(1,3)*params.beta^(-1)*params.gamma^(params.sigma-1)*params.by_ratio*params.cy_ratio;
A2(vrbs.w_r, vrbs.w_r) = A2(vrbs.w_r, vrbs.w_r) + households.Dl1(1,3)*params.w_r*params.N/params.c*params.theta_w;
A2(vrbs.w_r, vrbs.N) = A2(vrbs.w_r, vrbs.N) + households.Dl1(1,3) * params.w_r*params.N/params.c;
A2(vrbs.w_r, vrbs.Gamma) = A2(vrbs.w_r, vrbs.Gamma) + households.Dl1(1,3) /params.cy_ratio;
A2(vrbs.w_r, vrbs.tau) = A2(vrbs.w_r, vrbs.tau) - households.Dl1(1,3) /params.cy_ratio;
