function [vrbs, type, shocks,shocks_oe,ModelDim,estimate] = defineVariables()
% This function outputs the following:
% vrbs: a structure containing the position of all variables (with jump
% variables ordered before state variables)
% nvar: the total number of variables (size of vrbs)
% nstate: the number of state variables

% jump variables
vrbs.N     = 1            ;  type.N     = 'jump';               estimate.N     = 1;  
vrbs.R_k   = 2            ;  type.R_k   = 'jump';               estimate.R_k   = 1;              
vrbs.P_m   = 3            ;  type.P_m   = 'jump';               estimate.P_m   = 0; 
vrbs.Gamma = 4            ;  type.Gamma = 'jump';               estimate.Gamma = 1; 
vrbs.P_k   = 5            ;  type.P_k   = 'jump';               estimate.P_k   = 0; 

% Natural rates

vrbs.N_star     = 6      ;  type.N_star     = 'jump';               estimate.N_star     = 0;  
vrbs.R_k_star   = 7      ;  type.R_k_star   = 'jump';               estimate.R_k_star   = 0;              
vrbs.r_star     = 8      ;  type.r_star     = 'jump';               estimate.r_star     = 0; 
vrbs.P_k_star   = 9     ;  type.P_k_star   = 'jump';               estimate.P_k_star   = 0; 
vrbs.w_r_star   = 10     ;  type.w_r_star   = 'jump';               estimate.w_r_star   = 0; 

% jump and state variables
vrbs.c     = 11            ;  type.c     = 'jump and state';     estimate.c     = 1; 
vrbs.w_r   = 12            ;  type.w_r   = 'jump and state';     estimate.w_r   = 1; 
vrbs.pi    = 13            ;  type.pi    = 'jump and state';     estimate.pi    = 1; 
vrbs.i     = 14           ;  type.i     = 'jump and state';     estimate.i     = 1; 

vrbs.c_star     = 15      ;  type.c_star     = 'jump and state';     estimate.c_star     = 0; 
vrbs.i_star     = 16      ;  type.i_star     = 'jump and state';     estimate.i_star     = 0; 

vrbs.y     = 17            ;  type.y     = 'jump and state';               estimate.y     = 0; 
vrbs.y_star     = 18     ;  type.y_star     = 'jump and state';           estimate.y_star     = 0; 


njump = 18;

% state variables
vrbs.R             = njump + 1 ;  type.R         = 'state';         estimate.R        = 1; 
vrbs.tau           = njump + 2 ;  type.tau       = 'state';         estimate.tau      = 1; 
vrbs.b_m           = njump + 3 ;  type.b_m       = 'state';         estimate.b_m      = 1; 
vrbs.k             = njump + 4 ;  type.k         = 'state';         estimate.k        = 1; 
vrbs.k_star        = njump + 5 ;  type.k_star    = 'state';         estimate.k_star   = 0; 
vrbs.gamma         = njump + 6 ;  type.gamma     = 'state';         estimate.gamma    = 0; 
vrbs.theta_w       = njump + 7;  type.theta_w    = 'state';         estimate.theta_w  = 0; 
vrbs.mu            = njump + 8;  type.mu         = 'state';         estimate.mu       = 0; 
vrbs.g             = njump + 9;  type.g          = 'state';         estimate.g        = 0; 
vrbs.xi            = njump + 10;  type.xi         = 'state';         estimate.xi       = 0; 
vrbs.pistar        = njump + 11;  type.pistar    = 'state';         estimate.pistar   = 0; 
vrbs.theta_p       = njump + 12;  type.theta_p   = 'state';         estimate.theta_p  = 0; 
vrbs.m             = njump + 13;  type.m         = 'state';         estimate.m        = 0; 
vrbs.tau_shock     = njump + 14;  type.tau_shock = 'state';         estimate.tau_shock= 0; 
vrbs.b_shock       = njump + 15;  type.b_shock   = 'state';         estimate.b_shock  = 0; 
vrbs.a_shock       = njump + 16;  type.a_shock   = 'state';         estimate.a_shock  = 0; 
vrbs.som_shock     = njump + 17;  type.som_shock   = 'state';       estimate.som_shock  = 0; 

% For MA components
vrbs.theta_w_eps   = njump + 18;  type.theta_w_eps = 'state';           estimate.theta_w_eps  = 0; 
vrbs.theta_p_eps   = njump + 19;  type.theta_p_eps = 'state';           estimate.theta_p_eps  = 0; 


% Note: x_lag variables corresponding to 'jump and state' type should be in
% the same order as the x variables
nstates = njump + 19;

vrbs.c_lag     = nstates + 1;  type.c_lag     = 'lag state';     %estimate.c_lag   = 0;
vrbs.w_r_lag   = nstates + 2;  type.w_r_lag   = 'lag state';     %estimate.w_r_lag   = 0;
vrbs.pi_lag    = nstates + 3;  type.pi_lag    = 'lag state';     %estimate.pi_lag   = 0;
vrbs.i_lag     = nstates + 4;  type.i_lag     = 'lag state';     %estimate.i_lag   = 0;

vrbs.c_star_lag     = nstates + 5;  type.c_star_lag     = 'lag state';     %estimate.i_lag   = 0;
vrbs.i_star_lag     = nstates + 6;  type.i_star_lag     = 'lag state';     %estimate.i_lag   = 0;

vrbs.y_lag          = nstates + 7;  type.y_lag        = 'lag state';     %estimate.y_lag   = 0;
vrbs.y_star_lag     = nstates + 8;  type.y_star_lag   = 'lag state';     %estimate.y_lag   = 0;


ModelDim.nstate = 19 + 8;

nlags = nstates + 8;

% Observation shocks
vrbs.oe_wage   = nlags + 1;  type.oe_wage   = 'oe state';         
vrbs.oe_bm   = nlags + 2;  type.oe_bm   = 'oe state';         
vrbs.oe_s   = nlags + 3;  type.oe_s   = 'oe state';

ModelDim.nlag   = 8;

ModelDim.nestimated = 11;

% shocks
shocks.gamma = 1;
shocks.theta_w = 2;
shocks.mu = 3;
shocks.g = 4;
shocks.xi = 5;
shocks.pistar = 6;
shocks.theta_p = 7;
shocks.m = 8;
shocks.tau = 9;
shocks.b = 10;
shocks.a = 11;
shocks.som = 12;
ModelDim.nshock = 12;


% observation shocks
shocks_oe.wage = ModelDim.nshock + 1;
shocks_oe.bm = ModelDim.nshock + 2;
shocks_oe.s = ModelDim.nshock + 3;

ModelDim.noe = 3;

ModelDim.nvar = ModelDim.nstate + njump;

end

