function [A, B, C] = defineREModelv2(vrbs,shocks,ModelDim,params,params_index)

% This function outputs model coefficient matrices A, B and C that will be 
% used in the Reds-Solds algorithm. This defines a set of equilibrium
% conditions in standard canonical form.

% NOTE: mak uo shocks are normalized
nvar = ModelDim.nvar;
nshock = ModelDim.nshock;

[spc,beta, theta_w, sigma, ~, b, xi_w, iota_w, ~, iota_p, alpha, theta_p, xi_a, delta, phi_pi,...
    rho_i, phi_x, phi_dx,~, by_ratio, rho, rho_tau, phi_taul, phi_taux, gamma, gy_ratio, rho_gamma, rho_theta_w, ...
    rho_theta_p, rho_g, rho_xi, rho_pistar, rho_m, rho_mu, rho_tau_hat, rho_b, rho_a,rho_som,phi_theta_w,phi_theta_p, sigma_gamma, sigma_theta_w, ...
    sigma_theta_p, sigma_g, sigma_xi, sigma_pistar, sigma_m, sigma_mu, sigma_tau_hat, sigma_b,sigma_a,sigma_ggam,sigma_som, ~, ...
    ~, P_m, ~, R_K, ik_ratio, ~, ~, ~, ~, yk_ratio, iy_ratio, ~, cy_ratio, ...
    wc_ratio, xi_v, ~, ~, F_y_ratio, xi_p, xi_I, c_1w, c_2w, c_3w] = getparamsv1(params, params_index);




A = zeros(nvar);
B = zeros(nvar);
C = zeros(nvar, nshock);

%% 1. N - Jump 
B(vrbs.N, vrbs.R_k) = (1 + F_y_ratio) * alpha * xi_a^(-1);
B(vrbs.N, vrbs.k) = (1 + F_y_ratio) * alpha;                                      
A(vrbs.N, vrbs.gamma) = (1 + F_y_ratio) * alpha;
A(vrbs.N, vrbs.a_shock) = -(1 + F_y_ratio);
B(vrbs.N, vrbs.N) = (1 + F_y_ratio)*(1-alpha);
B(vrbs.N, vrbs.y) = -1;

%% 2. N_star - Jump 
B(vrbs.N_star, vrbs.R_k_star) = (1 + F_y_ratio) * alpha * xi_a^(-1);
B(vrbs.N_star, vrbs.k_star) = (1 + F_y_ratio) * alpha;                                      
A(vrbs.N_star, vrbs.gamma) = (1 + F_y_ratio) * alpha;
A(vrbs.N_star, vrbs.a_shock) = -(1 + F_y_ratio);
B(vrbs.N_star, vrbs.N_star) = (1 + F_y_ratio)*(1-alpha);
B(vrbs.N_star, vrbs.y_star) = -1;


%% 3. R - State
A(vrbs.R,vrbs.R) = 1;
B(vrbs.R,vrbs.R) = rho_i;

A(vrbs.R,vrbs.pistar) = -(1-rho_i)*(1-phi_pi);
B(vrbs.R,vrbs.pi) = (1-rho_i)*phi_pi; 

B(vrbs.R,vrbs.y) = ((1-rho_i)*phi_x + phi_dx);
B(vrbs.R,vrbs.y_star) = -((1-rho_i)*phi_x + phi_dx);

B(vrbs.R,vrbs.y_lag) = -phi_dx;
B(vrbs.R,vrbs.y_star_lag) = phi_dx;


% B(vrbs.R,vrbs.c) = cy_ratio*((1-rho_i)*phi_x + phi_dx); % this uses the JPT definition of gap
% B(vrbs.R,vrbs.c_star) = -cy_ratio*((1-rho_i)*phi_x + phi_dx);
% 
% B(vrbs.R,vrbs.i) = iy_ratio*((1-rho_i)*phi_x + phi_dx);
% B(vrbs.R,vrbs.i_star) = -iy_ratio*((1-rho_i)*phi_x + phi_dx);
% 
% B(vrbs.R,vrbs.c_lag) = -phi_dx*cy_ratio;
% B(vrbs.R,vrbs.c_star_lag) = phi_dx*cy_ratio;
% 
% B(vrbs.R,vrbs.i_lag) = -phi_dx*iy_ratio;
% B(vrbs.R,vrbs.i_star_lag) = phi_dx*iy_ratio;

A(vrbs.R,vrbs.m) = -1;


%A(vrbs.R,vrbs.g) = -(1-rho_i)*phi_x*gy_ratio;

% B(vrbs.R,vrbs.c_lag) = -(1-rho_i)*phi_x*cy_ratio;
% B(vrbs.R,vrbs.i_lag) = -(1-rho_i)*phi_x*iy_ratio;
%B(vrbs.R,vrbs.g) = -(1-rho_i)*phi_x*gy_ratio;
%A(vrbs.R,vrbs.gamma) = -(1-rho_i)*phi_x;


%% 4. tau - State
A(vrbs.tau,vrbs.tau) = 1;
B(vrbs.tau,vrbs.tau) = rho_tau;
B(vrbs.tau,vrbs.b_m) = (1-rho_tau)*phi_taul*(1+rho*P_m);                            
B(vrbs.tau,vrbs.P_m) = (1-rho_tau)*phi_taul*rho*by_ratio;                        
B(vrbs.tau,vrbs.c) = (1-rho_tau)*phi_taux*cy_ratio;                                   
B(vrbs.tau,vrbs.i) = (1-rho_tau)*phi_taux*iy_ratio;                                  
A(vrbs.tau,vrbs.g) = -(1-rho_tau)*phi_taux*gy_ratio;                                    
B(vrbs.tau,vrbs.c_lag) = -(1-rho_tau)*phi_taux*cy_ratio;                                    
B(vrbs.tau,vrbs.i_lag) = -(1-rho_tau)*phi_taux*iy_ratio;                                   
B(vrbs.tau,vrbs.g) = -(1-rho_tau)*phi_taux*gy_ratio;                                    
A(vrbs.tau,vrbs.gamma) = -(1-rho_tau)*phi_taux;
A(vrbs.tau,vrbs.tau_shock) = -1;

%% 5. R_k - Jump
B(vrbs.R_k, vrbs.R_k) = -(xi_a^(-1) + 1);
B(vrbs.R_k, vrbs.k) = -1;
B(vrbs.R_k, vrbs.N) = 1;
A(vrbs.R_k, vrbs.gamma) = -1;
B(vrbs.R_k, vrbs.w_r) = 1;

%% 6. R_k_star - Jump
B(vrbs.R_k_star, vrbs.R_k_star) = -(xi_a^(-1) + 1);
B(vrbs.R_k_star, vrbs.k_star) = -1;
B(vrbs.R_k_star, vrbs.N_star) = 1;
A(vrbs.R_k_star, vrbs.gamma) = -1;
B(vrbs.R_k_star, vrbs.w_r_star) = 1;

%% 7. P_m - Jump
A(vrbs.P_m, vrbs.P_m) = -rho*beta*gamma^(-sigma);
A(vrbs.P_m, vrbs.R) = 1;
A(vrbs.P_m, vrbs.b_shock) = 1;
B(vrbs.P_m, vrbs.P_m) = -1;

% %% 6. Gamma - Jump
% B(vrbs.Gamma, vrbs.Gamma) = -1;
% B(vrbs.Gamma, vrbs.y) = 1;
% B(vrbs.Gamma, vrbs.N) =   -cy_ratio*wc_ratio;
% B(vrbs.Gamma, vrbs.w_r) = -cy_ratio*wc_ratio;
% B(vrbs.Gamma, vrbs.R_k) = -R_K*gamma^-1/yk_ratio/xi_a;            
% B(vrbs.Gamma, vrbs.i)   = -ik_ratio / yk_ratio;



%% 8b Gamma - Jump (Alternative: using HH budget constraint)
B(vrbs.Gamma, vrbs.Gamma) = cy_ratio^-1;
A(vrbs.Gamma,vrbs.tau) = cy_ratio^-1;
B(vrbs.Gamma, vrbs.N) = wc_ratio;
B(vrbs.Gamma, vrbs.w_r) = wc_ratio;
B(vrbs.Gamma, vrbs.c) = -1;
A(vrbs.Gamma,vrbs.b_m)  =  P_m * cy_ratio^-1;
B(vrbs.Gamma,vrbs.b_m)  =  beta^(-1)*gamma^(sigma - 1)*P_m * cy_ratio^-1;
B(vrbs.Gamma, vrbs.pi) = -beta^(-1)*gamma^(sigma - 1)*by_ratio * cy_ratio^-1;                                                
A(vrbs.Gamma, vrbs.gamma) = beta^(-1)*gamma^(sigma - 1)*by_ratio * cy_ratio^-1;
B(vrbs.Gamma, vrbs.P_m) = (rho/gamma - 1)*by_ratio * cy_ratio^-1;



%% 9. c - Jump
B(vrbs.c, vrbs.N) = -xi_v;
B(vrbs.c, vrbs.c) = sigma*(1+b*gamma^(-1))/(1-b*gamma^(-1));
B(vrbs.c, vrbs.c_lag) = -sigma*b*gamma^(-1)/(1-b*gamma^(-1));
A(vrbs.c, vrbs.R) = -1;
%A(vrbs.c, vrbs.b_shock) = -1;
A(vrbs.c, vrbs.b_shock) = -sigma*(1+b*gamma^(-1))/(1-b*gamma^(-1)); % rescale
A(vrbs.c, vrbs.pi) = 1;
A(vrbs.c, vrbs.gamma) = -sigma*((1-rho_gamma)/(1-b*gamma^(-1)) - rho_gamma);                                  
A(vrbs.c, vrbs.N) = -xi_v;
A(vrbs.c, vrbs.c) = sigma/(1-b*gamma^(-1));                                                                           
A(vrbs.c, vrbs.xi) = -rho_xi + 1;


%% 10. r_star - Jump
B(vrbs.r_star, vrbs.N_star) = -xi_v;
B(vrbs.r_star, vrbs.c_star) = sigma*(1+b*gamma^(-1))/(1-b*gamma^(-1));
B(vrbs.r_star, vrbs.c_star_lag) = -sigma*b*gamma^(-1)/(1-b*gamma^(-1));
B(vrbs.r_star, vrbs.r_star) = 1;

%A(vrbs.r_star, vrbs.b_shock) = -1;
A(vrbs.r_star, vrbs.b_shock) = -sigma*(1+b*gamma^(-1))/(1-b*gamma^(-1)); % rescale

A(vrbs.r_star, vrbs.gamma) = -sigma*((1-rho_gamma)/(1-b*gamma^(-1)) - rho_gamma);                                  
A(vrbs.r_star, vrbs.N_star) = -xi_v;
A(vrbs.r_star, vrbs.c_star) = sigma/(1-b*gamma^(-1));                                                                           
A(vrbs.r_star, vrbs.xi) = -rho_xi + 1;



%% 11. w_r - Jump

% note: these were already defined:
% c_1w = -(xi_v - xi_vv)*theta_w + 1 + xi_w ^ (-1) + xi_w^(-1)*beta*gamma^(1-sigma);
% c_2w = xi_w^(-1)*(1+beta*gamma^(1-sigma)*iota_w - xi_w*(1-b*gamma^(-1))^(-1));
% c_3w = xi_v - xi_vv;

% B(vrbs.w_r, vrbs.w_r) = -theta_w*c_3w-c_1w;
% B(vrbs.w_r, vrbs.N) = -c_3w;
% B(vrbs.w_r, vrbs.c) = 1 /(1-b*gamma^(-1));
% B(vrbs.w_r, vrbs.c_lag) = -(b*gamma^(-1))/(1-b*gamma^(-1));
% B(vrbs.w_r, vrbs.w_r_lag) = xi_w^(-1);
% B(vrbs.w_r, vrbs.pi_lag) = xi_w^(-1) * iota_w;
% B(vrbs.w_r, vrbs.gamma) = xi_w^(-1) * iota_w;                                                                                      
% B(vrbs.w_r, vrbs.pi) = - xi_w^(-1) * (1 + beta*gamma^(1-sigma)*iota_w);
% 
% A(vrbs.w_r, vrbs.w_r) = -xi_w^(-1) * beta * gamma^(1-sigma);
% A(vrbs.w_r, vrbs.pi) = -xi_w^(-1) * beta * gamma^(1-sigma);
% A(vrbs.w_r, vrbs.gamma) = c_2w -xi_w^(-1) * beta * gamma^(1-sigma) * rho_gamma;
% A(vrbs.w_r, vrbs.theta_w) = 1/(theta_w - 1);


% stcw = (1/(theta_w-1))*10 + 1;
% 
% B(vrbs.w_r, vrbs.w_r) = -xi_w*(1/stcw)*(theta_w*c_3w+c_1w);
% B(vrbs.w_r, vrbs.N) = -xi_w*(1/stcw)*c_3w;
% B(vrbs.w_r, vrbs.c) = (xi_w*(1/stcw))/(1-b*gamma^(-1));
% B(vrbs.w_r, vrbs.c_lag) = -xi_w*(1/stcw)*(b*gamma^(-1))/(1-b*gamma^(-1));
% B(vrbs.w_r, vrbs.w_r_lag) = 1;
% B(vrbs.w_r, vrbs.pi_lag) = iota_w;
% B(vrbs.w_r, vrbs.gamma) = iota_w;                                                                                      
% B(vrbs.w_r, vrbs.pi) = -(1 + beta*gamma^(1-sigma)*iota_w);
% 
% A(vrbs.w_r, vrbs.w_r) = -beta * gamma^(1-sigma);
% A(vrbs.w_r, vrbs.pi) = -beta * gamma^(1-sigma);
% A(vrbs.w_r, vrbs.gamma) = xi_w*(1/stcw)*c_2w -beta * gamma^(1-sigma) * rho_gamma;
% A(vrbs.w_r, vrbs.theta_w) = xi_w*(1/stcw)*(theta_w*c_3w+c_1w); % rescaling



B(vrbs.w_r, vrbs.w_r) = -xi_w*(theta_w*c_3w+c_1w);
B(vrbs.w_r, vrbs.N) = -xi_w*c_3w;
B(vrbs.w_r, vrbs.c) = xi_w/(1-b*gamma^(-1));
B(vrbs.w_r, vrbs.c_lag) = -xi_w*(b*gamma^(-1))/(1-b*gamma^(-1));

B(vrbs.w_r, vrbs.w_r_lag) = 1;
B(vrbs.w_r, vrbs.pi_lag) = iota_w;
B(vrbs.w_r, vrbs.gamma) = iota_w;                                                                                      
B(vrbs.w_r, vrbs.pi) = -(1 + beta*gamma^(1-sigma)*iota_w);

A(vrbs.w_r, vrbs.w_r) = -beta * gamma^(1-sigma);
A(vrbs.w_r, vrbs.pi) = -beta * gamma^(1-sigma);
A(vrbs.w_r, vrbs.gamma) = xi_w*c_2w -beta * gamma^(1-sigma) * rho_gamma;
A(vrbs.w_r, vrbs.theta_w) = xi_w*(theta_w*c_3w+c_1w-1); % rescaling


%% 12. w_r_star - Jump

B(vrbs.w_r_star, vrbs.w_r_star) = -(1-alpha);
B(vrbs.w_r_star, vrbs.R_k_star) = -alpha;
A(vrbs.w_r_star, vrbs.a_shock) = -1;

%% 13. c_r_star - Jump

B(vrbs.c_star, vrbs.w_r_star) = -1;
B(vrbs.c_star, vrbs.N_star) = -c_3w;
B(vrbs.c_star, vrbs.c_star) = 1/(1-b*gamma^(-1));
B(vrbs.c_star, vrbs.c_star_lag) = -(b*gamma^(-1))/(1-b*gamma^(-1));
A(vrbs.c_star, vrbs.gamma) = -1/(1-b*gamma^(-1));


%% 14. pi - Jump
% B(vrbs.pi, vrbs.pi) = -1-beta * gamma^(1-sigma)*iota_p;
% B(vrbs.pi, vrbs.w_r) = xi_p * (1 - alpha);
% B(vrbs.pi, vrbs.R_k) = xi_p * alpha;
% A(vrbs.pi, vrbs.a_shock) = xi_p;
% 
% % A(vrbs.pi, vrbs.theta_p) = xi_p/(theta_p - 1);
% A(vrbs.pi, vrbs.theta_p) = (1+beta * gamma^(1-sigma)*iota_p); %rescale
% B(vrbs.pi, vrbs.pi_lag) = iota_p;
% A(vrbs.pi, vrbs.pi) = -beta * gamma^(1-sigma);                                                                            
% % B(vrbs.pi, vrbs.pi) = -beta * gamma^(1-sigma)*iota_p;


%% 14. pi - Jump (Smets and Wouters real rigidities)

stc = (1/(theta_p-1))*10 + 1;

B(vrbs.pi, vrbs.pi) = -1-beta * gamma^(1-sigma)*iota_p;
B(vrbs.pi, vrbs.w_r) = xi_p * (1/stc) *(1 - alpha);
B(vrbs.pi, vrbs.R_k) = xi_p * (1/stc) * alpha;
A(vrbs.pi, vrbs.a_shock) = xi_p * (1/stc);

% A(vrbs.pi, vrbs.theta_p) = xi_p/(theta_p - 1);
A(vrbs.pi, vrbs.theta_p) = (1+beta * gamma^(1-sigma)*iota_p); %rescale
B(vrbs.pi, vrbs.pi_lag) = iota_p;
A(vrbs.pi, vrbs.pi) = -beta * gamma^(1-sigma);                                                                            
% B(vrbs.pi, vrbs.pi) = -beta * gamma^(1-sigma)*iota_p;



%% 15. b_m - State
A(vrbs.b_m, vrbs.b_m) = P_m;
B(vrbs.b_m, vrbs.b_m) = beta^(-1)*gamma^(sigma - 1)*P_m;
B(vrbs.b_m, vrbs.pi) = -beta^(-1)*gamma^(sigma - 1)*by_ratio;                                                
A(vrbs.b_m, vrbs.gamma) = beta^(-1)*gamma^(sigma - 1)*by_ratio;
B(vrbs.b_m, vrbs.P_m) = (rho/gamma - 1)*by_ratio;
A(vrbs.b_m, vrbs.tau) = 1;
%A(vrbs.b_m, vrbs.g) = -gy_ratio;
A(vrbs.b_m, vrbs.g) = -1;

%% 16. k - State
A(vrbs.k,vrbs.k) = 1;
B(vrbs.k,vrbs.k) = (1-delta)*gamma^(-1);
A(vrbs.k,vrbs.gamma) = (1-delta)*gamma^(-1);
%A(vrbs.k,vrbs.mu) = -ik_ratio;
A(vrbs.k,vrbs.mu) = -ik_ratio*xi_I^(-1)*(1+beta*gamma^(1-sigma)); %rescale
B(vrbs.k,vrbs.i) = ik_ratio;

%% 17. k_star - State
A(vrbs.k_star,vrbs.k_star) = 1;
B(vrbs.k_star,vrbs.k_star) = (1-delta)*gamma^(-1);
A(vrbs.k_star,vrbs.gamma) = (1-delta)*gamma^(-1);
%A(vrbs.k_star,vrbs.mu) = -ik_ratio;
A(vrbs.k_star,vrbs.mu) = -ik_ratio*xi_I^(-1)*(1+beta*gamma^(1-sigma)); %rescale
B(vrbs.k_star,vrbs.i_star) = ik_ratio;


%% 18. y - Jump
B(vrbs.y, vrbs.y) = -1;
B(vrbs.y, vrbs.c) = cy_ratio;
B(vrbs.y, vrbs.i) = iy_ratio;
%A(vrbs.y, vrbs.g) = -gy_ratio;
A(vrbs.y, vrbs.g) = -1;
B(vrbs.y, vrbs.R_k) = R_K * gamma^(-1) / yk_ratio * xi_a^(-1);

%% 19. y_star - Jump
B(vrbs.y_star, vrbs.y_star) = -1;
B(vrbs.y_star, vrbs.c_star) = cy_ratio;
B(vrbs.y_star, vrbs.i_star) = iy_ratio;
%A(vrbs.y, vrbs.g) = -gy_ratio;
A(vrbs.y_star, vrbs.g) = -1;
B(vrbs.y_star, vrbs.R_k_star) = R_K * gamma^(-1) / yk_ratio * xi_a^(-1);


%% 20. i - Jump
B(vrbs.i, vrbs.P_k) = -1;
%A(vrbs.i, vrbs.mu) = 1;
A(vrbs.i, vrbs.mu) = xi_I^(-1)*(1+beta*gamma^(1-sigma)); % rescale
B(vrbs.i, vrbs.i) = xi_I^(-1)*(1+beta*gamma^(1-sigma));
B(vrbs.i, vrbs.i_lag) = -xi_I^(-1);
A(vrbs.i, vrbs.gamma) =-xi_I^(-1)*(1-beta*gamma^(1-sigma)*rho_gamma);
A(vrbs.i, vrbs.i) = xi_I^(-1)*beta*gamma^(1-sigma);

%% 21. i_star - Jump
B(vrbs.i_star, vrbs.P_k_star) = -1;
%A(vrbs.i_star, vrbs.mu) = 1;
A(vrbs.i_star, vrbs.mu) = xi_I^(-1)*(1+beta*gamma^(1-sigma)); % rescale;
B(vrbs.i_star, vrbs.i_star) = xi_I^(-1)*(1+beta*gamma^(1-sigma));
B(vrbs.i_star, vrbs.i_star_lag) = -xi_I^(-1);
A(vrbs.i_star, vrbs.gamma) =-xi_I^(-1)*(1-beta*gamma^(1-sigma)*rho_gamma);
A(vrbs.i_star, vrbs.i_star) = xi_I^(-1)*beta*gamma^(1-sigma);


%% 22. P_k - Jump
A(vrbs.P_k, vrbs.R_k) = 1 - beta*gamma^(-sigma)*(1-delta);                                                                
A(vrbs.P_k, vrbs.pi) = 1;
A(vrbs.P_k, vrbs.R) = -1;

% A(vrbs.P_k, vrbs.b_shock) = -1;
A(vrbs.P_k, vrbs.b_shock) = -sigma*(1+b*gamma^(-1))/(1-b*gamma^(-1)); % rescale
 A(vrbs.P_k,vrbs.som_shock) = -1; % shock associated to corporate bonds spreads

A(vrbs.P_k, vrbs.P_k) = beta * gamma^(-sigma)*(1-delta);
B(vrbs.P_k, vrbs.P_k) = 1;

%% 23. P_k_star - Jump
A(vrbs.P_k_star, vrbs.R_k_star) = 1 - beta*gamma^(-sigma)*(1-delta);                                                                
B(vrbs.P_k_star, vrbs.r_star) = 1;

%A(vrbs.P_k_star, vrbs.b_shock) = -1;
A(vrbs.P_k_star, vrbs.b_shock) = -sigma*(1+b*gamma^(-1))/(1-b*gamma^(-1)); % rescale
A(vrbs.P_k_star,vrbs.som_shock) = -1; % shock associated to corporate bonds spreads

A(vrbs.P_k_star, vrbs.P_k_star) = beta * gamma^(-sigma)*(1-delta);
B(vrbs.P_k_star, vrbs.P_k_star) = 1;

%% SHOCKS %%

%% 24. TFP shock
A(vrbs.gamma,vrbs.gamma) = 1;
B(vrbs.gamma,vrbs.gamma) = rho_gamma;
C(vrbs.gamma,shocks.gamma) = sigma_gamma;

%% 25. labor supply shock
A(vrbs.theta_w,vrbs.theta_w) = 1;
B(vrbs.theta_w,vrbs.theta_w) = rho_theta_w;
B(vrbs.theta_w,vrbs.theta_w_eps) = -phi_theta_w; % MA component
C(vrbs.theta_w,shocks.theta_w) = sigma_theta_w;

%% 26. Investment shock
A(vrbs.mu,vrbs.mu) = 1;
B(vrbs.mu,vrbs.mu) = rho_mu;
C(vrbs.mu,shocks.mu) = sigma_mu;

%% 27. government spending shock
A(vrbs.g,vrbs.g) = 1;
B(vrbs.g,vrbs.g) = rho_g;
C(vrbs.g,shocks.g) = sigma_g;
C(vrbs.g,shocks.a) = sigma_ggam * sigma_a;


%% 28. preferences shock
A(vrbs.xi,vrbs.xi) = 1;
B(vrbs.xi,vrbs.xi) = rho_xi;
C(vrbs.xi,shocks.xi) = sigma_xi;

%% 29. Inflation target shock
A(vrbs.pistar,vrbs.pistar) = 1;
B(vrbs.pistar,vrbs.pistar) = rho_pistar;
C(vrbs.pistar,shocks.pistar) = sigma_pistar;

%% 30. cost-push shock
A(vrbs.theta_p,vrbs.theta_p) = 1;
B(vrbs.theta_p,vrbs.theta_p) = rho_theta_p;
B(vrbs.theta_p,vrbs.theta_p_eps) = -phi_theta_p; % MA component
C(vrbs.theta_p,shocks.theta_p) = sigma_theta_p;

%% 31. policy shock
A(vrbs.m,vrbs.m) = 1;
B(vrbs.m,vrbs.m) = rho_m;
C(vrbs.m,shocks.m) = sigma_m;

%% 32. tax shock
A(vrbs.tau_shock,vrbs.tau_shock) = 1;
B(vrbs.tau_shock,vrbs.tau_shock) = rho_tau_hat;
C(vrbs.tau_shock,shocks.tau) = sigma_tau_hat;

%% 33. b shock
A(vrbs.b_shock,vrbs.b_shock) = 1;
B(vrbs.b_shock,vrbs.b_shock) = rho_b;
C(vrbs.b_shock,shocks.b) = sigma_b;
C(vrbs.b_shock,shocks.mu) = -spc*sigma_mu;


%% 34. a shock
A(vrbs.a_shock,vrbs.a_shock) = 1;
B(vrbs.a_shock,vrbs.a_shock) = rho_a;
C(vrbs.a_shock,shocks.a) = sigma_a;

%% 35. som shock
A(vrbs.som_shock,vrbs.som_shock) = 1;
B(vrbs.som_shock,vrbs.som_shock) = rho_som;
C(vrbs.som_shock,shocks.som) = sigma_som;


%% 36. theta_w innovation (for MA component)
A(vrbs.theta_w_eps,vrbs.theta_w_eps) = 1;
C(vrbs.theta_w_eps,shocks.theta_w) = sigma_theta_w;

%% 37. theta_p innovation (for MA component)
A(vrbs.theta_p_eps,vrbs.theta_p_eps) = 1;
C(vrbs.theta_p_eps,shocks.theta_p) = sigma_theta_p;

%% LAGS %%

%% 38. c_lag
A(vrbs.c_lag, vrbs.c_lag) = 1;
B(vrbs.c_lag, vrbs.c) = 1;

%% 39. w_r_lag
A(vrbs.w_r_lag, vrbs.w_r_lag) = 1;
B(vrbs.w_r_lag, vrbs.w_r) = 1;

%% 40. pi_lag
A(vrbs.pi_lag, vrbs.pi_lag) = 1;
B(vrbs.pi_lag, vrbs.pi) = 1;

%% 41. i_lag
A(vrbs.i_lag, vrbs.i_lag) = 1;
B(vrbs.i_lag, vrbs.i) = 1;

%% 42. c_star_lag
A(vrbs.c_star_lag, vrbs.c_star_lag) = 1;
B(vrbs.c_star_lag, vrbs.c_star) = 1;

%% 43. i_star_lag
A(vrbs.i_star_lag, vrbs.i_star_lag) = 1;
B(vrbs.i_star_lag, vrbs.i_star) = 1;

%% 44. y_lag
A(vrbs.y_lag, vrbs.y_lag) = 1;
B(vrbs.y_lag, vrbs.y) = 1;

%% 45. y_star_lag
A(vrbs.y_star_lag, vrbs.y_star_lag) = 1;
B(vrbs.y_star_lag, vrbs.y_star) = 1;

end

