function [A, B, C] = defineREModel(vrbs,shocks,nvar,nshock,params)

% This function outputs model coefficient matrices A, B and C that will be 
% used in the Reds-Solds algorithm. This defines a set of equilibrium
% conditions in standard canonical form.


A = zeros(nvar);
B = zeros(nvar);
C = zeros(nvar, nshock);

%% 1. N - Jump
B(vrbs.N, vrbs.R_k) = (1 + params.F_y_ratio) * params.alpha * params.xi_a^(-1);
B(vrbs.N, vrbs.k) = (1 + params.F_y_ratio) * params.alpha;                                      
A(vrbs.N, vrbs.gamma) = (1 + params.F_y_ratio) * params.alpha;
B(vrbs.N, vrbs.N) = (1 + params.F_y_ratio)*(1-params.alpha);
B(vrbs.N, vrbs.y) = -1;

%% 2. R - State
A(vrbs.R,vrbs.R) = 1;
B(vrbs.R,vrbs.R) = params.rho_i;
A(vrbs.R,vrbs.pistar) = -(1-params.rho_i)*(1-params.phi_pi);
B(vrbs.R,vrbs.pi) = (1-params.rho_i)*params.phi_pi;                                                        
B(vrbs.R,vrbs.c) = (1-params.rho_i)*params.phi_x*params.cy_ratio;
B(vrbs.R,vrbs.i) = (1-params.rho_i)*params.phi_x*params.iy_ratio;
A(vrbs.R,vrbs.g) = -(1-params.rho_i)*params.phi_x*params.gy_ratio;
B(vrbs.R,vrbs.c_lag) = -(1-params.rho_i)*params.phi_x*params.cy_ratio;
B(vrbs.R,vrbs.i_lag) = -(1-params.rho_i)*params.phi_x*params.iy_ratio;
B(vrbs.R,vrbs.g) = -(1-params.rho_i)*params.phi_x*params.gy_ratio;
A(vrbs.R,vrbs.gamma) = -(1-params.rho_i)*params.phi_x;
A(vrbs.R,vrbs.m) = -1;

%% 3. tau - State
A(vrbs.tau,vrbs.tau) = 1;
B(vrbs.tau,vrbs.tau) = params.rho_tau;
B(vrbs.tau,vrbs.b_m) = (1-params.rho_tau)*params.phi_taul*(1+params.rho*params.P_m);                            
B(vrbs.tau,vrbs.P_m) = (1-params.rho_tau)*params.phi_taul*params.rho*params.by_ratio;                        
B(vrbs.tau,vrbs.c) = (1-params.rho_tau)*params.phi_taux*params.cy_ratio;                                   
B(vrbs.tau,vrbs.i) = (1-params.rho_tau)*params.phi_taux*params.iy_ratio;                                  
A(vrbs.tau,vrbs.g) = -(1-params.rho_tau)*params.phi_taux*params.gy_ratio;                                    
B(vrbs.tau,vrbs.c_lag) = -(1-params.rho_tau)*params.phi_taux*params.cy_ratio;                                    
B(vrbs.tau,vrbs.i_lag) = -(1-params.rho_tau)*params.phi_taux*params.iy_ratio;                                   
B(vrbs.tau,vrbs.g) = -(1-params.rho_tau)*params.phi_taux*params.gy_ratio;                                    
A(vrbs.tau,vrbs.gamma) = -(1-params.rho_tau)*params.phi_taux;
A(vrbs.tau,vrbs.tau_shock) = -1;

%% 4. R_k - Jump
B(vrbs.R_k, vrbs.R_k) = -(params.xi_a^(-1) + 1);
B(vrbs.R_k, vrbs.k) = -1;
B(vrbs.R_k, vrbs.N) = 1;
A(vrbs.R_k, vrbs.gamma) = -1;
B(vrbs.R_k, vrbs.w_r) = 1;

%% 5. P_m - Jump
A(vrbs.P_m, vrbs.P_m) = -params.rho*params.beta*params.gamma^(-params.sigma);
A(vrbs.P_m, vrbs.R) = 1;
B(vrbs.P_m, vrbs.P_m) = -1;

% %% 6. Gamma - Jump
% B(vrbs.Gamma, vrbs.Gamma) = -1;
% B(vrbs.Gamma, vrbs.y) = 1;
% B(vrbs.Gamma, vrbs.N) =   -params.cy_ratio*params.wc_ratio;
% B(vrbs.Gamma, vrbs.w_r) = -params.cy_ratio*params.wc_ratio;
% B(vrbs.Gamma, vrbs.R_k) = -params.R_K*params.gamma^-1/params.yk_ratio/params.xi_a;            
% B(vrbs.Gamma, vrbs.i)   = -params.ik_ratio / params.yk_ratio;



%% 6b Gamma - Jump (Alternative: using HH budget constraint)
B(vrbs.Gamma, vrbs.Gamma) = params.cy_ratio^-1;
A(vrbs.Gamma,vrbs.tau) = params.cy_ratio^-1;
B(vrbs.Gamma, vrbs.N) = params.wc_ratio;
B(vrbs.Gamma, vrbs.w_r) = params.wc_ratio;
B(vrbs.Gamma, vrbs.c) = -1;
A(vrbs.Gamma,vrbs.b_m)  =  params.P_m * params.cy_ratio^-1;
B(vrbs.Gamma,vrbs.b_m)  =  params.beta^(-1)*params.gamma^(params.sigma - 1)*params.P_m * params.cy_ratio^-1;
B(vrbs.Gamma, vrbs.pi) = -params.beta^(-1)*params.gamma^(params.sigma - 1)*params.by_ratio * params.cy_ratio^-1;                                                
A(vrbs.Gamma, vrbs.gamma) = params.beta^(-1)*params.gamma^(params.sigma - 1)*params.by_ratio * params.cy_ratio^-1;
B(vrbs.Gamma, vrbs.P_m) = (params.rho/params.gamma - 1)*params.by_ratio * params.cy_ratio^-1;



%% 7. c - Jump
B(vrbs.c, vrbs.N) = -params.xi_v;
B(vrbs.c, vrbs.c) = params.sigma*(1+params.b*params.gamma^(-1))/(1-params.b*params.gamma^(-1));
B(vrbs.c, vrbs.c_lag) = -params.sigma*params.b*params.gamma^(-1)/(1-params.b*params.gamma^(-1));
% A(vrbs.c, vrbs.P_m) = -params.rho*params.beta*params.gamma^(-params.sigma);
% B(vrbs.c, vrbs.P_m) = -1;
A(vrbs.c, vrbs.R) = -1;
A(vrbs.c, vrbs.pi) = 1;
A(vrbs.c, vrbs.gamma) = -params.sigma*((1-params.rho_gamma)/(1-params.b*params.gamma^(-1)) - params.rho_gamma);                                  
A(vrbs.c, vrbs.N) = -params.xi_v;
A(vrbs.c, vrbs.c) = params.sigma/(1-params.b*params.gamma^(-1));                                                                           
A(vrbs.c, vrbs.xi) = -params.rho_xi + 1;

%% 8. w_r - Jump

% note: these were already defined:
% c_1w = -(params.xi_v - params.xi_vv)*params.theta_w + 1 + params.xi_w ^ (-1) + params.xi_w^(-1)*params.beta*params.gamma^(1-params.sigma);
% c_2w = params.xi_w^(-1)*(1+params.beta*params.gamma^(1-params.sigma)*params.iota_w - params.xi_w*(1-params.b*params.gamma^(-1))^(-1));
% c_3w = params.xi_v - params.xi_vv;

B(vrbs.w_r, vrbs.w_r) = -params.theta_w*params.c_3w-params.c_1w;
B(vrbs.w_r, vrbs.N) = -params.c_3w;
B(vrbs.w_r, vrbs.c) = 1 /(1-params.b*params.gamma^(-1));
B(vrbs.w_r, vrbs.c_lag) = -(params.b*params.gamma^(-1))/(1-params.b*params.gamma^(-1));
B(vrbs.w_r, vrbs.w_r_lag) = params.xi_w^(-1);
B(vrbs.w_r, vrbs.pi_lag) = params.xi_w^(-1) * params.iota_w;
B(vrbs.w_r, vrbs.gamma) = params.xi_w^(-1) * params.iota_w;                                                                                      
B(vrbs.w_r, vrbs.pi) = - params.xi_w^(-1) * (1 + params.beta*params.gamma^(1-params.sigma)*params.iota_w);

A(vrbs.w_r, vrbs.w_r) = -params.xi_w^(-1) * params.beta * params.gamma^(1-params.sigma);
A(vrbs.w_r, vrbs.pi) = -params.xi_w^(-1) * params.beta * params.gamma^(1-params.sigma);
A(vrbs.w_r, vrbs.gamma) = params.c_2w -params.xi_w^(-1) * params.beta * params.gamma^(1-params.sigma) * params.rho_gamma;
A(vrbs.w_r, vrbs.theta_w) = 1/(params.theta_w - 1);

%% 9. pi - Jump
B(vrbs.pi, vrbs.pi) = -1-params.beta * params.gamma^(1-params.sigma)*params.iota_p;
B(vrbs.pi, vrbs.w_r) = params.xi_p * (1 - params.alpha);
B(vrbs.pi, vrbs.R_k) = params.xi_p * params.alpha;
A(vrbs.pi, vrbs.theta_p) = params.xi_p/(params.theta_p - 1);
B(vrbs.pi, vrbs.pi_lag) = params.iota_p;
A(vrbs.pi, vrbs.pi) = -params.beta * params.gamma^(1-params.sigma);                                                                            
% B(vrbs.pi, vrbs.pi) = -params.beta * params.gamma^(1-params.sigma)*params.iota_p;

%% 10. b_m - State
A(vrbs.b_m, vrbs.b_m) = params.P_m;
B(vrbs.b_m, vrbs.b_m) = params.beta^(-1)*params.gamma^(params.sigma - 1)*params.P_m;
B(vrbs.b_m, vrbs.pi) = -params.beta^(-1)*params.gamma^(params.sigma - 1)*params.by_ratio;                                                
A(vrbs.b_m, vrbs.gamma) = params.beta^(-1)*params.gamma^(params.sigma - 1)*params.by_ratio;
B(vrbs.b_m, vrbs.P_m) = (params.rho/params.gamma - 1)*params.by_ratio;
A(vrbs.b_m, vrbs.tau) = 1;
A(vrbs.b_m, vrbs.g) = -params.gy_ratio;

%% 11. k - State
A(vrbs.k,vrbs.k) = 1;
B(vrbs.k,vrbs.k) = (1-params.delta)*params.gamma^(-1);
A(vrbs.k,vrbs.gamma) = (1-params.delta)*params.gamma^(-1);
A(vrbs.k,vrbs.mu) = -params.ik_ratio;
B(vrbs.k,vrbs.i) = params.ik_ratio;

%% 12. y - Jump
B(vrbs.y, vrbs.y) = -1;
B(vrbs.y, vrbs.c) = params.cy_ratio;
B(vrbs.y, vrbs.i) = params.iy_ratio;
A(vrbs.y, vrbs.g) = -params.gy_ratio;                                                                                                  
B(vrbs.y, vrbs.R_k) = params.R_K * params.gamma^(-1) / params.yk_ratio * params.xi_a^(-1);

%% 13. i - Jump
B(vrbs.i, vrbs.P_k) = -1;
A(vrbs.i, vrbs.mu) = 1;
B(vrbs.i, vrbs.i) = params.xi_I^(-1)*(1+params.beta*params.gamma^(1-params.sigma));
B(vrbs.i, vrbs.i_lag) = -params.xi_I^(-1);
A(vrbs.i, vrbs.gamma) =-params.xi_I^(-1)*(1-params.beta*params.gamma^(1-params.sigma)*params.rho_gamma);
A(vrbs.i, vrbs.i) = params.xi_I^(-1)*params.beta*params.gamma^(1-params.sigma);

%% 14. P_k - Jump
A(vrbs.P_k, vrbs.R_k) = 1 - params.beta*params.gamma^(-params.sigma)*(1-params.delta);                                                                
A(vrbs.P_k, vrbs.pi) = 1;
A(vrbs.P_k, vrbs.R) = -1;
A(vrbs.P_k, vrbs.P_k) = params.beta * params.gamma^(-params.sigma)*(1-params.delta);
B(vrbs.P_k, vrbs.P_k) = 1;


%% SHOCKS %%

%% 15. TFP shock
A(vrbs.gamma,vrbs.gamma) = 1;
B(vrbs.gamma,vrbs.gamma) = params.rho_gamma;
C(vrbs.gamma,shocks.gamma) = params.sigma_gamma;

%% 16. labor supply shock
A(vrbs.theta_w,vrbs.theta_w) = 1;
B(vrbs.theta_w,vrbs.theta_w) = params.rho_theta_w;
C(vrbs.theta_w,shocks.theta_w) = params.sigma_theta_w;

%% 17. Investment shock
A(vrbs.mu,vrbs.mu) = 1;
B(vrbs.mu,vrbs.mu) = params.rho_mu;
C(vrbs.mu,shocks.mu) = params.sigma_mu;

%% 18. government spending shock
A(vrbs.g,vrbs.g) = 1;
B(vrbs.g,vrbs.g) = params.rho_g;
C(vrbs.g,shocks.g) = params.sigma_g;

%% 19. preferences shock
A(vrbs.xi,vrbs.xi) = 1;
B(vrbs.xi,vrbs.xi) = params.rho_xi;
C(vrbs.xi,shocks.xi) = params.sigma_xi;

%% 20. Inflation target shock
A(vrbs.pistar,vrbs.pistar) = 1;
B(vrbs.pistar,vrbs.pistar) = params.rho_pistar;
C(vrbs.pistar,shocks.pistar) = params.sigma_pistar;

%% 21. cost-push shock
A(vrbs.theta_p,vrbs.theta_p) = 1;
B(vrbs.theta_p,vrbs.theta_p) = params.rho_theta_p;
C(vrbs.theta_p,shocks.theta_p) = params.sigma_theta_p;

%% 22. policy shock
A(vrbs.m,vrbs.m) = 1;
B(vrbs.m,vrbs.m) = params.rho_m;
C(vrbs.m,shocks.m) = params.sigma_m;

%% 23. tax shock
A(vrbs.tau_shock,vrbs.tau_shock) = 1;
B(vrbs.tau_shock,vrbs.tau_shock) = params.rho_tau_hat;
C(vrbs.tau_shock,shocks.tau) = params.sigma_tau_hat;

%% LAGS %%

%% 24. c_lag
A(vrbs.c_lag, vrbs.c_lag) = 1;
B(vrbs.c_lag, vrbs.c) = 1;

%% 25. w_r_lag
A(vrbs.w_r_lag, vrbs.w_r_lag) = 1;
B(vrbs.w_r_lag, vrbs.w_r) = 1;

%% 26. pi_lag
A(vrbs.pi_lag, vrbs.pi_lag) = 1;
B(vrbs.pi_lag, vrbs.pi) = 1;

%% 27. i_lag
A(vrbs.i_lag, vrbs.i_lag) = 1;
B(vrbs.i_lag, vrbs.i) = 1;

%% 28. y_lag
A(vrbs.y_lag, vrbs.y_lag) = 1;
B(vrbs.y_lag, vrbs.y) = 1;


end

