function [vrbs, type, shocks, nvar, nstate, nshock] = defineModel()
% This function outputs the following:
% vrbs: a structure containing the position of all variables (with jump
% variables ordered before state variables)
% nvar: the total number of variables (size of vrbs)
% nstate: the number of state variables

% jump variables
vrbs.N     = 1            ;  type.N     = 'jump';
vrbs.R_k   = 2            ;  type.R_k   = 'jump';
vrbs.P_m   = 3            ;  type.P_m   = 'jump';
vrbs.Gamma = 4            ;  type.Gamma = 'jump';
vrbs.c     = 5            ;  type.c     = 'jump and state';
vrbs.w_r   = 6            ;  type.w_r   = 'jump and state';
vrbs.pi    = 7            ;  type.pi    = 'jump and state';
vrbs.y     = 8            ;  type.y     = 'jump';
vrbs.i     = 9            ;  type.i     = 'jump and state';
vrbs.P_k   = 10           ;  type.P_k   = 'jump';
njump = 10;

% state variables
vrbs.R         = njump + 1 ;  type.R         = 'state';
vrbs.tau       = njump + 2 ;  type.tau       = 'state';
vrbs.c_lag     = njump + 3 ;  type.c_lag     = 'state';
vrbs.w_r_lag   = njump + 4 ;  type.w_r_lag   = 'state';
vrbs.pi_lag    = njump + 5 ;  type.pi_lag    = 'state';
vrbs.i_lag     = njump + 6 ;  type.i_lag     = 'state';
vrbs.b_m       = njump + 7 ;  type.b_m       = 'state';
vrbs.k         = njump + 8 ;  type.k         = 'state';
vrbs.gamma     = njump + 9 ;  type.gamma     = 'state';
vrbs.theta_w   = njump + 10;  type.theta_w   = 'state';
vrbs.mu        = njump + 11;  type.mu        = 'state';
vrbs.g         = njump + 12;  type.g         = 'state';
vrbs.xi        = njump + 13;  type.xi        = 'state';
vrbs.pistar    = njump + 14;  type.pistar    = 'state';
vrbs.theta_p   = njump + 15;  type.theta_p   = 'state';
vrbs.m         = njump + 16;  type.m         = 'state';
vrbs.tau_shock = njump + 17;  type.tau_shock = 'state';
nstate = 17;

% shocks
shocks.gamma = 1;
shocks.theta_w = 2;
shocks.mu = 3;
shocks.g = 4;
shocks.xi = 5;
shocks.pistar = 6;
shocks.theta_p = 7;
shocks.m = 8;
shocks.tau = 9;
nshock = 9;

nvar = nstate + njump;

end

