
function [F,Sc,Q] = add_to_StateSpace(vrbs,params,params_index,T_Z,T_epsilon,nlag,noe,shocks_oe)


% extend state space with extra lags and observation errors

F = [T_Z, zeros(size(T_Z,1),nlag + noe)
     zeros(nlag+noe,size(T_Z,2)+nlag + noe)];

Sc = [T_epsilon, zeros(size(T_epsilon,1),noe)
      zeros(nlag+noe,size(T_epsilon,2)+ noe)];
      
 
%% c_lag
F(vrbs.c_lag, vrbs.c) = 1;

%% w_r_lag
F(vrbs.w_r_lag, vrbs.w_r) = 1;

%% pi_lag
F(vrbs.pi_lag, vrbs.pi) = 1;

%% i_lag
F(vrbs.i_lag, vrbs.i) = 1;

%% y_lag
F(vrbs.y_lag, vrbs.y) = 1;

%% observation shock on spread

F(vrbs.oe_s,vrbs.oe_s) = params(params_index.rho_oe_s);

Sc(vrbs.oe_s,shocks_oe.s) = params(params_index.sigma_oe_s);

%% observation shock on wage

Sc(vrbs.oe_wage,shocks_oe.wage) = params(params_index.sigma_oe_w);

%% observation shock on gov debt

Sc(vrbs.oe_bm,shocks_oe.bm) = params(params_index.sigma_oe_bm);



Q = Sc*Sc'; 
