function [A, B, C] = REE_Solve(vrbs,shocks,nvar,nshock)
% This function outputs model coefficient matrices A, B and C that will be 
% used in the Reds-Solds algorithm. This defines a set of equilibrium
% conditions in standard canonical form (i.e.,  

param = setParams();

A = zeros(nvar);
B = zeros(nvar);
C = zeros(nvar, nshock);

%% 1. N - Jump
B(vrbs.N, vrbs.R_k) = (1 + param.F_y_ratio) * param.alpha * param.xi_a^(-1);
A(vrbs.N, vrbs.k) = -(1 + param.F_y_ratio) * param.alpha;
A(vrbs.N, vrbs.gamma) = (1 + param.F_y_ratio) * param.alpha;
B(vrbs.N, vrbs.N) = (1 + param.F_y_ratio)*(1-param.alpha);
B(vrbs.N, vrbs.y) = -1;

%% 2. R - State
A(vrbs.R,vrbs.R)=1;
B(vrbs.R,vrbs.R)=param.rho_i;
A(vrbs.R,vrbs.pistar)=-(1-param.rho_i)*(1-param.phi_pi);
B(vrbs.R,vrbs.pi)=(1-param.rho_i)*param.phi_pi;                                                        
B(vrbs.R,vrbs.c)=(1-param.rho_i)*param.phi_x*param.cy_ratio;
B(vrbs.R,vrbs.i)=(1-param.rho_i)*param.phi_x*param.iy_ratio;
A(vrbs.R,vrbs.g)=-(1-param.rho_i)*param.phi_x*param.gy_ratio;
B(vrbs.R,vrbs.c_lag)=-(1-param.rho_i)*param.phi_x*param.cy_ratio;
B(vrbs.R,vrbs.i_lag)=-(1-param.rho_i)*param.phi_x*param.iy_ratio;
B(vrbs.R,vrbs.g)=-(1-param.rho_i)*param.phi_x*param.gy_ratio;
A(vrbs.R,vrbs.gamma)=-(1-param.rho_i)*param.phi_x;
A(vrbs.R,vrbs.m)=-1;

%% 3. tau - State
A(vrbs.tau,vrbs.tau)=1;
B(vrbs.tau,vrbs.tau)=param.rho_i;
B(vrbs.tau,vrbs.b_m)=(1-param.rho_tau)*param.phi_taux*(1+param.rho*param.P_m);                            
B(vrbs.tau,vrbs.P_m)=(1-param.rho_tau)*param.phi_taux*param.rho*param.by_ratio;                        
B(vrbs.tau,vrbs.c)=(1-param.rho_tau)*param.phi_taux*param.cy_ratio;                                   
B(vrbs.tau,vrbs.i)=(1-param.rho_tau)*param.phi_taux*param.iy_ratio;                                  
A(vrbs.tau,vrbs.g)=-(1-param.rho_tau)*param.phi_taux*param.gy_ratio;                                    
B(vrbs.tau,vrbs.c_lag)=-(1-param.rho_tau)*param.phi_taux*param.cy_ratio;                                    
B(vrbs.tau,vrbs.i_lag)=-(1-param.rho_tau)*param.phi_taux*param.iy_ratio;                                   
B(vrbs.tau,vrbs.g)=-(1-param.rho_tau)*param.phi_taux*param.gy_ratio;                                    
A(vrbs.tau,vrbs.gamma)=-(1-param.rho_tau)*param.phi_taux;
A(vrbs.tau,vrbs.tau_shock)=-1;

%% 4. R_k - Jump
B(vrbs.R_k, vrbs.R_k) = -(param.xi_a^(-1) + 1);
A(vrbs.R_k, vrbs.k) = 1;
B(vrbs.R_k, vrbs.N) = 1;
A(vrbs.R_k, vrbs.gamma) = -1;
B(vrbs.R_k, vrbs.w_r) = 1;

%% 5. P_m - Jump
A(vrbs.P_m, vrbs.P_m) = -param.rho*param.beta*param.gamma^(-param.sigma);
A(vrbs.P_m, vrbs.R) = 1;
B(vrbs.P_m, vrbs.P_m) = -1;

%% 6. Gamma - Jump
B(vrbs.Gamma, vrbs.Gamma) = -1;
B(vrbs.Gamma, vrbs.y) = 1/param.theta_p;
B(vrbs.Gamma, vrbs.w_r) = -(1-1/param.theta_p)*(1-param.F_y_ratio) * (1-param.alpha);
B(vrbs.Gamma, vrbs.R_k) = -(1-1/param.theta_p)*(1-param.F_y_ratio) * param.alpha + param.R_K /param.yk_ratio*param.gamma^(-1);                
B(vrbs.Gamma, vrbs.k) =  param.R_K / param.yk_ratio*param.gamma^(-1);
B(vrbs.Gamma, vrbs.i) = -param.ik_ratio / param.yk_ratio;

%% 7. c - Jump
B(vrbs.c, vrbs.N) = -param.xi_v;
B(vrbs.c, vrbs.c) = param.sigma*(1+param.b*param.gamma^(-1))/(1-param.b*param.gamma^(-1));
B(vrbs.c, vrbs.c_lag) = -param.sigma*param.b*param.gamma^(-1)/(1-param.b*param.gamma^(-1));
A(vrbs.c, vrbs.R) = -1;                                                                                                                     
A(vrbs.c, vrbs.pi) = 1;
A(vrbs.c, vrbs.gamma) = -param.sigma*((1-param.rho_gamma)/(1-param.beta*param.gamma^(-1)) - param.rho_gamma);                                  
A(vrbs.c, vrbs.N) = -param.xi_v;
A(vrbs.c, vrbs.c) = param.sigma/(1-param.beta*param.gamma^(-1));                                                                           
A(vrbs.c, vrbs.xi) = -param.rho_xi - 1;

%% 8. w_r - Jump
c_1w = -(param.xi_v - param.xi_vv)*param.theta_w + 1 + param.xi_w ^ (-1) + param.xi_w^(-1)*param.beta*param.gamma^(1-param.sigma);
c_2w = param.xi_w^(-1)*(1+param.beta*param.gamma^(1-param.sigma)*param.iota_w - param.xi_w*(1-param.b*param.gamma^(-1))^(-1));
c_3w = param.xi_v - param.xi_vv;
B(vrbs.w_r, vrbs.w_r) = c_3w-c_1w;
B(vrbs.w_r, vrbs.N) = -c_3w;
B(vrbs.w_r, vrbs.c) = 1 /(1-param.b*param.gamma^(-1));
B(vrbs.w_r, vrbs.c_lag) = -(param.b*param.gamma^(-1))/(1-param.b*param.gamma^(-1));
B(vrbs.w_r, vrbs.w_r_lag) = param.xi_w^(-1);
B(vrbs.w_r, vrbs.pi_lag) = param.xi_w^(-1) * param.iota_w;
B(vrbs.w_r, vrbs.gamma) = param.xi_w^(-1) * param.iota_w;                                                                                      
B(vrbs.w_r, vrbs.pi) = param.xi_w^(-1) * (1 + param.beta*param.gamma^(1-param.sigma)*param.iota_w);
A(vrbs.w_r, vrbs.gamma) = c_2w;
A(vrbs.w_r, vrbs.w_r) = -param.xi_w^(-1) * param.beta * param.gamma^(1-param.sigma);
A(vrbs.w_r, vrbs.pi) = -param.xi_w^(-1) * param.beta * param.gamma^(1-param.sigma);
A(vrbs.w_r, vrbs.gamma) = -param.xi_w^(-1) * param.beta * param.gamma^(1-param.sigma) * param.rho_gamma;
A(vrbs.w_r, vrbs.theta_w) = 1/(param.theta_w - 1);

%% 9. pi - Jump
B(vrbs.pi, vrbs.pi) = -1;
B(vrbs.pi, vrbs.w_r) = param.xi_p * (1 - param.alpha);
B(vrbs.pi, vrbs.R_k) = param.xi_p * param.alpha;
A(vrbs.pi, vrbs.theta_p) = param.xi_p/(param.theta_p - 1);
B(vrbs.pi, vrbs.pi_lag) = param.iota_p;
A(vrbs.pi, vrbs.pi) = -param.beta * param.gamma^(1-param.sigma);                                                                            
A(vrbs.pi, vrbs.pi) = param.beta * param.gamma^(1-param.sigma);

%% 10. b_m - State
A(vrbs.b_m, vrbs.b_m) = param.P_m;
B(vrbs.b_m, vrbs.b_m) = param.beta^(-1)*param.gamma^(param.sigma - 1)*param.P_m;
B(vrbs.b_m, vrbs.pi) = -param.beta^(-1)*param.gamma^(param.sigma - 1)*param.by_ratio;                                                
A(vrbs.b_m, vrbs.gamma) = param.beta^(-1)*param.gamma^(param.sigma - 1)*param.by_ratio;
B(vrbs.b_m, vrbs.P_m) = (param.rho/param.gamma - 1)*param.by_ratio;
A(vrbs.b_m, vrbs.tau) = 1;
A(vrbs.b_m, vrbs.g) = -param.gy_ratio;

%% 11. k - State
A(vrbs.k,vrbs.k)=1;
B(vrbs.k,vrbs.k)=(1-param.delta)*param.gamma^(-1);
B(vrbs.k,vrbs.gamma)=-(1-param.delta)*param.gamma^(-1);
B(vrbs.k,vrbs.mu)=1-(1-param.delta)*param.gamma^(-1);
B(vrbs.k,vrbs.i_lag)=1-(1-param.delta)*param.gamma^(-1);

%% 12. y - Jump
B(vrbs.y, vrbs.y) = -1;
B(vrbs.y, vrbs.c) = param.cy_ratio;
B(vrbs.y, vrbs.i) = param.iy_ratio;
A(vrbs.y, vrbs.g) = param.gy_ratio;                                                                                                  
B(vrbs.y, vrbs.R_k) = param.R_K * param.gamma^(-1) / param.yk_ratio * param.xi_a^(-1);

%% 13. i - Jump
B(vrbs.i, vrbs.P_k) = -1;
A(vrbs.i, vrbs.mu) = 1;
B(vrbs.i, vrbs.i) = param.xi_I^(-1)*(1+param.beta*param.gamma^(1-param.sigma));
B(vrbs.i, vrbs.i_lag) = -param.xi_I^(-1);
A(vrbs.i, vrbs.gamma) = -(1-param.beta*param.gamma^(1-param.sigma)*param.rho)*param.xi_I^(-1);
A(vrbs.i, vrbs.i) = param.beta*param.gamma^(1-param.sigma)*param.xi_I^(-1);
%A(vrbs.i, vrbs.i_lag) = - param.beta*param.gamma^(1-param.sigma);                                                                           
%A(vrbs.i, vrbs.gamma) = param.beta*param.gamma^(1-param.sigma)*param.rho;

%% 14. P_k - Jump
A(vrbs.P_k, vrbs.R_k) = 1 - param.beta*param.gamma^(-param.sigma)*(1-param.delta);                                                                
A(vrbs.P_k, vrbs.pi) = 1;
A(vrbs.P_k, vrbs.R) = -1;
A(vrbs.P_k, vrbs.P_k) = param.beta * param.gamma^(-param.sigma)*(1-param.delta);
B(vrbs.P_k, vrbs.P_k) = 1;


%% SHOCKS %%

%% 15. TFP shock
A(vrbs.gamma,vrbs.gamma)=1;
B(vrbs.gamma,vrbs.gamma)=param.rho_gamma;
C(vrbs.gamma,shocks.gamma)=param.sigma_gamma;

%% 16. labor supply shock
A(vrbs.theta_w,vrbs.theta_w)=1;
B(vrbs.theta_w,vrbs.theta_w)=param.rho_theta_w;
C(vrbs.theta_w,shocks.theta_w)=param.sigma_theta_w;

%% 17. Investment shock
A(vrbs.mu,vrbs.mu)=1;
B(vrbs.mu,vrbs.mu)=param.rho_mu;
C(vrbs.mu,shocks.mu)=param.sigma_mu;

%% 18. government spending shock
A(vrbs.g,vrbs.g)=1;
B(vrbs.g,vrbs.g)=param.rho_g;
C(vrbs.g,shocks.g)=param.sigma_g;

%% 19. preferences shock
A(vrbs.xi,vrbs.xi)=1;
B(vrbs.xi,vrbs.xi)=param.rho_xi;
C(vrbs.xi,shocks.xi)=param.sigma_xi;

%% 20. Inflation target shock
A(vrbs.pistar,vrbs.pistar)=1;
B(vrbs.pistar,vrbs.pistar)=param.rho_pistar;
C(vrbs.pistar,shocks.pistar)=param.sigma_pistar;

%% 21. cost-push shock
A(vrbs.theta_p,vrbs.theta_p)=1;
B(vrbs.theta_p,vrbs.theta_p)=param.rho_theta_p;
C(vrbs.theta_p,shocks.theta_p)=param.sigma_theta_p;

%% 22. policy shock
A(vrbs.m,vrbs.m)=1;
B(vrbs.m,vrbs.m)=param.rho_m;
C(vrbs.m,shocks.m)=param.sigma_m;

%% 23. tax shock
A(vrbs.tau_shock,vrbs.tau_shock)=1;
B(vrbs.tau_shock,vrbs.tau_shock)=param.rho_tau_hat;
C(vrbs.tau_shock,shocks.tau)=param.sigma_tau_hat;

%% LAGS %%

%% 24. c_lag
A(vrbs.c_lag, vrbs.c_lag) = 1;
B(vrbs.c_lag, vrbs.c) = 1;

%% 25. w_r_lag
A(vrbs.w_r_lag, vrbs.w_r_lag) = 1;
B(vrbs.w_r_lag, vrbs.w_r) = 1;

%% 26. pi_lag
A(vrbs.pi_lag, vrbs.pi_lag) = 1;
B(vrbs.pi_lag, vrbs.pi) = 1;

%% 27. i_lag
A(vrbs.i_lag, vrbs.i_lag) = 1;
B(vrbs.i_lag, vrbs.i) = 1;


end

