
function [xi_0,P_0,kini] = KF_initializeB_fun(param,vrbs,vrbs_obs,Y_data_ini,F,Q)

%% Initialization of Kalman filter



% Initial conditions

xi_0 = zeros(size(F,2),1);



% Precision matrix

if param.Pini == 0
    
    P_0 = (1/param.mult)*eye(size(F,2));
    
    
else
    
    Fp = F;
    
    Fp([vrbs.infl vrbs.pibar vrbs.fe],vrbs.fe) = ...
        (1/k_pini)*[(1-param.gammap)*param.Tpi
        1
        -(1-param.Tpi)*(1-param.gammap)];
    
    P_0 = mult*(Fp*real(lyapcsd(Fp,Q))*Fp'+Q);
    
    
end






