function [Omega Omega_epsilon] = getVAR(D,F,G,H,vrbs,type)
% getVAR.m
% This function takes the matrices outputted from Reds-Solds outputs the
% coefficient matrices to VAR form by shifting around rows as necessary.

% Count number of lag variables
variables=fields(vrbs);
nvar=size(variables,1);
nLagVars=0;
for variable=1:nvar
    if strcmp(type.(variables{variable}),'lag state');
        nLagVars=nLagVars+1;
    end
end

% add all non-lag states to Omega
Omega=G(1:end-nLagVars,:);
Omega_epsilon=H(1:end-nLagVars,:);

nColumnAdd=0;

for variable=1:nvar
    if strcmp(type.(variables{variable}),'jump');
        Omega         = [D(vrbs.(variables{variable}),:); Omega];
        Omega_epsilon =[F(vrbs.(variables{variable}),:); Omega_epsilon];
        nColumnAdd    = nColumnAdd+1;
    end
end

Omega=[zeros(size(Omega,1),nColumnAdd) Omega(:,1:end-nLagVars)];
end

