function [vrbs, type, shocks, nvar, nstate, nshock, nlag] = defineVariables()
% This function outputs the following:
% vrbs: a structure containing the position of all variables (with jump
% variables ordered before state variables)
% nvar: the total number of variables (size of vrbs)
% nstate: the number of state variables

% jump variables
vrbs.N     = 1            ;  type.N     = 'jump';
vrbs.R_k   = 2            ;  type.R_k   = 'jump';
vrbs.P_m   = 3            ;  type.P_m   = 'jump';
vrbs.Gamma = 4            ;  type.Gamma = 'jump';
vrbs.y     = 5            ;  type.y     = 'jump'; 
vrbs.P_k   = 6            ;  type.P_k   = 'jump';
vrbs.c     = 7            ;  type.c     = 'jump'; % jump and state
vrbs.w_r   = 8            ;  type.w_r   = 'jump'; % jump and state
vrbs.pi    = 9            ;  type.pi    = 'jump'; % jump and state
vrbs.i     = 10           ;  type.i     = 'jump'; % jump and state
njump = 10;

% state variables
vrbs.R         = njump + 1 ;  type.R         = 'state';
vrbs.tau       = njump + 2 ;  type.tau       = 'state';
vrbs.b_m       = njump + 3 ;  type.b_m       = 'state';
vrbs.k         = njump + 4 ;  type.k         = 'state';
vrbs.gamma     = njump + 5 ;  type.gamma     = 'state';
vrbs.theta_w   = njump + 6;  type.theta_w    = 'state';
vrbs.mu        = njump + 7;  type.mu         = 'state';
vrbs.g         = njump + 8;  type.g          = 'state';
vrbs.xi        = njump + 9;  type.xi         = 'state';
vrbs.pistar    = njump + 10;  type.pistar    = 'state';
vrbs.theta_p   = njump + 11;  type.theta_p   = 'state';
vrbs.m         = njump + 12;  type.m         = 'state';
vrbs.tau_shock = njump + 13;  type.tau_shock = 'state';
vrbs.c_lag     = njump + 14;  type.c_lag     = 'lag state';
vrbs.w_r_lag   = njump + 15;  type.w_r_lag   = 'lag state';
vrbs.pi_lag    = njump + 16;  type.pi_lag    = 'lag state';
vrbs.i_lag     = njump + 17;  type.i_lag     = 'lag state';

nlag   = 4;
nstate = 17;


% shocks
shocks.gamma = 1;
shocks.theta_w = 2;
shocks.mu = 3;
shocks.g = 4;
shocks.xi = 5;
shocks.pistar = 6;
shocks.theta_p = 7;
shocks.m = 8;
shocks.tau = 9;
nshock = 9;

nvar = nstate + njump;

end

