
clear; %close all;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Options and Settings                                                %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% Specs: choose Model
% Note: each model is defined as a set of model-specific functions stored
%       in the folder "Modelspecs".

% Model name list (so far):
% BGG: model with financial frictions
% SW: Smet and Wouters 2007
% SWSp: SW + spreads 

Mspec = 'SW'; 

learning = 0; % Set zero to use RE model

% Session: using saved results?
newfilename = 0; % set 1 for you are not using any save data 

% Operations 

Printpriors = 0; % displays and print priors

Mode = 0;
    iter = 2;
    n_ests = 1;
    randomize = 0; % random initial conditions
    use_previous = 0; % use previous estimate. Need to give a filename
        previous_estimate_name = ['02-Jun-2016_1722Est_2'];

Hessian = 0;

Metropolis = 0;
    useCovdraws = 0;
    csquare_proposed = 0.25; % leave empty if using csquare associated to 
                             %  saved empirical covariance of draws
    ndraws = 100000;
    finetune = 0; % finetune csquare
    Printposteriors = 0; % XX To be added
    PosteriorsTable = 0; % XX To be added

% Stats and Preds

    % Select observables and states for plots/tables
    
    % Observables (use name in vrbs_obs)
    namesVrbs_obs = cell(3,1);
    namesVrbs_obs{1} = 'Inflation';
    namesVrbs_obs{2} = 'FedFunds';
    namesVrbs_obs{3} = 'Hours';
    
    % States (use name in vrbs)
    namesVrbs = cell(1,1);
    namesVrbs{1} = 'y';

    % Select shocks/groups of shocks for variance/shocks
    % decomposition/countefactuals
    % Note: this is model-dependent
    
     nonzeroshocklist = {'theta_w';'mu';'g';'theta_p';'m';'b';'a'}; % select shock with nonzero variance (use names in shocks)
                         % Note: check model's shock in the 'setparams' file (Modelspecs folder) 
         groupShock = 1; % Select if you want to group shocks or use individual (nonzero) shocks
         Group = {char('a');char('mu','g','b');char('m');char('theta_w','theta_p')};               
         groupNames = cell(size(Group,1),1);
         groupNames{1} = 'Productivity';
         groupNames{2} = 'Demand';
         groupNames{3} = 'Monetary Policy';
         groupNames{4} = 'Mark-ups';
    
    
Stats = 1;
    Mode_onlyStats = 1;
    ImpResp = 0;
        ImpHor = 100;
    VarDec = 1;
         nsim = 101; % total forecast horizons for conditional variance
         list_periods = [1,2,4,8,15,25,35,40,100]; % identify the fct horizons to be plotted/in Tables. 
         CondVarFigs = 1;
         

        
Preds = 1;
    Mode_onlyPreds = 1;
          ShockDec = 0;
    CarterKohn = 0;

    
    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% Set up and add paths
addpath Model Priors RedsSolds IRFs Estimation Modelspecs VarDecShockDec FiltersSmoothers;

cpath = pwd;
if isunix, pathslash = '/'; else pathslash = '\'; end
 ind = strfind(cpath, 'Code');
 spath = [cpath(1,1:ind-1),'Save', pathslash];
 dpath = [cpath(1,1:ind-1),'Data', pathslash];

 % add Data to datapath
 Dataadd = dpath(1:end-1);
 addpath(Dataadd);    
    
 
 %Saved results 
 
if newfilename 
timestamp_raw = datestr(now); 
timestamp = [timestamp_raw(1:11) '_' timestamp_raw(13:14), timestamp_raw(16:17)];

else
    
timestamp = '28-Jul-2016_1359';
    
end

filetag = ['_', num2str(iter)]; 
%name = ['DGS_corrinvnobgg'];
name = Mspec;
cmts = []; 
EstimationName = [name,cmts,filetag]; 
 
%% Get data 

% time parameters (check excel source for sample information)
startDate = 1964.0;
endDate = 2008.5;
trainingSampleLength = 0; % SW pre-sample from Dynare;
preSampleLength = 0;


% get indices for observables
[vrbs_obs,nobs] = defineObservables();

[~,Y_pre,startSample, endSample,observableNames] = loadData(preSampleLength,startDate,endDate, vrbs_obs,nobs, dpath);

% use SmetsWouters original data
% startDate = 1959.25;
% SWData 
% 
% Y_main = SW_data(32:end,:); % start in 1965: this is as close as possible to the original estimation 

% use DGS original data

load DGS

if strcmp('SW', Mspec) 
DGS_data(:,8) = NaN(size(DGS_data(:,8)));
end

Y_main = DGS_data(1:end-16,:); % ends 2008.5
%Y_main = DGS_data(80:end-16,:); % 1984-2008.5

%% Define model variables and parameters

[vrbs, type, shocks,shocks_oe, ModelDim,estimate] = eval(['defineVariables',Mspec,'()']);


if learning

    Sml = CreateSelection(vrbs,estimate,ModelDim);
    
 else
    
    Sml = NaN;

end

% Add nobs to model dim structure
 
 ModelDim.nobs = nobs;

 
% set parameters values
[params, params_index, params_fixed,trspec,bounds] = eval(['setParams',Mspec,'()']);



% get parameters to be estimated
[params_estimated_index, params_estimated] = setEstimatedParamsv1(params, params_index, params_fixed);

% get priors
priors = eval(['definePriors',Mspec,'(params_fixed, params_index)']);


if Printpriors
    
    testPriors(priors);
    
end   

%return % this to run showme
%% Find mode

if Mode

findMode; % XX might want to re-run the function if opt did not converge (like DSGE)

end


% if Select_Mode  XX IN PROGRESS (if use multiple iterations)
%    
% ModeLooop    
% 
% end    
    

if Hessian

    % Load mode
   if (~exist('xmode','var')); % XX OK, WHAT DO WE WANT TO LOAD?
    
    try %XX LOAD
       load([spath,...
    'Mode',pathslash,...
    [timestamp,EstimationName]],'xmode');   
    catch ME
    
    disp('Hessian: xmode not found');    
        
    end
    
   end
   
   ComputeHessian;
   
end


if Metropolis
    
 if (~exist('xmode','var')) || (~exist('sigscaleHess','var')) ; % XX OK, WHAT DO WE WANT TO LOAD?
 
     if useCovdraws
     
     try
 load([spath,...
    'Mode',pathslash,...
    [timestanp,EstimationName]],'xmode','X_draws', 'Logpost_draws','csquare');    
    
    catch ME
        
       disp('Metropolis: xmode or XX not found');    

    end %try
    
         
     else     
         
         
    try
 load([spath,...
    'Mode',pathslash,...
    [timestamp,EstimationName]],'xmode','Logpostmode','sigscaleHess');    
    
    catch ME
        
       disp('Metropolis: xmode or sigscaleHess not found');    

    end %try
    
     end % if useCovdraws
    
 end % if `exists


ComputeMetropolis


end


if Stats

Compute_statsv1
    
end    


if Preds
    
   
Compute_Preds    

end    






